/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.favoritesTreeView.FavoritesViewTreeBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.ui.CommonActionsPanel;
import java.util.Set;

public class EditFavoritesAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        FavoritesViewTreeBuilder treeBuilder = (FavoritesViewTreeBuilder)((Object)FavoritesTreeViewPanel.FAVORITES_TREE_BUILDER_KEY.getData(e.getDataContext()));
        String listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(e.getDataContext());
        if (project == null || treeBuilder == null || listName == null) {
            return;
        }
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project);
        FavoritesListProvider provider = favoritesManager.getListProvider(listName);
        Set selection = treeBuilder.getSelectedElements();
        if (provider != null && provider.willHandle(CommonActionsPanel.Buttons.EDIT, project, selection)) {
            provider.handle(CommonActionsPanel.Buttons.EDIT, project, selection, treeBuilder.getTree());
            return;
        }
        favoritesManager.renameList(project, listName);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setText(CommonActionsPanel.Buttons.EDIT.getText());
        e.getPresentation().setIcon(CommonActionsPanel.Buttons.EDIT.getIcon());
        e.getPresentation().setEnabled(true);
        Project project = e.getProject();
        FavoritesViewTreeBuilder treeBuilder = (FavoritesViewTreeBuilder)((Object)FavoritesTreeViewPanel.FAVORITES_TREE_BUILDER_KEY.getData(e.getDataContext()));
        String listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(e.getDataContext());
        if (project == null || treeBuilder == null || listName == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project);
        FavoritesListProvider provider = favoritesManager.getListProvider(listName);
        Set selection = treeBuilder.getSelectedElements();
        if (provider != null) {
            e.getPresentation().setEnabled(provider.willHandle(CommonActionsPanel.Buttons.EDIT, project, selection));
            e.getPresentation().setText(provider.getCustomName(CommonActionsPanel.Buttons.EDIT));
        }
    }
}

