/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoritesAutoscrollFromSourceHandler;
import com.intellij.ide.favoritesTreeView.FavoritesComparator;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListener;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesRootNode;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesTreeStructure;
import com.intellij.ide.favoritesTreeView.FavoritesTreeUtil;
import com.intellij.ide.favoritesTreeView.FavoritesViewTreeBuilder;
import com.intellij.ide.favoritesTreeView.actions.AddToFavoritesAction;
import com.intellij.ide.favoritesTreeView.actions.DeleteFromFavoritesAction;
import com.intellij.ide.favoritesTreeView.actions.EditFavoritesAction;
import com.intellij.ide.favoritesTreeView.actions.FavoritesAbbreviatePackageNamesAction;
import com.intellij.ide.favoritesTreeView.actions.FavoritesAutoScrollToSourceAction;
import com.intellij.ide.favoritesTreeView.actions.FavoritesCompactEmptyMiddlePackagesAction;
import com.intellij.ide.favoritesTreeView.actions.FavoritesFlattenPackagesAction;
import com.intellij.ide.favoritesTreeView.actions.FavoritesShowMembersAction;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FavoritesTreeViewPanel
extends JPanel
implements DataProvider,
DockContainer {
    private final FavoritesTreeStructure myFavoritesTreeStructure;
    private FavoritesViewTreeBuilder myBuilder;
    private final CopyPasteDelegator myCopyPasteDelegator;
    private final MouseListener myTreePopupHandler;
    public static final DataKey<FavoritesTreeNodeDescriptor[]> CONTEXT_FAVORITES_ROOTS_DATA_KEY = DataKey.create((String)"FavoritesRoot");
    public static final DataKey<DnDAwareTree> FAVORITES_TREE_KEY = DataKey.create((String)"Favorites.Tree");
    public static final DataKey<FavoritesViewTreeBuilder> FAVORITES_TREE_BUILDER_KEY = DataKey.create((String)"Favorites.Tree.Builder");
    public static final DataKey<String> FAVORITES_LIST_NAME_DATA_KEY = DataKey.create((String)"FavoritesListName");
    protected Project myProject;
    protected DnDAwareTree myTree;
    private final MyDeletePSIElementProvider myDeletePSIElementProvider = new MyDeletePSIElementProvider();
    private final ModuleDeleteProvider myDeleteModuleProvider = new ModuleDeleteProvider();
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final IdeView myIdeView = new MyIdeView();
    private final FavoritesManager myFavoritesManager;

    public FavoritesTreeViewPanel(Project project) {
        super(new BorderLayout());
        this.myProject = project;
        this.myFavoritesManager = FavoritesManager.getInstance(this.myProject);
        this.myFavoritesTreeStructure = new FavoritesTreeStructure(project);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        root.setUserObject(this.myFavoritesTreeStructure.getRootElement());
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.myTree = new DnDAwareTree(treeModel);
        this.myBuilder = new FavoritesViewTreeBuilder(this.myProject, (JTree)((Object)this.myTree), treeModel, this.myFavoritesTreeStructure);
        DockManager.getInstance((Project)project).register((DockContainer)this);
        TreeUtil.installActions((JTree)((Object)this.myTree));
        UIUtil.setLineStyleAngled((JTree)((Object)this.myTree));
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setLargeModel(true);
        new TreeSpeedSearch((JTree)((Object)this.myTree));
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.myTree));
        final FavoritesComparator favoritesComparator = new FavoritesComparator(ProjectView.getInstance(project), "Favorites");
        this.myBuilder.setNodeDescriptorComparator(new Comparator<NodeDescriptor>(){

            @Override
            public int compare(NodeDescriptor o1, NodeDescriptor o2) {
                FavoritesListNode listNode2;
                FavoritesListNode listNode1;
                if (o1 instanceof FavoritesTreeNodeDescriptor && o2 instanceof FavoritesTreeNodeDescriptor && (listNode1 = FavoritesTreeUtil.extractParentList((FavoritesTreeNodeDescriptor)o1)).equals((Object)(listNode2 = FavoritesTreeUtil.extractParentList((FavoritesTreeNodeDescriptor)o2)))) {
                    Comparator<FavoritesTreeNodeDescriptor> comparator = FavoritesTreeViewPanel.this.myFavoritesManager.getCustomComparator(listNode1.getName());
                    if (comparator != null) {
                        return comparator.compare((FavoritesTreeNodeDescriptor)o1, (FavoritesTreeNodeDescriptor)o2);
                    }
                    return favoritesComparator.compare(o1, o2);
                }
                return o1.getIndex() - o2.getIndex();
            }
        });
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode node;
                Object userObject;
                super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
                if (value instanceof DefaultMutableTreeNode && (userObject = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof FavoritesTreeNodeDescriptor) {
                    String location;
                    FavoritesTreeNodeDescriptor favoritesTreeNodeDescriptor = (FavoritesTreeNodeDescriptor)((Object)userObject);
                    AbstractTreeNode treeNode = favoritesTreeNodeDescriptor.getElement();
                    FavoritesListProvider provider = FavoritesTreeUtil.getProvider(FavoritesTreeViewPanel.this.myFavoritesManager, favoritesTreeNodeDescriptor);
                    if (provider != null) {
                        Object o = FavoritesTreeViewPanel.this.myBuilder.getUi().getElementFor(value);
                        if (o instanceof AbstractTreeNode) {
                            o = ((AbstractTreeNode)o).getValue();
                        }
                        provider.customizeRenderer((ColoredTreeCellRenderer)this, tree, o, selected, expanded, leaf, row, hasFocus);
                        return;
                    }
                    PresentationData presentation = treeNode.getPresentation();
                    String locationString = presentation.getLocationString();
                    if (locationString == null && node.getParent() != null && node.getParent().getParent() != null && node.getParent().getParent().getParent() == null && (location = favoritesTreeNodeDescriptor.getLocation()) != null && location.length() > 0) {
                        this.append(" (" + location + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                }
            }
        });
        this.myTreePopupHandler = CustomizationUtil.installPopupHandler((JComponent)((Object)this.myTree), "FavoritesViewPopupMenu", "FavoritesPopup");
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this.myTree));
        EditSourceOnEnterKeyHandler.install((JTree)((Object)this.myTree));
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, this){

            @Override
            @NotNull
            protected PsiElement[] getSelectedElements() {
                PsiElement[] psiElementArray = FavoritesTreeViewPanel.this.getSelectedPsiElements();
                if (psiElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel$3", "getSelectedElements"));
                }
                return psiElementArray;
            }
        };
        AnActionButton addActionButton = AnActionButton.fromAction((AnAction)ActionManager.getInstance().getAction("AddNewFavoritesList"));
        addActionButton.getTemplatePresentation().setIcon(CommonActionsPanel.Buttons.ADD.getIcon());
        addActionButton.setShortcut(CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD));
        AnActionButton editActionButton = AnActionButton.fromAction((AnAction)new EditFavoritesAction());
        editActionButton.setShortcut(CommonShortcuts.CTRL_ENTER);
        DeleteFromFavoritesAction deleteActionButton = new DeleteFromFavoritesAction();
        deleteActionButton.setShortcut(CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.REMOVE));
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)((Object)this.myTree)).initPosition().disableAddAction().disableRemoveAction().disableDownAction().disableUpAction().addExtraAction(addActionButton).addExtraAction(editActionButton).addExtraAction((AnActionButton)deleteActionButton);
        AnAction action = ActionManager.getInstance().getAction("NewElement");
        action.registerCustomShortcutSet(action.getShortcutSet(), (JComponent)((Object)this.myTree));
        JPanel panel = decorator.createPanel();
        panel.setBorder(IdeBorderFactory.createEmptyBorder());
        this.add((Component)panel, "Center");
        this.setBorder(IdeBorderFactory.createEmptyBorder());
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return FavoritesTreeViewPanel.this.myFavoritesManager.getViewSettings().isAutoScrollToSource();
            }

            protected void setAutoScrollMode(boolean state2) {
                FavoritesTreeViewPanel.this.myFavoritesManager.getViewSettings().setAutoScrollToSource(state2);
            }
        };
        this.myAutoScrollToSourceHandler.install((JTree)((Object)this.myTree));
        this.myFavoritesManager.addFavoritesListener(new FavoritesListener(){

            @Override
            public void rootsChanged() {
                FavoritesTreeViewPanel.this.myBuilder.updateFromRoot();
                FavoritesTreeViewPanel.this.myTree.repaint();
            }

            @Override
            public void listAdded(String listName) {
                FavoritesTreeViewPanel.this.myBuilder.updateFromRoot();
                FavoritesTreeViewPanel.this.myTree.repaint();
            }

            @Override
            public void listRemoved(String listName) {
                FavoritesTreeViewPanel.this.myBuilder.updateFromRoot();
                FavoritesTreeViewPanel.this.myTree.repaint();
            }
        });
    }

    private ExporterToTextFile createTextExporter() {
        return new ExporterToTextFile(){

            public JComponent getSettingsEditor() {
                return null;
            }

            public void addSettingsChangedListener(ChangeListener listener) throws TooManyListenersException {
            }

            public void removeSettingsChangedListener(ChangeListener listener) {
            }

            public String getReportText() {
                final StringBuilder sb = new StringBuilder();
                Object[] elements = FavoritesTreeViewPanel.this.myBuilder.getStructure().getChildElements(FavoritesTreeViewPanel.this.myBuilder.getRoot());
                TreeUtil.Traverse traverse = new TreeUtil.Traverse(){

                    public boolean accept(Object node) {
                        if (node instanceof LoadingNode) {
                            return true;
                        }
                        AbstractTreeNode abstractTreeNode = (AbstractTreeNode)node;
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        int deepLevel = this.getDeepLevel((AbstractTreeNode)node);
                        for (int i = 1; i < deepLevel; ++i) {
                            sb.append('\t');
                        }
                        abstractTreeNode.update();
                        PresentationData presentation = abstractTreeNode.getPresentation();
                        sb.append(presentation.getPresentableText());
                        String locationString = presentation.getLocationString();
                        if (locationString == null) {
                            locationString = FavoritesTreeNodeDescriptor.getLocation(abstractTreeNode, FavoritesTreeViewPanel.this.myProject);
                        }
                        if (locationString != null) {
                            sb.append(" (").append(locationString).append(")");
                        }
                        return true;
                    }

                    public int getDeepLevel(AbstractTreeNode node) {
                        int result = 0;
                        while (node.getParent() != null) {
                            ++result;
                            node = node.getParent();
                        }
                        return result;
                    }
                };
                for (Object element : elements) {
                    FavoritesTreeViewPanel.traverseDepth((AbstractTreeNode)element, traverse);
                }
                return sb.toString();
            }

            public String getDefaultFilePath() {
                return FavoritesTreeViewPanel.this.myProject.getBasePath() + File.separator + "Favorites.txt";
            }

            public void exportedTo(String filePath) {
            }

            public boolean canExport() {
                return true;
            }
        };
    }

    private static boolean traverseDepth(AbstractTreeNode node, TreeUtil.Traverse traverse) {
        if (!traverse.accept((Object)node)) {
            return false;
        }
        Collection children = node.getChildren();
        for (AbstractTreeNode child : children) {
            child.setParent(node);
            if (FavoritesTreeViewPanel.traverseDepth(child, traverse)) continue;
            return false;
        }
        return true;
    }

    public void selectElement(Object selector, VirtualFile file, boolean requestFocus) {
        this.myBuilder.select(selector, file, requestFocus);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myBuilder);
        this.myBuilder = null;
    }

    public DnDAwareTree getTree() {
        return this.myTree;
    }

    @NotNull
    private PsiElement[] getSelectedPsiElements() {
        Object[] elements = this.getSelectedNodeElements();
        if (elements == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel", "getSelectedPsiElements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        block0: for (Object element : elements) {
            if (element instanceof PsiElement) {
                result.add((PsiElement)element);
                continue;
            }
            if (element instanceof SmartPsiElementPointer) {
                PsiElement psiElement = ((SmartPsiElementPointer)element).getElement();
                if (psiElement == null) continue;
                result.add(psiElement);
                continue;
            }
            for (FavoriteNodeProvider provider : (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)this.myProject)) {
                PsiElement psiElement = provider.getPsiElement(element);
                if (psiElement == null) continue;
                result.add(psiElement);
                continue block0;
            }
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel", "getSelectedPsiElements"));
        }
        return psiElementArray;
    }

    public FavoritesTreeStructure getFavoritesTreeStructure() {
        return this.myFavoritesTreeStructure;
    }

    public Object getData(String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            FavoritesTreeNodeDescriptor[] selectedNodeDescriptors = FavoritesTreeUtil.getSelectedNodeDescriptors(this.myTree);
            return selectedNodeDescriptors.length == 1 ? selectedNodeDescriptors[0].getElement() : null;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            List<Navigatable> selectedElements = this.getSelectedElements(Navigatable.class);
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new Navigatable[selectedElements.size()]);
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getPasteProvider();
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.toolWindows.favorites";
        }
        if (LangDataKeys.NO_NEW_ACTION.is(dataId)) {
            return Boolean.TRUE;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiElement[] elements = this.getSelectedPsiElements();
            if (elements.length != 1) {
                return null;
            }
            return elements[0] != null && elements[0].isValid() ? elements[0] : null;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            PsiElement[] elements = this.getSelectedPsiElements();
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            for (PsiElement element : elements) {
                if (!element.isValid()) continue;
                result.add(element);
            }
            return result.isEmpty() ? null : PsiUtilCore.toPsiElementArray(result);
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            return this.myIdeView;
        }
        if (LangDataKeys.TARGET_PSI_ELEMENT.is(dataId)) {
            return null;
        }
        if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
            Module[] selected = this.getSelectedModules();
            return selected != null && selected.length == 1 ? selected[0] : null;
        }
        if (LangDataKeys.MODULE_CONTEXT_ARRAY.is(dataId)) {
            return this.getSelectedModules();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            Object[] elements = this.getSelectedNodeElements();
            return elements != null && elements.length >= 1 && elements[0] instanceof Module ? this.myDeleteModuleProvider : this.myDeletePSIElementProvider;
        }
        if (ModuleGroup.ARRAY_DATA_KEY.is(dataId)) {
            List<ModuleGroup> selectedElements = this.getSelectedElements(ModuleGroup.class);
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new ModuleGroup[selectedElements.size()]);
        }
        if (LibraryGroupElement.ARRAY_DATA_KEY.is(dataId)) {
            List<LibraryGroupElement> selectedElements = this.getSelectedElements(LibraryGroupElement.class);
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new LibraryGroupElement[selectedElements.size()]);
        }
        if (NamedLibraryElement.ARRAY_DATA_KEY.is(dataId)) {
            List<NamedLibraryElement> selectedElements = this.getSelectedElements(NamedLibraryElement.class);
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new NamedLibraryElement[selectedElements.size()]);
        }
        if (CONTEXT_FAVORITES_ROOTS_DATA_KEY.is(dataId)) {
            FavoritesTreeNodeDescriptor[] selectedNodeDescriptors;
            ArrayList<FavoritesTreeNodeDescriptor> result = new ArrayList<FavoritesTreeNodeDescriptor>();
            for (FavoritesTreeNodeDescriptor selectedNodeDescriptor : selectedNodeDescriptors = FavoritesTreeUtil.getSelectedNodeDescriptors(this.myTree)) {
                FavoritesTreeNodeDescriptor root;
                if (FavoritesTreeUtil.getProvider(this.myFavoritesManager, selectedNodeDescriptor) != null || (root = selectedNodeDescriptor.getFavoritesRoot()) == null || !(root.getElement() instanceof FavoritesListNode)) continue;
                result.add(selectedNodeDescriptor);
            }
            return result.toArray(new FavoritesTreeNodeDescriptor[result.size()]);
        }
        if (FAVORITES_TREE_KEY.is(dataId)) {
            return this.myTree;
        }
        if (FAVORITES_TREE_BUILDER_KEY.is(dataId)) {
            return this.myBuilder;
        }
        if (FAVORITES_LIST_NAME_DATA_KEY.is(dataId)) {
            FavoritesTreeNodeDescriptor[] descriptors = FavoritesTreeUtil.getSelectedNodeDescriptors(this.myTree);
            HashSet<Object> selectedNames = new HashSet<Object>();
            for (FavoritesTreeNodeDescriptor descriptor : descriptors) {
                FavoritesListNode node = FavoritesTreeUtil.extractParentList(descriptor);
                if (node == null) continue;
                selectedNames.add(node.getValue());
            }
            if (selectedNames.size() == 1) {
                return selectedNames.iterator().next();
            }
            return null;
        }
        FavoritesTreeNodeDescriptor[] descriptors = FavoritesTreeUtil.getSelectedNodeDescriptors(this.myTree);
        if (descriptors.length > 0) {
            ArrayList<AbstractTreeNode> nodes = new ArrayList<AbstractTreeNode>();
            for (FavoritesTreeNodeDescriptor descriptor : descriptors) {
                nodes.add(descriptor.getElement());
            }
            return this.myFavoritesTreeStructure.getDataFromProviders(nodes, dataId);
        }
        return null;
    }

    private Set<FavoritesListNode> getSelectedListsNodes() {
        FavoritesTreeNodeDescriptor[] descriptors;
        HashSet<FavoritesListNode> result = new HashSet<FavoritesListNode>();
        for (FavoritesTreeNodeDescriptor descriptor : descriptors = FavoritesTreeUtil.getSelectedNodeDescriptors(this.myTree)) {
            FavoritesListNode listNode = FavoritesTreeUtil.extractParentList(descriptor);
            if (listNode == null) continue;
            result.add(listNode);
        }
        return result;
    }

    private <T> List<T> getSelectedElements(Class<T> klass) {
        Object[] elements = this.getSelectedNodeElements();
        ArrayList<Object> result = new ArrayList<Object>();
        if (elements == null) {
            return result;
        }
        for (Object element : elements) {
            if (element == null || !klass.isAssignableFrom(element.getClass())) continue;
            result.add(element);
        }
        return result;
    }

    private Module[] getSelectedModules() {
        Object[] elements = this.getSelectedNodeElements();
        if (elements == null) {
            return null;
        }
        ArrayList<Module> result = new ArrayList<Module>();
        for (Object element : elements) {
            if (element instanceof Module) {
                result.add((Module)element);
                continue;
            }
            if (!(element instanceof ModuleGroup)) continue;
            result.addAll(((ModuleGroup)element).modulesInGroup(this.myProject, true));
        }
        return result.isEmpty() ? null : result.toArray(new Module[result.size()]);
    }

    private Object[] getSelectedNodeElements() {
        FavoritesTreeNodeDescriptor[] selectedNodeDescriptors = FavoritesTreeUtil.getSelectedNodeDescriptors(this.myTree);
        ArrayList<Object> result = new ArrayList<Object>();
        for (FavoritesTreeNodeDescriptor selectedNodeDescriptor : selectedNodeDescriptors) {
            if (selectedNodeDescriptor == null) continue;
            Object value = selectedNodeDescriptor.getElement().getValue();
            if (value instanceof SmartPsiElementPointer) {
                value = ((SmartPsiElementPointer)value).getElement();
            }
            result.add(value);
        }
        return ArrayUtil.toObjectArray(result);
    }

    public void setupToolWindow(ToolWindowEx window) {
        CollapseAllAction collapseAction = new CollapseAllAction((JTree)((Object)this.myTree));
        collapseAction.getTemplatePresentation().setIcon(AllIcons.General.CollapseAll);
        collapseAction.getTemplatePresentation().setHoveredIcon(AllIcons.General.CollapseAllHover);
        window.setTitleActions(new AnAction[]{collapseAction});
        DefaultActionGroup group = new DefaultActionGroup();
        ProjectViewDirectoryHelper helper = ProjectViewDirectoryHelper.getInstance(this.myProject);
        if (helper.supportsFlattenPackages()) {
            group.add((AnAction)new FavoritesFlattenPackagesAction(this.myProject, this.myBuilder));
        }
        if (helper.supportsHideEmptyMiddlePackages()) {
            group.add((AnAction)new FavoritesCompactEmptyMiddlePackagesAction(this.myProject, this.myBuilder));
        }
        if (helper.supportsFlattenPackages()) {
            group.addAction((AnAction)new FavoritesAbbreviatePackageNamesAction(this.myProject, this.myBuilder));
        }
        if (!PlatformUtils.isCidr()) {
            group.add((AnAction)new FavoritesShowMembersAction(this.myProject, this.myBuilder));
        }
        FavoritesAutoscrollFromSourceHandler handler = new FavoritesAutoscrollFromSourceHandler(this.myProject, this.myBuilder);
        handler.install();
        group.add((AnAction)handler.createToggleAction());
        group.add((AnAction)new FavoritesAutoScrollToSourceAction(this.myProject, this.myAutoScrollToSourceHandler, this.myBuilder));
        window.setAdditionalGearActions((ActionGroup)group);
    }

    public static String getQualifiedName(VirtualFile file) {
        return file.getPresentableUrl();
    }

    public FavoritesViewTreeBuilder getBuilder() {
        return this.myBuilder;
    }

    @Nullable
    FavoritesListNode findFavoritesListNode(Point point) {
        TreePath path = this.myTree.getClosestPathForLocation(point.x, point.y);
        FavoritesListNode node = FavoritesTreeViewPanel.getListNodeFromPath(path);
        return node == null ? (FavoritesListNode)((FavoritesRootNode)((Object)this.myFavoritesTreeStructure.getRootElement())).getChildren().iterator().next() : node;
    }

    static FavoritesListNode getListNodeFromPath(TreePath path) {
        AbstractTreeNode node;
        Object obj;
        Object o;
        if (path != null && path.getPathCount() > 1 && (o = path.getPath()[1]) instanceof DefaultMutableTreeNode && (obj = ((DefaultMutableTreeNode)o).getUserObject()) instanceof FavoritesTreeNodeDescriptor && (node = ((FavoritesTreeNodeDescriptor)((Object)obj)).getElement()) instanceof FavoritesListNode) {
            return (FavoritesListNode)node;
        }
        return null;
    }

    void dropPsiElements(FavoritesManager mgr, FavoritesListNode node, PsiElement[] elements) {
        if (elements != null && elements.length > 0) {
            ArrayList<AbstractTreeNode> nodes = new ArrayList<AbstractTreeNode>();
            for (PsiElement element : elements) {
                if (element instanceof SmartPsiElementPointer) {
                    element = ((SmartPsiElementPointer)element).getElement();
                }
                Collection<AbstractTreeNode> tmp = AddToFavoritesAction.createNodes(this.myProject, null, element, true, FavoritesManager.getInstance(this.myProject).getViewSettings());
                nodes.addAll(tmp);
                mgr.addRoots((String)node.getValue(), nodes);
            }
            this.myBuilder.select(nodes.toArray(), null);
        }
    }

    public RelativeRectangle getAcceptArea() {
        return new RelativeRectangle((JComponent)((Object)this.myTree));
    }

    public RelativeRectangle getAcceptAreaFallback() {
        return this.getAcceptArea();
    }

    @NotNull
    public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent content, RelativePoint point) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel", "getContentResponse"));
        }
        if (content.getKey() instanceof VirtualFile) {
            DockContainer.ContentResponse contentResponse = DockContainer.ContentResponse.ACCEPT_COPY;
            if (contentResponse == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel", "getContentResponse"));
            }
            return contentResponse;
        }
        DockContainer.ContentResponse contentResponse = DockContainer.ContentResponse.DENY;
        if (contentResponse == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel", "getContentResponse"));
        }
        return contentResponse;
    }

    public JComponent getContainerComponent() {
        return this;
    }

    public void add(@NotNull DockableContent content, RelativePoint dropTarget) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel", "add"));
        }
        if (content.getKey() instanceof VirtualFile) {
            VirtualFile vFile = (VirtualFile)content.getKey();
            PsiDirectory psiFile = vFile.isDirectory() ? PsiManager.getInstance((Project)this.myProject).findDirectory(vFile) : PsiManager.getInstance((Project)this.myProject).findFile(vFile);
            Point p = dropTarget.getScreenPoint();
            SwingUtilities.convertPointFromScreen(p, (Component)((Object)this.myTree));
            FavoritesListNode node = this.findFavoritesListNode(p);
            if (node != null && psiFile != null) {
                this.dropPsiElements(this.myFavoritesManager, node, new PsiElement[]{psiFile});
            }
        }
    }

    public void closeAll() {
    }

    public void addListener(DockContainer.Listener listener, Disposable parent) {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public boolean isEmpty() {
        return this.myTree.isEmpty();
    }

    @Nullable
    public Image startDropOver(@NotNull DockableContent content, RelativePoint point) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel", "startDropOver"));
        }
        return null;
    }

    @Nullable
    public Image processDropOver(@NotNull DockableContent content, RelativePoint point) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel", "processDropOver"));
        }
        Point p = point.getScreenPoint();
        SwingUtilities.convertPointFromScreen(p, (Component)((Object)this.myTree));
        TreePath treePath = this.myTree.getClosestPathForLocation(p.x, p.y);
        FavoritesListNode node = FavoritesTreeViewPanel.getListNodeFromPath(treePath);
        TreePath treePath2 = treePath = node != null ? this.myTree.getPath((PresentableNodeDescriptor)node) : null;
        if (treePath != null) {
            this.myTree.setSelectionPath(treePath);
        }
        return null;
    }

    public void resetDropOver(@NotNull DockableContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel", "resetDropOver"));
        }
    }

    public boolean isDisposeWhenEmpty() {
        return false;
    }

    public void showNotify() {
    }

    public void hideNotify() {
    }

    private final class MyIdeView
    implements IdeView {
        private MyIdeView() {
        }

        public void selectElement(PsiElement element) {
            if (element != null) {
                Editor editor;
                this.selectPsiElement(element, false);
                boolean requestFocus = true;
                boolean isDirectory = element instanceof PsiDirectory;
                if (!isDirectory && (editor = EditorHelper.openInEditor(element)) != null) {
                    ToolWindowManager.getInstance((Project)FavoritesTreeViewPanel.this.myProject).activateEditorComponent();
                    requestFocus = false;
                }
                if (requestFocus) {
                    this.selectPsiElement(element, true);
                }
            }
        }

        private void selectPsiElement(PsiElement element, boolean requestFocus) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
            FavoritesTreeViewPanel.this.selectElement(element, virtualFile, requestFocus);
        }

        @Nullable
        private PsiDirectory[] getSelectedDirectories() {
            PsiDirectory[] psiDirectoryArray;
            if (FavoritesTreeViewPanel.this.myBuilder == null) {
                return null;
            }
            Object[] selectedNodeElements = FavoritesTreeViewPanel.this.getSelectedNodeElements();
            if (selectedNodeElements.length != 1) {
                return null;
            }
            for (FavoriteNodeProvider nodeProvider : (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)FavoritesTreeViewPanel.this.myProject)) {
                PsiDirectory parent;
                PsiFile file;
                PsiElement psiElement = nodeProvider.getPsiElement(selectedNodeElements[0]);
                if (psiElement instanceof PsiDirectory) {
                    return new PsiDirectory[]{(PsiDirectory)psiElement};
                }
                if (psiElement instanceof PsiDirectoryContainer) {
                    Module module;
                    String moduleName = nodeProvider.getElementModuleName(selectedNodeElements[0]);
                    GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)FavoritesTreeViewPanel.this.myProject);
                    if (moduleName != null && (module = ModuleManager.getInstance((Project)FavoritesTreeViewPanel.this.myProject).findModuleByName(moduleName)) != null) {
                        searchScope = GlobalSearchScope.moduleScope((Module)module);
                    }
                    return ((PsiDirectoryContainer)psiElement).getDirectories(searchScope);
                }
                if (psiElement == null || (file = psiElement.getContainingFile()) == null || (parent = file.getParent()) == null) continue;
                return new PsiDirectory[]{parent};
            }
            if (selectedNodeElements[0] instanceof PsiDirectory) {
                PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                psiDirectoryArray = psiDirectoryArray2;
                psiDirectoryArray2[0] = (PsiDirectory)selectedNodeElements[0];
            } else {
                psiDirectoryArray = null;
            }
            return psiDirectoryArray;
        }

        @NotNull
        public PsiDirectory[] getDirectories() {
            PsiDirectory[] directories = this.getSelectedDirectories();
            PsiDirectory[] psiDirectoryArray = directories == null ? PsiDirectory.EMPTY_ARRAY : directories;
            if (psiDirectoryArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel$MyIdeView", "getDirectories"));
            }
            return psiDirectoryArray;
        }

        public PsiDirectory getOrChooseDirectory() {
            return DirectoryChooserUtil.getOrChooseDirectory(this);
        }
    }

    private final class MyDeletePSIElementProvider
    implements DeleteProvider {
        private MyDeletePSIElementProvider() {
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel$MyDeletePSIElementProvider", "canDeleteElement"));
            }
            PsiElement[] elements = this.getElementsToDelete();
            return DeleteHandler.shouldEnableDeleteAction(elements);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel$MyDeletePSIElementProvider", "deleteElement"));
            }
            List<PsiElement> allElements = Arrays.asList(this.getElementsToDelete());
            ArrayList<PsiElement> validElements = new ArrayList<PsiElement>();
            for (PsiElement psiElement : allElements) {
                if (psiElement == null || !psiElement.isValid()) continue;
                validElements.add(psiElement);
            }
            PsiElement[] elements = PsiUtilCore.toPsiElementArray(validElements);
            LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                DeleteHandler.deletePsiElement(elements, FavoritesTreeViewPanel.this.myProject);
            }
            finally {
                a.finish();
            }
        }

        private PsiElement[] getElementsToDelete() {
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            Object[] elements = FavoritesTreeViewPanel.this.getSelectedNodeElements();
            for (int idx = 0; elements != null && idx < elements.length; ++idx) {
                PsiFile psiFile;
                VirtualFile vFile;
                VirtualFile virtualFile;
                String path;
                if (!(elements[idx] instanceof PsiElement)) continue;
                PsiElement element = (PsiElement)elements[idx];
                result.add(element);
                if (!(element instanceof PsiDirectory) || !(path = (virtualFile = ((PsiDirectory)element).getVirtualFile()).getPath()).endsWith("!/") || (vFile = LocalFileSystem.getInstance().findFileByPath(path.substring(0, path.length() - "!/".length()))) == null || (psiFile = PsiManager.getInstance((Project)FavoritesTreeViewPanel.this.myProject).findFile(vFile)) == null) continue;
                elements[idx] = psiFile;
            }
            return PsiUtilCore.toPsiElementArray(result);
        }
    }
}

