/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.actions.BookmarksAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ListUtil;
import javax.swing.JList;

class MoveBookmarkUpAction
extends DumbAwareAction {
    private final Project myProject;
    private final JList myList;

    MoveBookmarkUpAction(Project project, JList list) {
        super("Up", "Move current bookmark up", AllIcons.Actions.PreviousOccurence);
        this.myProject = project;
        this.myList = list;
        this.registerCustomShortcutSet(CommonShortcuts.MOVE_UP, list);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(BookmarksAction.notFiltered(this.myList) && BookmarksAction.getSelectedBookmarks(this.myList).size() == 1 && this.myList.getSelectedIndex() > 0);
    }

    public void actionPerformed(AnActionEvent e) {
        ListUtil.moveSelectedItemsUp((JList)this.myList);
        BookmarkManager.getInstance(this.myProject).moveBookmarkUp(BookmarksAction.getSelectedBookmarks(this.myList).get(0));
    }
}

