/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.TabbedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.options.ex.IdeConfigurablesGroup;
import com.intellij.openapi.options.ex.ProjectConfigurablesGroup;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.options.ex.SortedConfigurableGroup;
import com.intellij.openapi.options.newEditor.IdeSettingsDialog;
import com.intellij.openapi.options.newEditor.OptionsEditor;
import com.intellij.openapi.options.newEditor.OptionsEditorDialog;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Composite;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowSettingsUtilImpl
extends ShowSettingsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.ShowSettingsUtilImpl");
    private final AtomicBoolean myShown = new AtomicBoolean(false);

    @NotNull
    private static Project getProject(@Nullable Project project) {
        Project project2 = project != null ? project : ProjectManager.getInstance().getDefaultProject();
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getProject"));
        }
        return project2;
    }

    @NotNull
    public static DialogWrapper getDialog(@Nullable Project project, @NotNull ConfigurableGroup[] groups, @Nullable Configurable toSelect) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getDialog"));
        }
        project = ShowSettingsUtilImpl.getProject(project);
        ConfigurableGroup[] filteredGroups = ShowSettingsUtilImpl.filterEmptyGroups(groups);
        if (Registry.is((String)"ide.new.settings.dialog")) {
            DialogWrapper dialogWrapper = ApplicationManager.getApplication().isInternal() && Registry.is((String)"ide.new.settings.view") ? new SettingsDialog(project, filteredGroups, toSelect, null) : new IdeSettingsDialog(project, filteredGroups, toSelect);
            if (dialogWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getDialog"));
            }
            return dialogWrapper;
        }
        OptionsEditorDialog optionsEditorDialog = Registry.is((String)"ide.perProjectModality") ? new OptionsEditorDialog(project, filteredGroups, toSelect, true) : new OptionsEditorDialog(project, filteredGroups, toSelect);
        if (optionsEditorDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getDialog"));
        }
        return optionsEditorDialog;
    }

    @NotNull
    public static ConfigurableGroup[] getConfigurableGroups(@Nullable Project project, boolean withIdeSettings) {
        ConfigurableGroup[] configurableGroupArray;
        ConfigurableGroup[] configurableGroupArray2;
        if (!withIdeSettings) {
            ConfigurableGroup[] configurableGroupArray3 = new ConfigurableGroup[1];
            configurableGroupArray2 = configurableGroupArray3;
            configurableGroupArray3[0] = new ProjectConfigurablesGroup(ShowSettingsUtilImpl.getProject(project));
        } else if (project == null) {
            ConfigurableGroup[] configurableGroupArray4 = new ConfigurableGroup[1];
            configurableGroupArray2 = configurableGroupArray4;
            configurableGroupArray4[0] = new IdeConfigurablesGroup();
        } else {
            ConfigurableGroup[] configurableGroupArray5 = new ConfigurableGroup[2];
            configurableGroupArray5[0] = new ProjectConfigurablesGroup(project);
            configurableGroupArray2 = configurableGroupArray5;
            configurableGroupArray5[1] = new IdeConfigurablesGroup();
        }
        ConfigurableGroup[] groups = configurableGroupArray2;
        if (Registry.is((String)"ide.new.settings.dialog")) {
            ConfigurableGroup[] configurableGroupArray6 = new ConfigurableGroup[1];
            configurableGroupArray = configurableGroupArray6;
            configurableGroupArray6[0] = new SortedConfigurableGroup(project, ShowSettingsUtilImpl.getConfigurables(groups, true));
        } else {
            configurableGroupArray = groups;
        }
        if (configurableGroupArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getConfigurableGroups"));
        }
        return configurableGroupArray;
    }

    @NotNull
    public static Configurable[] getConfigurables(@Nullable Project project, boolean withGroupReverseOrder) {
        Configurable[] configurableArray = ShowSettingsUtilImpl.getConfigurables(ShowSettingsUtilImpl.getConfigurableGroups(project, true), withGroupReverseOrder);
        if (configurableArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getConfigurables"));
        }
        return configurableArray;
    }

    @NotNull
    private static Configurable[] getConfigurables(@NotNull ConfigurableGroup[] groups, boolean withGroupReverseOrder) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getConfigurables"));
        }
        Configurable[][] arrays = new Configurable[groups.length][];
        int length = 0;
        for (int i = 0; i < groups.length; ++i) {
            arrays[i] = groups[withGroupReverseOrder ? groups.length - 1 - i : i].getConfigurables();
            length += arrays[i].length;
        }
        Configurable[] configurables = new Configurable[length];
        int offset = 0;
        for (Configurable[] array : arrays) {
            System.arraycopy(array, 0, configurables, offset, array.length);
            offset += array.length;
        }
        if (configurables == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getConfigurables"));
        }
        return configurables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showSettingsDialog(@NotNull Project project, @NotNull ConfigurableGroup[] group) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/ShowSettingsUtilImpl", "showSettingsDialog"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/ide/actions/ShowSettingsUtilImpl", "showSettingsDialog"));
        }
        try {
            this.myShown.set(true);
            ShowSettingsUtilImpl.getDialog(project, group, null).show();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.myShown.set(false);
        }
    }

    public void showSettingsDialog(@Nullable Project project, Class configurableClass) {
        assert (Configurable.class.isAssignableFrom(configurableClass)) : "Not a configurable: " + configurableClass.getName();
        ConfigurableGroup[] groups = ShowSettingsUtilImpl.getConfigurableGroups(project, true);
        Configurable config = ShowSettingsUtilImpl.findByClass(ShowSettingsUtilImpl.getConfigurables(groups, true), configurableClass);
        assert (config != null) : "Cannot find configurable: " + configurableClass.getName();
        ShowSettingsUtilImpl.getDialog(project, groups, config).show();
    }

    @Nullable
    private static Configurable findByClass(Configurable[] configurables, Class configurableClass) {
        for (Configurable configurable : configurables) {
            if (!configurableClass.isInstance(configurable)) continue;
            return configurable;
        }
        return null;
    }

    public void showSettingsDialog(@Nullable Project project, @NotNull String nameToSelect) {
        if (nameToSelect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameToSelect", "com/intellij/ide/actions/ShowSettingsUtilImpl", "showSettingsDialog"));
        }
        ConfigurableGroup[] groups = ShowSettingsUtilImpl.getConfigurableGroups(project, true);
        Project actualProject = ShowSettingsUtilImpl.getProject(project);
        groups = ShowSettingsUtilImpl.filterEmptyGroups(groups);
        ShowSettingsUtilImpl.getDialog(actualProject, groups, ShowSettingsUtilImpl.findPreselectedByDisplayName(nameToSelect, groups)).show();
    }

    @Nullable
    private static Configurable findPreselectedByDisplayName(String preselectedConfigurableDisplayName, ConfigurableGroup[] groups) {
        List<Configurable> all = SearchUtil.expand(groups);
        for (Configurable each : all) {
            if (!preselectedConfigurableDisplayName.equals(each.getDisplayName())) continue;
            return each;
        }
        return null;
    }

    public static void showSettingsDialog(@Nullable Project project, String id2Select, final String filter) {
        ConfigurableGroup[] group = ShowSettingsUtilImpl.getConfigurableGroups(project, true);
        group = ShowSettingsUtilImpl.filterEmptyGroups(group);
        final Configurable configurable2Select = ShowSettingsUtilImpl.findConfigurable2Select(id2Select, group);
        if (ApplicationManager.getApplication().isInternal() && Registry.is((String)"ide.new.settings.view")) {
            new SettingsDialog(ShowSettingsUtilImpl.getProject(project), group, configurable2Select, filter).show();
            return;
        }
        final DialogWrapper dialog = ShowSettingsUtilImpl.getDialog(project, group, configurable2Select);
        new UiNotifyConnector.Once((Component)dialog.getContentPane(), (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                OptionsEditor editor = (OptionsEditor)((DataProvider)dialog).getData(OptionsEditor.KEY.getName());
                LOG.assertTrue(editor != null);
                editor.select(configurable2Select, filter);
            }
        });
        dialog.show();
    }

    @Nullable
    private static Configurable findConfigurable2Select(String id2Select, ConfigurableGroup[] group) {
        for (ConfigurableGroup configurableGroup : group) {
            for (Configurable configurable : configurableGroup.getConfigurables()) {
                Configurable conf = ShowSettingsUtilImpl.containsId(id2Select, configurable);
                if (conf == null) continue;
                return conf;
            }
        }
        return null;
    }

    @Nullable
    private static Configurable containsId(String id2Select, Configurable configurable) {
        if (configurable instanceof SearchableConfigurable && id2Select.equals(((SearchableConfigurable)configurable).getId())) {
            return configurable;
        }
        if (configurable instanceof SearchableConfigurable.Parent) {
            for (Configurable subConfigurable : ((SearchableConfigurable.Parent)configurable).getConfigurables()) {
                Configurable config = ShowSettingsUtilImpl.containsId(id2Select, subConfigurable);
                if (config == null) continue;
                return config;
            }
        }
        return null;
    }

    public void showSettingsDialog(@NotNull Project project, Configurable toSelect) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/ShowSettingsUtilImpl", "showSettingsDialog"));
        }
        ShowSettingsUtilImpl.getDialog(project, ShowSettingsUtilImpl.getConfigurableGroups(project, true), toSelect).show();
    }

    @NotNull
    private static ConfigurableGroup[] filterEmptyGroups(@NotNull ConfigurableGroup[] group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/ide/actions/ShowSettingsUtilImpl", "filterEmptyGroups"));
        }
        ArrayList<ConfigurableGroup> groups = new ArrayList<ConfigurableGroup>();
        for (ConfigurableGroup g : group) {
            if (g.getConfigurables().length <= 0) continue;
            groups.add(g);
        }
        ConfigurableGroup[] configurableGroupArray = groups.toArray(new ConfigurableGroup[groups.size()]);
        if (configurableGroupArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "filterEmptyGroups"));
        }
        return configurableGroupArray;
    }

    public boolean editConfigurable(Project project, Configurable configurable) {
        return this.editConfigurable(project, ShowSettingsUtilImpl.createDimensionKey(configurable), configurable);
    }

    public <T extends Configurable> T findApplicationConfigurable(Class<T> confClass) {
        return ConfigurableExtensionPointUtil.findApplicationConfigurable(confClass);
    }

    public <T extends Configurable> T findProjectConfigurable(Project project, Class<T> confClass) {
        return ConfigurableExtensionPointUtil.findProjectConfigurable(project, confClass);
    }

    public boolean editConfigurable(Project project, String dimensionServiceKey, @NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "editConfigurable"));
        }
        return this.editConfigurable(project, dimensionServiceKey, configurable, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    private static boolean isWorthToShowApplyButton(@NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "isWorthToShowApplyButton"));
        }
        return configurable instanceof Place.Navigator || configurable instanceof Composite || configurable instanceof TabbedConfigurable;
    }

    public boolean editConfigurable(Project project, String dimensionServiceKey, @NotNull Configurable configurable, boolean showApplyButton) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "editConfigurable"));
        }
        return ShowSettingsUtilImpl.editConfigurable(null, project, configurable, dimensionServiceKey, null, showApplyButton);
    }

    public boolean editConfigurable(Project project, Configurable configurable, Runnable advancedInitialization) {
        return ShowSettingsUtilImpl.editConfigurable(null, project, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable), advancedInitialization, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "editConfigurable"));
        }
        return this.editConfigurable(parent, configurable, null);
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull Configurable configurable, @Nullable Runnable advancedInitialization) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "editConfigurable"));
        }
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable), advancedInitialization, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    private static boolean editConfigurable(@Nullable Component parent, @Nullable Project project, @NotNull Configurable configurable, String dimensionKey, final @Nullable Runnable advancedInitialization, boolean showApplyButton) {
        DialogWrapper editor;
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "editConfigurable"));
        }
        if (parent == null) {
            editor = ApplicationManager.getApplication().isInternal() && Registry.is((String)"ide.new.settings.view") ? new SettingsDialog(project, dimensionKey, configurable, showApplyButton) : new SingleConfigurableEditor(project, configurable, dimensionKey, showApplyButton);
        } else {
            DialogWrapper dialogWrapper = editor = ApplicationManager.getApplication().isInternal() && Registry.is((String)"ide.new.settings.view") ? new SettingsDialog(parent, dimensionKey, configurable, showApplyButton) : new SingleConfigurableEditor(parent, configurable, dimensionKey, showApplyButton);
        }
        if (advancedInitialization != null) {
            new UiNotifyConnector.Once((Component)editor.getContentPane(), (Activatable)new Activatable.Adapter(){

                public void showNotify() {
                    advancedInitialization.run();
                }
            });
        }
        editor.show();
        return editor.isOK();
    }

    @NotNull
    public static String createDimensionKey(@NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "createDimensionKey"));
        }
        String string = '#' + StringUtil.replaceChar((String)StringUtil.replaceChar((String)configurable.getDisplayName(), (char)'\n', (char)'_'), (char)' ', (char)'_');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "createDimensionKey"));
        }
        return string;
    }

    public boolean editConfigurable(Component parent, String dimensionServiceKey, Configurable configurable) {
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable, dimensionServiceKey, null, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    public boolean isAlreadyShown() {
        return this.myShown.get();
    }
}

