/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.options.SharedScheme;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class QuickChangeColorSchemeAction
extends QuickSwitchSchemeAction {
    protected void fillActions(Project project, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/ide/actions/QuickChangeColorSchemeAction", "fillActions"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/actions/QuickChangeColorSchemeAction", "fillActions"));
        }
        EditorColorsScheme[] schemes = EditorColorsManager.getInstance().getAllSchemes();
        EditorColorsScheme current = EditorColorsManager.getInstance().getGlobalScheme();
        for (EditorColorsScheme scheme : schemes) {
            QuickChangeColorSchemeAction.addScheme(group, current, scheme, false);
        }
        Collection sharedSchemes = ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).getSchemesManager().loadSharedSchemes();
        if (!sharedSchemes.isEmpty()) {
            group.add((AnAction)Separator.getInstance());
            for (SharedScheme sharedScheme : sharedSchemes) {
                QuickChangeColorSchemeAction.addScheme(group, current, (EditorColorsScheme)sharedScheme.getScheme(), true);
            }
        }
    }

    private static void addScheme(DefaultActionGroup group, EditorColorsScheme current, final EditorColorsScheme scheme, final boolean addScheme) {
        group.add((AnAction)new DumbAwareAction(scheme.getName(), "", scheme == current ? ourCurrentAction : ourNotCurrentAction){

            public void actionPerformed(AnActionEvent e) {
                if (addScheme) {
                    EditorColorsManager.getInstance().addColorsScheme(scheme);
                }
                EditorColorsManager.getInstance().setGlobalScheme(scheme);
            }
        });
    }

    protected boolean isEnabled() {
        return EditorColorsManager.getInstance().getAllSchemes().length > 1 || ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).getSchemesManager().isImportAvailable();
    }
}

