/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class PruneEmptyDirectoriesAction
extends AnAction {
    public void update(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
        e.getPresentation().setEnabled(files != null && files.length > 0);
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
        assert (files != null);
        FileTypeManager ftManager = FileTypeManager.getInstance();
        try {
            for (VirtualFile file : files) {
                PruneEmptyDirectoriesAction.pruneEmptiesIn(file, ftManager);
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
    }

    private static void pruneEmptiesIn(VirtualFile file, final FileTypeManager ftManager) throws IOException {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/PruneEmptyDirectoriesAction$1", "visitFile"));
                }
                if (file.isDirectory()) {
                    if (ftManager.isFileIgnored(file)) {
                        return false;
                    }
                } else if (".DS_Store".equals(file.getName())) {
                    PruneEmptyDirectoriesAction.delete(file);
                    return false;
                }
                return true;
            }

            public void afterChildrenVisited(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/PruneEmptyDirectoriesAction$1", "afterChildrenVisited"));
                }
                if (file.isDirectory() && file.getChildren().length == 0) {
                    PruneEmptyDirectoriesAction.delete(file);
                }
            }
        });
    }

    private static void delete(final VirtualFile file) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    file.delete(PruneEmptyDirectoriesAction.class);
                    System.out.println("Deleted: " + file.getPresentableUrl());
                }
                catch (IOException e) {
                    Messages.showErrorDialog((String)("Cannot delete '" + file.getPresentableUrl() + "', " + e.getLocalizedMessage()), (String)"IOException");
                }
            }
        });
    }
}

