/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class PowerSaveModeNotifier
implements StartupActivity {
    private static final NotificationGroup POWER_SAVE_MODE = NotificationGroup.balloonGroup((String)"Power Save Mode");
    private static final String IGNORE_POWER_SAVE_MODE = "ignore.power.save.mode";

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/PowerSaveModeNotifier", "runActivity"));
        }
        if (PowerSaveMode.isEnabled()) {
            PowerSaveModeNotifier.notifyOnPowerSaveMode(project);
        }
    }

    static void notifyOnPowerSaveMode(Project project) {
        if (PropertiesComponent.getInstance().getBoolean(IGNORE_POWER_SAVE_MODE, false)) {
            return;
        }
        String message = "Code insight and other background tasks are disabled.<br/><a href=\"ignore\">Do not show again</a><br/><a href=\"turnOff\">Disable Power Save Mode</a>";
        POWER_SAVE_MODE.createNotification("Power save mode is on", message, NotificationType.WARNING, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/ide/actions/PowerSaveModeNotifier$1", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/PowerSaveModeNotifier$1", "hyperlinkUpdate"));
                }
                String description = event.getDescription();
                if ("ignore".equals(description)) {
                    PropertiesComponent.getInstance().setValue(PowerSaveModeNotifier.IGNORE_POWER_SAVE_MODE, "true");
                    notification.expire();
                } else if ("turnOff".equals(description)) {
                    PowerSaveMode.setEnabled(false);
                    notification.expire();
                }
            }
        }).notify(project);
    }
}

