/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenFileAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/OpenFileAction", "actionPerformed"));
        }
        final Project project = e.getProject();
        boolean showFiles = project != null || PlatformProjectOpenProcessor.getInstanceIfItExists() != null;
        final OpenProjectFileChooserDescriptor descriptor = showFiles ? new ProjectOrFileChooserDescriptor() : new ProjectOnlyFileChooserDescriptor();
        descriptor.putUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT, showFiles);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)VfsUtil.getUserHomeDir(), (Consumer)new Consumer<List<VirtualFile>>(){

            public void consume(List<VirtualFile> files) {
                for (VirtualFile file : files) {
                    if (descriptor.isFileSelectable(file)) continue;
                    String message = IdeBundle.message((String)"error.dir.contains.no.project", (Object[])new Object[]{file.getPresentableUrl()});
                    Messages.showInfoMessage((Project)project, (String)message, (String)IdeBundle.message((String)"title.cannot.open.project", (Object[])new Object[0]));
                    return;
                }
                OpenFileAction.doOpenFile(project, files);
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/OpenFileAction", "update"));
        }
        if (NewWelcomeScreen.isNewWelcomeScreen(e)) {
            e.getPresentation().setIcon(AllIcons.Welcome.OpenProject);
        }
    }

    private static void doOpenFile(@Nullable Project project, @NotNull List<VirtualFile> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/actions/OpenFileAction", "doOpenFile"));
        }
        for (VirtualFile file : result) {
            Project openedProject;
            if (file.isDirectory()) {
                openedProject = ProjectAttachProcessor.canAttachToProject() ? PlatformProjectOpenProcessor.doOpenProject(file, project, false, -1, null, false) : ProjectUtil.openOrImport(file.getPath(), project, false);
                FileChooserUtil.setLastOpenedFile(openedProject, file);
                return;
            }
            if ((project == null || !file.equals(project.getProjectFile())) && OpenProjectFileChooserDescriptor.isProjectFile(file) && (openedProject = ProjectUtil.openOrImport(file.getPath(), project, false)) != null) {
                FileChooserUtil.setLastOpenedFile(openedProject, file);
                return;
            }
            FileType type = FileTypeChooser.getKnownFileTypeOrAssociate(file, project);
            if (type == null) {
                return;
            }
            if (project != null) {
                OpenFileAction.openFile(file, project);
                continue;
            }
            PlatformProjectOpenProcessor processor = PlatformProjectOpenProcessor.getInstanceIfItExists();
            if (processor == null) continue;
            processor.doOpenProject(file, null, false);
        }
    }

    public static void openFile(String filePath, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/OpenFileAction", "openFile"));
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (file != null && file.isValid()) {
            OpenFileAction.openFile(file, project);
        }
    }

    public static void openFile(VirtualFile file, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/OpenFileAction", "openFile"));
        }
        FileEditorProvider[] providers = FileEditorProviderManager.getInstance().getProviders(project, file);
        if (providers.length == 0) {
            String message = IdeBundle.message((String)"error.files.of.this.type.cannot.be.opened", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()});
            Messages.showErrorDialog((Project)project, (String)message, (String)IdeBundle.message((String)"title.cannot.open.file", (Object[])new Object[0]));
            return;
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file);
        FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
    }

    private static class ProjectOrFileChooserDescriptor
    extends OpenProjectFileChooserDescriptor {
        private final FileChooserDescriptor myStandardDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();

        public ProjectOrFileChooserDescriptor() {
            super(true);
            this.setTitle(IdeBundle.message((String)"title.open.file.or.project", (Object[])new Object[0]));
        }

        @Override
        public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
            return file.isDirectory() ? super.isFileVisible(file, showHiddenFiles) : this.myStandardDescriptor.isFileVisible(file, showHiddenFiles);
        }

        @Override
        public boolean isFileSelectable(VirtualFile file) {
            return file.isDirectory() ? super.isFileSelectable(file) : this.myStandardDescriptor.isFileSelectable(file);
        }

        public boolean isChooseMultiple() {
            return true;
        }
    }

    private static class ProjectOnlyFileChooserDescriptor
    extends OpenProjectFileChooserDescriptor {
        public ProjectOnlyFileChooserDescriptor() {
            super(true);
            this.setTitle(IdeBundle.message((String)"title.open.project", (Object[])new Object[0]));
        }
    }
}

