/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.diagnostic.DebugLogManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugLogConfigureAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        DebugLogManager logCustomizer;
        Project project = e.getProject() == null ? ProjectManager.getInstance().getDefaultProject() : e.getProject();
        DebugLogConfigureDialog dialog = new DebugLogConfigureDialog(project, (logCustomizer = (DebugLogManager)((Object)ServiceManager.getService(DebugLogManager.class))).getSavedCategories());
        if (dialog.showAndGet()) {
            List<String> categories = dialog.getLogCategories();
            logCustomizer.applyCategories(categories);
            logCustomizer.saveCategories(categories);
        }
    }

    private static class DebugLogConfigureDialog
    extends DialogWrapper {
        private static final String ALL_POSSIBLE_SEPARATORS = "(\n|,|;)+";
        @NotNull
        private final JTextArea myTextArea = new JTextArea(10, 30);

        protected DebugLogConfigureDialog(@Nullable Project project, List<String> categories) {
            super(project, false);
            this.myTextArea.setText(StringUtil.join(categories, (String)"\n"));
            this.setTitle("Custom Debug Log Configuration");
            this.init();
        }

        @Nullable
        protected JComponent createNorthPanel() {
            return new JBLabel("Add log categories separated by new lines");
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return ScrollPaneFactory.createScrollPane((Component)this.myTextArea);
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myTextArea;
        }

        @NotNull
        public List<String> getLogCategories() {
            List<String> list = DebugLogConfigureDialog.parseCategories(this.myTextArea.getText());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/DebugLogConfigureAction$DebugLogConfigureDialog", "getLogCategories"));
            }
            return list;
        }

        @NotNull
        private static List<String> parseCategories(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/actions/DebugLogConfigureAction$DebugLogConfigureDialog", "parseCategories"));
            }
            List list = ContainerUtil.mapNotNull((Object[])text.split(ALL_POSSIBLE_SEPARATORS), (Function)new Function<String, String>(){

                public String fun(String s) {
                    return StringUtil.isEmptyOrSpaces((String)s) ? null : s.trim();
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/DebugLogConfigureAction$DebugLogConfigureDialog", "parseCategories"));
            }
            return list;
        }
    }
}

