/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.SystemDock;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RecentProjectsManagerBase
implements ProjectManagerListener,
PersistentStateComponent<State> {
    private final Object myStateLock = new Object();
    private State myState = new State();
    private final Map<String, String> myNameCache = Collections.synchronizedMap(new HashMap());

    public static RecentProjectsManagerBase getInstance() {
        return (RecentProjectsManagerBase)ServiceManager.getService(RecentProjectsManagerBase.class);
    }

    protected RecentProjectsManagerBase(MessageBus messageBus) {
        messageBus.connect().subscribe(AppLifecycleListener.TOPIC, (Object)new MyAppLifecycleListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.validateRecentProjects();
            return this.myState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(State state2) {
        Object object = this.myStateLock;
        synchronized (object) {
            File lastFile;
            this.myState = state2;
            if (this.myState.lastPath != null && !new File(this.myState.lastPath).exists()) {
                this.myState.lastPath = null;
            }
            if (this.myState.lastPath != null && (lastFile = new File(this.myState.lastPath)).isDirectory() && !new File(lastFile, ".idea").exists()) {
                this.myState.lastPath = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePath(String path) {
        if (path == null) {
            return;
        }
        Object object = this.myStateLock;
        synchronized (object) {
            if (SystemInfo.isFileSystemCaseSensitive) {
                this.myState.removePath(path);
            } else {
                for (String p : ArrayUtil.toStringArray(this.myState.recentPaths)) {
                    if (!path.equalsIgnoreCase(p)) continue;
                    this.myState.removePath(path);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastProjectPath() {
        Object object = this.myStateLock;
        synchronized (object) {
            return this.myState.lastPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastProjectPath() {
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        Object object = this.myStateLock;
        synchronized (object) {
            if (openProjects.length == 0) {
                this.myState.lastPath = null;
                this.myState.openPaths = Collections.emptyList();
            } else {
                this.myState.lastPath = this.getProjectPath(openProjects[openProjects.length - 1]);
                this.myState.openPaths = ContainerUtil.newArrayList();
                for (Project openProject : openProjects) {
                    String path = this.getProjectPath(openProject);
                    if (path == null) continue;
                    this.myState.openPaths.add(path);
                    this.myState.names.put(path, this.getProjectDisplayName(openProject));
                }
            }
        }
    }

    @NotNull
    protected String getProjectDisplayName(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/RecentProjectsManagerBase", "getProjectDisplayName"));
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/RecentProjectsManagerBase", "getProjectDisplayName"));
        }
        return "";
    }

    private Set<String> getDuplicateProjectNames(Set<String> openedPaths, Set<String> recentPaths) {
        HashSet names = ContainerUtil.newHashSet();
        HashSet duplicates = ContainerUtil.newHashSet();
        for (String path : ContainerUtil.concat((Iterable[])new Iterable[]{openedPaths, recentPaths})) {
            if (names.add(this.getProjectName(path))) continue;
            duplicates.add(path);
        }
        return duplicates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnAction[] getRecentProjectsActions(boolean addClearListItem) {
        LinkedHashSet paths;
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.validateRecentProjects();
            paths = ContainerUtil.newLinkedHashSet(this.myState.recentPaths);
        }
        HashSet openedPaths = ContainerUtil.newHashSet();
        for (Project openProject : ProjectManager.getInstance().getOpenProjects()) {
            ContainerUtil.addIfNotNull((Collection)openedPaths, (Object)this.getProjectPath(openProject));
        }
        paths.remove(null);
        paths.removeAll(openedPaths);
        ArrayList<Object> actions = new ArrayList<Object>();
        Set<String> duplicates = this.getDuplicateProjectNames(openedPaths, paths);
        for (String path : paths) {
            String displayName;
            String projectName = this.getProjectName(path);
            Object object2 = this.myStateLock;
            synchronized (object2) {
                displayName = this.myState.names.get(path);
            }
            if (StringUtil.isEmptyOrSpaces((String)displayName)) {
                String string = displayName = duplicates.contains(path) ? path : projectName;
            }
            if (!new File(path).exists()) continue;
            actions.add((Object)new ReopenProjectAction(path, projectName, displayName));
        }
        if (actions.isEmpty()) {
            return AnAction.EMPTY_ARRAY;
        }
        if (addClearListItem) {
            DumbAwareAction clearListAction = new DumbAwareAction(IdeBundle.message((String)"action.clear.list", (Object[])new Object[0])){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/RecentProjectsManagerBase$1", "actionPerformed"));
                    }
                    String message = IdeBundle.message((String)"action.clear.list.message", (Object[])new Object[0]);
                    String title = IdeBundle.message((String)"action.clear.list.title", (Object[])new Object[0]);
                    if (Messages.showOkCancelDialog((Project)e.getProject(), (String)message, (String)title, (Icon)Messages.getQuestionIcon()) == 0) {
                        Object object = RecentProjectsManagerBase.this.myStateLock;
                        synchronized (object) {
                            ((RecentProjectsManagerBase)RecentProjectsManagerBase.this).myState.recentPaths.clear();
                        }
                        WelcomeFrame.clearRecents();
                    }
                }
            };
            actions.add(Separator.getInstance());
            actions.add(clearListAction);
        }
        return actions.toArray(new AnAction[actions.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markPathRecent(String path) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.lastPath = path;
            this.removePath(path);
            this.myState.recentPaths.add(0, path);
        }
    }

    @Nullable
    protected abstract String getProjectPath(@NotNull Project var1);

    protected abstract void doOpenProject(@NotNull String var1, @Nullable Project var2, boolean var3);

    public static boolean isValidProjectPath(String projectPath) {
        File file = new File(projectPath);
        return file.exists() && (!file.isDirectory() || new File(file, ".idea").exists());
    }

    public void projectOpened(Project project) {
        String path = this.getProjectPath(project);
        if (path != null) {
            this.markPathRecent(path);
        }
        SystemDock.updateMenu();
    }

    public final boolean canCloseProject(Project project) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectClosing(Project project) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.names.put(this.getProjectPath(project), this.getProjectDisplayName(project));
        }
    }

    public void projectClosed(Project project) {
        String path;
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (openProjects.length > 0 && (path = this.getProjectPath(openProjects[openProjects.length - 1])) != null) {
            this.markPathRecent(path);
        }
        SystemDock.updateMenu();
    }

    @NotNull
    private String getProjectName(String path) {
        String cached = this.myNameCache.get(path);
        if (cached != null) {
            String string = cached;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/RecentProjectsManagerBase", "getProjectName"));
            }
            return string;
        }
        String result = RecentProjectsManagerBase.readProjectName(path);
        this.myNameCache.put(path, result);
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/RecentProjectsManagerBase", "getProjectName"));
        }
        return string;
    }

    public void clearNameCache() {
        this.myNameCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readProjectName(String path) {
        File file = new File(path);
        if (!file.isDirectory()) return FileUtil.getNameWithoutExtension((String)file.getName());
        File nameFile = new File(new File(path, ".idea"), ".name");
        if (!nameFile.exists()) return file.getName();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(nameFile), "UTF-8"));
            try {
                String name = in.readLine();
                if (name == null) return file.getName();
                if (name.length() <= 0) return file.getName();
                String string = name.trim();
                return string;
            }
            finally {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file.getName();
    }

    protected boolean willReopenProjectOnStart() {
        return GeneralSettings.getInstance().isReopenLastProject() && this.getLastProjectPath() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReopenLastProject() {
        GeneralSettings generalSettings = GeneralSettings.getInstance();
        if (generalSettings.isReopenLastProject()) {
            LinkedHashSet openPaths;
            Object object = this.myStateLock;
            synchronized (object) {
                openPaths = ContainerUtil.newLinkedHashSet(this.myState.openPaths);
            }
            if (!openPaths.isEmpty()) {
                for (String openPath : openPaths) {
                    if (!RecentProjectsManagerBase.isValidProjectPath(openPath)) continue;
                    this.doOpenProject(openPath, null, true);
                }
            } else {
                String lastProjectPath = this.getLastProjectPath();
                if (lastProjectPath != null && RecentProjectsManagerBase.isValidProjectPath(lastProjectPath)) {
                    this.doOpenProject(lastProjectPath, null, false);
                }
            }
        }
    }

    private class MyAppLifecycleListener
    extends AppLifecycleListener.Adapter {
        private MyAppLifecycleListener() {
        }

        @Override
        public void appFrameCreated(String[] commandLineArgs, @NotNull Ref<Boolean> willOpenProject) {
            if (willOpenProject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "willOpenProject", "com/intellij/ide/RecentProjectsManagerBase$MyAppLifecycleListener", "appFrameCreated"));
            }
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)RecentProjectsManagerBase.this);
            }
            if (RecentProjectsManagerBase.this.willReopenProjectOnStart()) {
                willOpenProject.set((Object)Boolean.TRUE);
            }
        }

        @Override
        public void appStarting(Project projectFromCommandLine) {
            if (projectFromCommandLine != null) {
                return;
            }
            RecentProjectsManagerBase.this.doReopenLastProject();
        }

        @Override
        public void projectFrameClosed() {
            RecentProjectsManagerBase.this.updateLastProjectPath();
        }

        @Override
        public void projectOpenFailed() {
            RecentProjectsManagerBase.this.updateLastProjectPath();
        }

        @Override
        public void appClosing() {
            RecentProjectsManagerBase.this.updateLastProjectPath();
        }
    }

    public static class State {
        public List<String> recentPaths = ContainerUtil.newArrayList();
        public List<String> openPaths = ContainerUtil.newArrayList();
        public Map<String, String> names = ContainerUtil.newLinkedHashMap();
        public String lastPath;

        void validateRecentProjects() {
            while (this.recentPaths.remove(null)) {
            }
            Collection<String> displayNames = this.names.values();
            while (displayNames.remove("")) {
            }
            while (this.recentPaths.size() > Registry.intValue((String)"ide.max.recent.projects")) {
                int index = this.recentPaths.size() - 1;
                this.names.remove(this.recentPaths.get(index));
                this.recentPaths.remove(index);
            }
        }

        void removePath(String path) {
            this.recentPaths.remove(path);
            this.names.remove(path);
        }
    }
}

