/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ClipboardSynchronizer;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ide.CutElementMarker;
import com.intellij.openapi.ide.KillRingTransferable;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.EventDispatcher;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyPasteManagerEx
extends CopyPasteManager
implements ClipboardOwner {
    private final List<Transferable> myData = new ArrayList<Transferable>();
    private final EventDispatcher<CopyPasteManager.ContentChangedListener> myDispatcher = EventDispatcher.create(CopyPasteManager.ContentChangedListener.class);
    private final ClipboardSynchronizer myClipboardSynchronizer;
    private boolean myOwnContent = false;

    public static CopyPasteManagerEx getInstanceEx() {
        return (CopyPasteManagerEx)CopyPasteManagerEx.getInstance();
    }

    public CopyPasteManagerEx(ClipboardSynchronizer clipboardSynchronizer) {
        this.myClipboardSynchronizer = clipboardSynchronizer;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.myOwnContent = false;
        this.myClipboardSynchronizer.resetContent();
        this.fireContentChanged(contents, null);
    }

    private void fireContentChanged(@Nullable Transferable oldContent, @Nullable Transferable newContent) {
        ((CopyPasteManager.ContentChangedListener)this.myDispatcher.getMulticaster()).contentChanged(oldContent, newContent);
    }

    public void addContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ide/CopyPasteManagerEx", "addContentChangedListener"));
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void addContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ide/CopyPasteManagerEx", "addContentChangedListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/ide/CopyPasteManagerEx", "addContentChangedListener"));
        }
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public void removeContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ide/CopyPasteManagerEx", "removeContentChangedListener"));
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
        if (flavors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavors", "com/intellij/ide/CopyPasteManagerEx", "areDataFlavorsAvailable"));
        }
        return flavors.length > 0 && this.myClipboardSynchronizer.areDataFlavorsAvailable(flavors);
    }

    public void setContents(@NotNull Transferable content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/CopyPasteManagerEx", "setContents"));
        }
        Transferable oldContent = this.myOwnContent && !this.myData.isEmpty() ? this.myData.get(0) : null;
        Transferable contentToUse = this.addNewContentToStack(content);
        this.setSystemClipboardContent(contentToUse);
        this.fireContentChanged(oldContent, contentToUse);
    }

    public boolean isCutElement(@Nullable Object element) {
        for (CutElementMarker marker : (CutElementMarker[])Extensions.getExtensions((ExtensionPointName)CutElementMarker.EP_NAME)) {
            if (!marker.isCutElement(element)) continue;
            return true;
        }
        return false;
    }

    public void stopKillRings() {
        for (Transferable data : this.myData) {
            if (!(data instanceof KillRingTransferable)) continue;
            ((KillRingTransferable)data).setReadyToCombine(false);
        }
    }

    private void setSystemClipboardContent(Transferable content) {
        this.myClipboardSynchronizer.setContent(content, this);
        this.myOwnContent = true;
    }

    @NotNull
    private Transferable addNewContentToStack(@NotNull Transferable content) {
        String clipString;
        block15: {
            KillRingTransferable killRingContent;
            block16: {
                Transferable merged;
                Transferable prev;
                block14: {
                    if (content == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/CopyPasteManagerEx", "addNewContentToStack"));
                    }
                    clipString = CopyPasteManagerEx.getStringContent(content);
                    if (clipString != null) break block14;
                    Transferable transferable = content;
                    if (transferable == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/CopyPasteManagerEx", "addNewContentToStack"));
                    }
                    return transferable;
                }
                if (!(content instanceof KillRingTransferable)) break block15;
                killRingContent = (KillRingTransferable)content;
                if (!killRingContent.isReadyToCombine() || this.myData.isEmpty() || !((prev = this.myData.get(0)) instanceof KillRingTransferable) || (merged = CopyPasteManagerEx.merge(killRingContent, (KillRingTransferable)prev)) == null) break block16;
                this.myData.set(0, merged);
                Transferable transferable = merged;
                if (transferable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/CopyPasteManagerEx", "addNewContentToStack"));
                }
                return transferable;
            }
            if (!killRingContent.isReadyToCombine()) break block15;
            this.addToTheTopOfTheStack((Transferable)killRingContent);
            KillRingTransferable killRingTransferable = killRingContent;
            if (killRingTransferable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/CopyPasteManagerEx", "addNewContentToStack"));
            }
            return killRingTransferable;
        }
        try {
            Transferable same = null;
            for (Transferable old : this.myData) {
                if (!clipString.equals(CopyPasteManagerEx.getStringContent(old))) continue;
                same = old;
                break;
            }
            if (same == null) {
                this.addToTheTopOfTheStack(content);
            } else {
                this.moveContentToStackTop(same, false);
            }
        }
        catch (UnsupportedFlavorException ignore) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Transferable transferable = content;
        if (transferable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/CopyPasteManagerEx", "addNewContentToStack"));
        }
        return transferable;
    }

    private void addToTheTopOfTheStack(@NotNull Transferable content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/CopyPasteManagerEx", "addToTheTopOfTheStack"));
        }
        this.myData.add(0, content);
        this.deleteAfterAllowedMaximum();
    }

    @Nullable
    private static Transferable merge(@NotNull KillRingTransferable newData, @NotNull KillRingTransferable oldData) throws IOException, UnsupportedFlavorException {
        if (newData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newData", "com/intellij/ide/CopyPasteManagerEx", "merge"));
        }
        if (oldData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldData", "com/intellij/ide/CopyPasteManagerEx", "merge"));
        }
        if (!oldData.isReadyToCombine() || !newData.isReadyToCombine()) {
            return null;
        }
        Document document = newData.getDocument();
        if (document == null || document != oldData.getDocument()) {
            return null;
        }
        Object newDataText = newData.getTransferData(DataFlavor.stringFlavor);
        Object oldDataText = oldData.getTransferData(DataFlavor.stringFlavor);
        if (newDataText == null || oldDataText == null) {
            return null;
        }
        if (oldData.isCut() && newData.getStartOffset() == oldData.getStartOffset()) {
            return new KillRingTransferable(oldDataText.toString() + newDataText, document, oldData.getStartOffset(), newData.getEndOffset(), newData.isCut());
        }
        if (newData.getStartOffset() == oldData.getEndOffset()) {
            return new KillRingTransferable(oldDataText.toString() + newDataText, document, oldData.getStartOffset(), newData.getEndOffset(), false);
        }
        if (newData.getEndOffset() == oldData.getStartOffset()) {
            return new KillRingTransferable(newDataText.toString() + oldDataText, document, newData.getStartOffset(), oldData.getEndOffset(), false);
        }
        return null;
    }

    private static String getStringContent(Transferable content) {
        try {
            return (String)content.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException ignore) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private void deleteAfterAllowedMaximum() {
        int max = UISettings.getInstance().MAX_CLIPBOARD_CONTENTS;
        for (int i = this.myData.size() - 1; i >= max; --i) {
            this.myData.remove(i);
        }
    }

    public Transferable getContents() {
        return this.myClipboardSynchronizer.getContents();
    }

    @Nullable
    public <T> T getContents(@NotNull DataFlavor flavor) {
        if (flavor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavor", "com/intellij/ide/CopyPasteManagerEx", "getContents"));
        }
        if (this.areDataFlavorsAvailable(flavor)) {
            try {
                Transferable contents = this.getContents();
                if (contents != null) {
                    Object data = contents.getTransferData(flavor);
                    return (T)data;
                }
            }
            catch (UnsupportedFlavorException ignore) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    public Transferable[] getAllContents() {
        String clipString = (String)this.getContents(DataFlavor.stringFlavor);
        if (clipString != null && (this.myData.isEmpty() || !Comparing.equal((String)clipString, (String)CopyPasteManagerEx.getStringContent(this.myData.get(0))))) {
            this.addToTheTopOfTheStack(new StringSelection(clipString));
        }
        Transferable[] transferableArray = this.myData.toArray(new Transferable[this.myData.size()]);
        if (transferableArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/CopyPasteManagerEx", "getAllContents"));
        }
        return transferableArray;
    }

    public void removeContent(Transferable t) {
        Transferable current = this.myData.isEmpty() ? null : this.myData.get(0);
        this.myData.remove(t);
        if (Comparing.equal((Object)t, (Object)current)) {
            Transferable newContent = !this.myData.isEmpty() ? this.myData.get(0) : new StringSelection("");
            this.setSystemClipboardContent(newContent);
            this.fireContentChanged(current, newContent);
        }
    }

    public void moveContentTopStackTop(Transferable t) {
        this.moveContentToStackTop(t);
    }

    public void moveContentToStackTop(Transferable t) {
        this.moveContentToStackTop(t, true);
    }

    private void moveContentToStackTop(Transferable t, boolean notifyOthers) {
        Transferable current;
        Transferable transferable = current = this.myData.isEmpty() ? null : this.myData.get(0);
        if (!Comparing.equal((Object)t, (Object)current)) {
            this.myData.remove(t);
            this.myData.add(0, t);
            if (notifyOthers) {
                this.setSystemClipboardContent(t);
                this.fireContentChanged(current, t);
            }
        }
    }
}

