/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.exclude.old;

import com.intellij.framework.detection.impl.exclude.ExcludedFileState;
import com.intellij.framework.detection.impl.exclude.ExcludesConfigurationState;
import com.intellij.framework.detection.impl.exclude.old.DisabledAutodetectionByTypeElement;
import com.intellij.framework.detection.impl.exclude.old.DisabledAutodetectionInModuleElement;
import com.intellij.framework.detection.impl.exclude.old.DisabledAutodetectionInfo;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

@State(name="FacetAutodetectingManager", storages={@Storage(file="$PROJECT_FILE$")})
public class OldFacetDetectionExcludesConfiguration
implements PersistentStateComponent<DisabledAutodetectionInfo> {
    @NonNls
    public static final String COMPONENT_NAME = "FacetAutodetectingManager";
    private DisabledAutodetectionInfo myDisabledAutodetectionInfo;
    private final Project myProject;

    public static OldFacetDetectionExcludesConfiguration getInstance(Project project) {
        return (OldFacetDetectionExcludesConfiguration)ServiceManager.getService((Project)project, OldFacetDetectionExcludesConfiguration.class);
    }

    public OldFacetDetectionExcludesConfiguration(Project project) {
        this.myProject = project;
    }

    public DisabledAutodetectionInfo getState() {
        return this.myDisabledAutodetectionInfo;
    }

    public void loadState(DisabledAutodetectionInfo state2) {
        this.myDisabledAutodetectionInfo = state2;
    }

    @Nullable
    public ExcludesConfigurationState convert() {
        if (this.myDisabledAutodetectionInfo == null || this.myDisabledAutodetectionInfo.getElements().isEmpty()) {
            return null;
        }
        ExcludesConfigurationState state2 = new ExcludesConfigurationState();
        for (DisabledAutodetectionByTypeElement element : this.myDisabledAutodetectionInfo.getElements()) {
            String frameworkId = element.getFacetTypeId();
            List<DisabledAutodetectionInModuleElement> moduleElements = element.getModuleElements();
            if (moduleElements.isEmpty()) {
                state2.getFrameworkTypes().add(frameworkId);
                continue;
            }
            LinkedHashSet<String> excludedUrls = new LinkedHashSet<String>();
            for (DisabledAutodetectionInModuleElement moduleElement : moduleElements) {
                if (moduleElement.isDisableInWholeModule()) {
                    Module module = ModuleManager.getInstance((Project)this.myProject).findModuleByName(moduleElement.getModuleName());
                    if (module == null) continue;
                    Collections.addAll(excludedUrls, ModuleRootManager.getInstance((Module)module).getContentRootUrls());
                    continue;
                }
                excludedUrls.addAll(moduleElement.getFiles());
                excludedUrls.addAll(moduleElement.getDirectories());
            }
            for (String url : excludedUrls) {
                state2.getFiles().add(new ExcludedFileState(url, frameworkId));
            }
        }
        return state2;
    }
}

