/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.exclude;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.framework.detection.impl.exclude.ExcludedFileState;
import com.intellij.framework.detection.impl.exclude.ExcludesConfigurationState;
import com.intellij.framework.detection.impl.exclude.old.OldFacetDetectionExcludesConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.containers.FactoryMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FrameworkDetectionExcludesConfiguration", storages={@Storage(id="other", file="$PROJECT_FILE$")})
public class DetectionExcludesConfigurationImpl
extends DetectionExcludesConfiguration
implements PersistentStateComponent<ExcludesConfigurationState>,
Disposable {
    private Map<String, VirtualFilePointerContainer> myExcludedFiles;
    private Set<String> myExcludedFrameworks;
    private final Project myProject;
    private VirtualFilePointerManager myPointerManager;
    private boolean myDetectionEnabled = true;
    private boolean myConverted;

    public DetectionExcludesConfigurationImpl(Project project, VirtualFilePointerManager pointerManager) {
        this.myProject = project;
        this.myPointerManager = pointerManager;
        this.myExcludedFrameworks = new HashSet<String>();
        this.myExcludedFiles = new FactoryMap<String, VirtualFilePointerContainer>(){

            protected VirtualFilePointerContainer create(String key) {
                return DetectionExcludesConfigurationImpl.this.myPointerManager.createContainer((Disposable)DetectionExcludesConfigurationImpl.this);
            }
        };
    }

    public void addExcludedFramework(@NotNull FrameworkType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/framework/detection/impl/exclude/DetectionExcludesConfigurationImpl", "addExcludedFramework"));
        }
        this.convert();
        this.myExcludedFrameworks.add(type.getId());
        VirtualFilePointerContainer container = this.myExcludedFiles.remove(type.getId());
        if (container != null) {
            container.clear();
        }
    }

    public void addExcludedFile(@NotNull VirtualFile file, @Nullable FrameworkType type) {
        String typeId;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/framework/detection/impl/exclude/DetectionExcludesConfigurationImpl", "addExcludedFile"));
        }
        this.convert();
        String string = typeId = type != null ? type.getId() : null;
        if (typeId != null && this.myExcludedFrameworks.contains(typeId) || this.isFileExcluded(file, typeId)) {
            return;
        }
        VirtualFilePointerContainer container = this.myExcludedFiles.get(typeId);
        if (typeId == null) {
            for (VirtualFilePointerContainer pointerContainer : this.myExcludedFiles.values()) {
                this.removeDescendants(file, pointerContainer);
            }
        } else {
            this.removeDescendants(file, container);
        }
        container.add(file);
    }

    public void addExcludedUrl(@NotNull String url, @Nullable FrameworkType type) {
        String typeId;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/framework/detection/impl/exclude/DetectionExcludesConfigurationImpl", "addExcludedUrl"));
        }
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file != null) {
            this.addExcludedFile(file, type);
            return;
        }
        this.convert();
        String string = typeId = type != null ? type.getId() : null;
        if (typeId != null && this.myExcludedFrameworks.contains(typeId)) {
            return;
        }
        this.myExcludedFiles.get(typeId).add(url);
    }

    private void convert() {
        this.ensureOldSettingsLoaded();
        this.markAsConverted();
    }

    private void markAsConverted() {
        this.myConverted = true;
        OldFacetDetectionExcludesConfiguration.getInstance(this.myProject).loadState(null);
    }

    private void ensureOldSettingsLoaded() {
        OldFacetDetectionExcludesConfiguration oldConfiguration;
        ExcludesConfigurationState oldState;
        if (!this.myConverted && (oldState = (oldConfiguration = OldFacetDetectionExcludesConfiguration.getInstance(this.myProject)).convert()) != null) {
            this.doLoadState(oldState);
        }
    }

    public boolean isExcludedFromDetection(@NotNull VirtualFile file, @NotNull FrameworkType frameworkType) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/framework/detection/impl/exclude/DetectionExcludesConfigurationImpl", "isExcludedFromDetection"));
        }
        if (frameworkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkType", "com/intellij/framework/detection/impl/exclude/DetectionExcludesConfigurationImpl", "isExcludedFromDetection"));
        }
        this.ensureOldSettingsLoaded();
        return this.isExcludedFromDetection(frameworkType) || this.isFileExcluded(file, frameworkType.getId());
    }

    public boolean isExcludedFromDetection(@NotNull FrameworkType frameworkType) {
        if (frameworkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkType", "com/intellij/framework/detection/impl/exclude/DetectionExcludesConfigurationImpl", "isExcludedFromDetection"));
        }
        this.ensureOldSettingsLoaded();
        return !this.myDetectionEnabled || this.myExcludedFrameworks.contains(frameworkType.getId());
    }

    private boolean isFileExcluded(@NotNull VirtualFile file, @Nullable String typeId) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/framework/detection/impl/exclude/DetectionExcludesConfigurationImpl", "isFileExcluded"));
        }
        if (this.myExcludedFiles.containsKey(typeId) && DetectionExcludesConfigurationImpl.isUnder(file, this.myExcludedFiles.get(typeId))) {
            return true;
        }
        return typeId != null && this.myExcludedFiles.containsKey(null) && DetectionExcludesConfigurationImpl.isUnder(file, this.myExcludedFiles.get(null));
    }

    private static boolean isUnder(VirtualFile file, VirtualFilePointerContainer container) {
        for (VirtualFile excludedFile : container.getFiles()) {
            if (!VfsUtil.isAncestor((VirtualFile)excludedFile, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void removeDescendants(VirtualFile file, VirtualFilePointerContainer container) {
        for (VirtualFile virtualFile : container.getFiles()) {
            if (!VfsUtil.isAncestor((VirtualFile)file, (VirtualFile)virtualFile, (boolean)false)) continue;
            container.remove(this.myPointerManager.create(virtualFile, (Disposable)this, null));
        }
    }

    public void removeExcluded(@NotNull Collection<VirtualFile> files, FrameworkType frameworkType) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/framework/detection/impl/exclude/DetectionExcludesConfigurationImpl", "removeExcluded"));
        }
        this.ensureOldSettingsLoaded();
        if (!this.myDetectionEnabled || this.myExcludedFrameworks.contains(frameworkType.getId())) {
            files.clear();
            return;
        }
        Iterator<VirtualFile> iterator = files.iterator();
        while (iterator.hasNext()) {
            VirtualFile file = iterator.next();
            if (!this.isFileExcluded(file, frameworkType.getId())) continue;
            iterator.remove();
        }
    }

    @NotNull
    public ExcludesConfigurationState getActualState() {
        this.ensureOldSettingsLoaded();
        ExcludesConfigurationState state2 = new ExcludesConfigurationState();
        state2.setDetectionEnabled(this.myDetectionEnabled);
        state2.getFrameworkTypes().addAll(this.myExcludedFrameworks);
        Collections.sort(state2.getFrameworkTypes(), String.CASE_INSENSITIVE_ORDER);
        for (String typeId : this.myExcludedFiles.keySet()) {
            VirtualFilePointerContainer container = this.myExcludedFiles.get(typeId);
            for (String url : container.getUrls()) {
                state2.getFiles().add(new ExcludedFileState(url, typeId));
            }
        }
        Collections.sort(state2.getFiles(), new Comparator<ExcludedFileState>(){

            @Override
            public int compare(ExcludedFileState o1, ExcludedFileState o2) {
                return StringUtil.comparePairs((String)o1.getFrameworkType(), (String)o1.getUrl(), (String)o2.getFrameworkType(), (String)o2.getUrl(), (boolean)true);
            }
        });
        ExcludesConfigurationState excludesConfigurationState = state2;
        if (excludesConfigurationState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/impl/exclude/DetectionExcludesConfigurationImpl", "getActualState"));
        }
        return excludesConfigurationState;
    }

    @Nullable
    public ExcludesConfigurationState getState() {
        if (!this.myConverted) {
            return null;
        }
        return this.getActualState();
    }

    public void loadState(@Nullable ExcludesConfigurationState state2) {
        this.doLoadState(state2);
        if (!(this.myExcludedFiles.isEmpty() && this.myExcludedFrameworks.isEmpty() && this.myDetectionEnabled)) {
            this.markAsConverted();
        }
    }

    private void doLoadState(@Nullable ExcludesConfigurationState state2) {
        this.myExcludedFrameworks.clear();
        for (VirtualFilePointerContainer container : this.myExcludedFiles.values()) {
            container.clear();
        }
        boolean bl = this.myDetectionEnabled = state2 == null || state2.isDetectionEnabled();
        if (state2 != null) {
            this.myExcludedFrameworks.addAll(state2.getFrameworkTypes());
            for (ExcludedFileState fileState : state2.getFiles()) {
                this.myExcludedFiles.get(fileState.getFrameworkType()).add(fileState.getUrl());
            }
        }
    }

    public void dispose() {
    }
}

