/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;

class ShowUsagesTableCellRenderer
implements TableCellRenderer {
    private final UsageViewImpl myUsageView;
    @NotNull
    private final AtomicInteger myOutOfScopeUsages;
    @NotNull
    private final SearchScope mySearchScope;

    ShowUsagesTableCellRenderer(@NotNull UsageViewImpl usageView, @NotNull AtomicInteger outOfScopeUsages, @NotNull SearchScope searchScope) {
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/actions/ShowUsagesTableCellRenderer", "<init>"));
        }
        if (outOfScopeUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outOfScopeUsages", "com/intellij/find/actions/ShowUsagesTableCellRenderer", "<init>"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/find/actions/ShowUsagesTableCellRenderer", "<init>"));
        }
        this.myUsageView = usageView;
        this.myOutOfScopeUsages = outOfScopeUsages;
        this.mySearchScope = searchScope;
    }

    @Override
    public Component getTableCellRendererComponent(JTable list, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        UsageNode usageNode = value instanceof UsageNode ? (UsageNode)value : null;
        Usage usage = usageNode == null ? null : usageNode.getUsage();
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        Color fileBgColor = this.getBackgroundColor(isSelected, usage);
        Color bg = UIUtil.getListSelectionBackground();
        Color fg = UIUtil.getListSelectionForeground();
        Color panelBackground = isSelected ? bg : (fileBgColor == null ? list.getBackground() : fileBgColor);
        Color panelForeground = isSelected ? fg : list.getForeground();
        panel.setBackground(panelBackground);
        panel.setForeground(panelForeground);
        SimpleColoredComponent textChunks = new SimpleColoredComponent();
        textChunks.setIpad(new Insets(0, 0, 0, 0));
        textChunks.setBorder(null);
        if (usage == null || usageNode instanceof ShowUsagesAction.StringNode) {
            textChunks.append(value != null ? value.toString() : "", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, panelBackground, panelForeground, column, list, row);
        }
        if (usage == ShowUsagesAction.MORE_USAGES_SEPARATOR) {
            textChunks.append("...<");
            textChunks.append("more usages", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            textChunks.append(">...");
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, panelBackground, panelForeground, column, list, row);
        }
        if (usage == ShowUsagesAction.USAGES_OUTSIDE_SCOPE_SEPARATOR) {
            textChunks.append("...<");
            textChunks.append(UsageViewManagerImpl.outOfScopeMessage((int)this.myOutOfScopeUsages.get(), (SearchScope)this.mySearchScope), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            textChunks.append(">...");
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, panelBackground, panelForeground, column, list, row);
        }
        if (column == 0) {
            GroupNode parent = (GroupNode)usageNode.getParent();
            this.appendGroupText(parent, panel, fileBgColor);
        } else if (usage != ShowUsagesAction.MORE_USAGES_SEPARATOR && usage != ShowUsagesAction.USAGES_OUTSIDE_SCOPE_SEPARATOR) {
            UsagePresentation presentation = usage.getPresentation();
            TextChunk[] text = presentation.getText();
            if (column == 1) {
                Icon icon = presentation.getIcon();
                textChunks.setIcon(icon == null ? EmptyIcon.ICON_16 : icon);
                if (text.length != 0) {
                    SimpleTextAttributes attributes = isSelected ? new SimpleTextAttributes(bg, fg, fg, 2) : ShowUsagesTableCellRenderer.deriveAttributesWithColor(text[0].getSimpleAttributesIgnoreBackground(), fileBgColor);
                    textChunks.append(text[0].getText(), attributes);
                }
            } else if (column == 2) {
                for (int i = 1; i < text.length; ++i) {
                    TextChunk textChunk = text[i];
                    SimpleTextAttributes attrs = textChunk.getSimpleAttributesIgnoreBackground();
                    SimpleTextAttributes attributes = isSelected ? new SimpleTextAttributes(bg, fg, fg, attrs.getStyle()) : ShowUsagesTableCellRenderer.deriveAttributesWithColor(attrs, fileBgColor);
                    textChunks.append(textChunk.getText(), attributes);
                }
            } else assert (false) : column;
        }
        panel.add((Component)textChunks);
        return panel;
    }

    @NotNull
    private static Component textComponentSpanningWholeRow(@NotNull SimpleColoredComponent chunks, Color panelBackground, Color panelForeground, final int column, final @NotNull JTable table, int row) {
        if (chunks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunks", "com/intellij/find/actions/ShowUsagesTableCellRenderer", "textComponentSpanningWholeRow"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/find/actions/ShowUsagesTableCellRenderer", "textComponentSpanningWholeRow"));
        }
        SimpleColoredComponent component = new SimpleColoredComponent(){

            protected void doPaint(Graphics2D g) {
                int offset = 0;
                TableColumnModel columnModel = table.getColumnModel();
                for (int i = 0; i < column; ++i) {
                    offset += columnModel.getColumn(i).getWidth();
                }
                g.translate(-offset, 0);
                this.setSize(this.getWidth() + offset, this.getHeight());
                super.doPaint(g);
                g.translate(offset, 0);
            }

            @NotNull
            public Dimension getPreferredSize() {
                Dimension dimension = column == table.getColumnModel().getColumnCount() - 1 ? super.getPreferredSize() : new Dimension(0, 0);
                if (dimension == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesTableCellRenderer$1", "getPreferredSize"));
                }
                return dimension;
            }
        };
        component.setIpad(new Insets(0, 0, 0, 0));
        component.setBorder(null);
        component.setBackground(panelBackground);
        component.setForeground(panelForeground);
        SimpleColoredComponent.ColoredIterator iterator = chunks.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            String fragment = iterator.getFragment();
            SimpleTextAttributes attributes = iterator.getTextAttributes();
            attributes = attributes.derive(attributes.getStyle(), panelForeground, panelBackground, attributes.getWaveColor());
            component.append(fragment, attributes);
        }
        SimpleColoredComponent simpleColoredComponent = component;
        if (simpleColoredComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesTableCellRenderer", "textComponentSpanningWholeRow"));
        }
        return simpleColoredComponent;
    }

    private static SimpleTextAttributes deriveAttributesWithColor(SimpleTextAttributes attributes, Color fileBgColor) {
        if (fileBgColor != null) {
            attributes = attributes.derive(-1, null, fileBgColor, null);
        }
        return attributes;
    }

    private Color getBackgroundColor(boolean isSelected, Usage usage) {
        Color fileBgColor = null;
        if (isSelected) {
            fileBgColor = UIUtil.getListSelectionBackground();
        } else {
            Color color;
            Project project;
            PsiFile psiFile;
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = virtualFile = usage instanceof UsageInFile ? ((UsageInFile)usage).getFile() : null;
            if (virtualFile != null && (psiFile = PsiManager.getInstance((Project)(project = this.myUsageView.getProject())).findFile(virtualFile)) != null && psiFile.isValid() && (color = FileColorManager.getInstance((Project)project).getRendererBackground(psiFile)) != null) {
                fileBgColor = color;
            }
        }
        return fileBgColor;
    }

    private void appendGroupText(GroupNode node, JPanel panel, Color fileBgColor) {
        UsageGroup group;
        UsageGroup usageGroup = group = node == null ? null : node.getGroup();
        if (group == null) {
            return;
        }
        GroupNode parentGroup = (GroupNode)node.getParent();
        this.appendGroupText(parentGroup, panel, fileBgColor);
        if (node.canNavigateToSource()) {
            SimpleColoredComponent renderer = new SimpleColoredComponent();
            renderer.setIcon(group.getIcon(false));
            SimpleTextAttributes attributes = ShowUsagesTableCellRenderer.deriveAttributesWithColor(SimpleTextAttributes.REGULAR_ATTRIBUTES, fileBgColor);
            renderer.append(group.getText((UsageView)this.myUsageView), attributes);
            renderer.append(" ", attributes);
            renderer.setIpad(new Insets(0, 0, 0, 0));
            renderer.setBorder(null);
            panel.add((Component)renderer);
        }
    }
}

