/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics;

import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FeaturesUsageCollector
extends UsagesCollector {
    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create("productivity", -100.0);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/featureStatistics/FeaturesUsageCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@Nullable Project project) {
        HashSet usages = new HashSet();
        FeatureUsageTracker usageTracker = FeatureUsageTracker.getInstance();
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        for (String featureId : registry.getFeatureIds()) {
            FeatureDescriptor featureDescriptor = registry.getFeatureDescriptor(featureId);
            if (featureDescriptor == null) continue;
            usages.add(new UsageDescriptor(featureId, featureDescriptor.getUsageCount()));
        }
        HashSet hashSet = usages;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/featureStatistics/FeaturesUsageCollector", "getUsages"));
        }
        return hashSet;
    }
}

