/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.statistics;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleTypeUsagesCollector
extends AbstractApplicationUsagesCollector {
    public static final String GROUP_ID = "module type";

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create(GROUP_ID, 100.0);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/statistics/ModuleTypeUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/facet/impl/statistics/ModuleTypeUsagesCollector", "getProjectUsages"));
        }
        HashSet<String> modulesTypes = new HashSet<String>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            modulesTypes.add(ModuleType.get((Module)module).getId());
        }
        Set set = ContainerUtil.map2Set(modulesTypes, (Function)new Function<String, UsageDescriptor>(){

            public UsageDescriptor fun(String moduleType) {
                return new UsageDescriptor(moduleType, 1);
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/statistics/ModuleTypeUsagesCollector", "getProjectUsages"));
        }
        return set;
    }
}

