/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.statistics;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FrameworkUsagesCollector
extends AbstractApplicationUsagesCollector {
    public static final String GROUP_ID = "frameworks";

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create(GROUP_ID, 100.0);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/statistics/FrameworkUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/facet/impl/statistics/FrameworkUsagesCollector", "getProjectUsages"));
        }
        HashSet facets = new HashSet();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (Facet facet : FacetManager.getInstance((Module)module).getAllFacets()) {
                facets.add(facet.getType().getStringId());
            }
        }
        Set set = ContainerUtil.map2Set((Collection)facets, (Function)new Function<String, UsageDescriptor>(){

            public UsageDescriptor fun(String facet) {
                return new UsageDescriptor(facet, 1);
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/statistics/FrameworkUsagesCollector", "getProjectUsages"));
        }
        return set;
    }
}

