/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.CellTransform;
import com.intellij.execution.ui.layout.Grid;
import com.intellij.execution.ui.layout.GridCell;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.View;
import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.execution.ui.layout.actions.CloseViewAction;
import com.intellij.execution.ui.layout.actions.MinimizeViewAction;
import com.intellij.execution.ui.layout.actions.RestoreViewAction;
import com.intellij.execution.ui.layout.impl.GridCellImpl;
import com.intellij.execution.ui.layout.impl.GridImpl;
import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.execution.ui.layout.impl.RunnerLayout;
import com.intellij.execution.ui.layout.impl.TabImpl;
import com.intellij.execution.ui.layout.impl.ViewContextEx;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.docking.DragSession;
import com.intellij.ui.docking.impl.DockManagerImpl;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.ui.switcher.SwitchProvider;
import com.intellij.ui.switcher.SwitchTarget;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerContentUi
implements ContentUI,
Disposable,
CellTransform.Facade,
ViewContextEx,
PropertyChangeListener,
SwitchProvider,
QuickActionProvider,
DockContainer.Dialog {
    public static final DataKey<RunnerContentUi> KEY = DataKey.create((String)"DebuggerContentUI");
    @NonNls
    private static final String LAYOUT = "Runner.Layout";
    @NonNls
    private static final String SETTINGS = "XDebugger.Settings";
    @NonNls
    private static final String VIEW_POPUP = "Runner.View.Popup";
    @NonNls
    static final String VIEW_TOOLBAR = "Runner.View.Toolbar";
    private ContentManager myManager;
    private final RunnerLayout myLayoutSettings;
    @NotNull
    private final ActionManager myActionManager;
    private final String mySessionName;
    private final MyComponent myComponent;
    private final Wrapper myToolbar;
    final MyDragOutDelegate myDragOutDelegate;
    JBRunnerTabs myTabs;
    private final Comparator<TabInfo> myTabsComparator;
    private final Project myProject;
    private ActionGroup myTopActions;
    private final DefaultActionGroup myMinimizedViewActions;
    private final Map<GridImpl, Wrapper> myMinimizedButtonsPlaceholder;
    private final Map<GridImpl, Wrapper> myCommonActionsPlaceholder;
    private final Map<GridImpl, AnAction[]> myContextActions;
    private boolean myUiLastStateWasRestored;
    private final Set<Object> myRestoreStateRequestors;
    private String myActionsPlace;
    private final IdeFocusManager myFocusManager;
    private boolean myMinimizeActionEnabled;
    private boolean myMoveToGridActionEnabled;
    private final RunnerLayoutUi myRunnerUi;
    private final Map<String, LayoutAttractionPolicy> myAttractions;
    private final Map<String, LayoutAttractionPolicy> myConditionAttractions;
    private ActionGroup myTabPopupActions;
    private ActionGroup myAdditionalFocusActions;
    private final ActionCallback myInitialized;
    private boolean myToDisposeRemovedContent;
    private int myAttractionCount;
    private ActionGroup myLeftToolbarActions;
    private JBTabs myCurrentOver;
    private Image myCurrentOverImg;
    private TabInfo myCurrentOverInfo;
    private MyDropAreaPainter myCurrentPainter;
    private RunnerContentUi myOriginal;
    private final CopyOnWriteArraySet<DockContainer.Listener> myDockingListeners;
    private final Set<RunnerContentUi> myChildren;
    private int myWindow;
    private boolean myDisposing;

    public RunnerContentUi(@NotNull Project project, @NotNull RunnerLayoutUi ui, @NotNull ActionManager actionManager, @NotNull IdeFocusManager focusManager, @NotNull RunnerLayout settings, @NotNull String sessionName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "<init>"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "<init>"));
        }
        if (actionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "<init>"));
        }
        if (focusManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusManager", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "<init>"));
        }
        if (sessionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionName", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "<init>"));
        }
        this.myComponent = new MyComponent();
        this.myToolbar = new Wrapper();
        this.myDragOutDelegate = new MyDragOutDelegate();
        this.myTabsComparator = new Comparator<TabInfo>(){

            @Override
            public int compare(@NotNull TabInfo o1, @NotNull TabInfo o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/execution/ui/layout/impl/RunnerContentUi$1", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/execution/ui/layout/impl/RunnerContentUi$1", "compare"));
                }
                TabImpl tab1 = RunnerContentUi.getTabFor(o1);
                TabImpl tab2 = RunnerContentUi.getTabFor(o2);
                int index1 = tab1 != null ? tab1.getIndex() : -1;
                int index2 = tab2 != null ? tab2.getIndex() : -1;
                return index1 - index2;
            }
        };
        this.myTopActions = new DefaultActionGroup();
        this.myMinimizedViewActions = new DefaultActionGroup();
        this.myMinimizedButtonsPlaceholder = new HashMap<GridImpl, Wrapper>();
        this.myCommonActionsPlaceholder = new HashMap<GridImpl, Wrapper>();
        this.myContextActions = new HashMap<GridImpl, AnAction[]>();
        this.myRestoreStateRequestors = new HashSet<Object>();
        this.myActionsPlace = "unknown";
        this.myMinimizeActionEnabled = true;
        this.myMoveToGridActionEnabled = true;
        this.myAttractions = new HashMap<String, LayoutAttractionPolicy>();
        this.myConditionAttractions = new HashMap<String, LayoutAttractionPolicy>();
        this.myInitialized = new ActionCallback();
        this.myToDisposeRemovedContent = true;
        this.myDockingListeners = new CopyOnWriteArraySet();
        this.myChildren = new TreeSet<RunnerContentUi>(new Comparator<RunnerContentUi>(){

            @Override
            public int compare(@NotNull RunnerContentUi o1, @NotNull RunnerContentUi o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/execution/ui/layout/impl/RunnerContentUi$2", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/execution/ui/layout/impl/RunnerContentUi$2", "compare"));
                }
                return o1.myWindow - o2.myWindow;
            }
        });
        this.myProject = project;
        this.myRunnerUi = ui;
        this.myLayoutSettings = settings;
        this.myActionManager = actionManager;
        this.mySessionName = sessionName;
        this.myFocusManager = focusManager;
    }

    public RunnerContentUi(@NotNull RunnerContentUi ui, @NotNull RunnerContentUi original, int window) {
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "<init>"));
        }
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "<init>"));
        }
        this(ui.myProject, ui.myRunnerUi, ui.myActionManager, ui.myFocusManager, ui.myLayoutSettings, ui.mySessionName);
        this.myOriginal = original;
        original.myChildren.add(this);
        this.myWindow = window == 0 ? original.findFreeWindow() : window;
    }

    public void setTopActions(@NotNull ActionGroup topActions, @NotNull String place) {
        if (topActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topActions", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "setTopActions"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "setTopActions"));
        }
        this.myTopActions = topActions;
        this.myActionsPlace = place;
        this.rebuildCommonActions();
    }

    public void setTabPopupActions(ActionGroup tabPopupActions) {
        this.myTabPopupActions = tabPopupActions;
        this.rebuildTabPopup();
    }

    public void setAdditionalFocusActions(ActionGroup group) {
        this.myAdditionalFocusActions = group;
        this.rebuildTabPopup();
    }

    public void setLeftToolbar(ActionGroup group, String place) {
        ActionToolbar tb = this.myActionManager.createActionToolbar(place, group, false);
        tb.setTargetComponent((JComponent)((Object)this.myComponent));
        this.myToolbar.setContent(tb.getComponent());
        this.myLeftToolbarActions = group;
        this.myComponent.revalidate();
        this.myComponent.repaint();
    }

    public void initUi() {
        if (this.myTabs != null) {
            return;
        }
        this.myTabs = (JBRunnerTabs)new JBRunnerTabs(this.myProject, this.myActionManager, this.myFocusManager, this).setDataProvider(new DataProvider(){

            public Object getData(@NonNls String dataId) {
                if (ViewContext.CONTENT_KEY.is(dataId)) {
                    TabInfo info = RunnerContentUi.this.myTabs.getTargetInfo();
                    if (info != null) {
                        return RunnerContentUi.getGridFor(info).getData(dataId);
                    }
                } else if (ViewContext.CONTEXT_KEY.is(dataId)) {
                    return RunnerContentUi.this;
                }
                return null;
            }
        }).setTabLabelActionsAutoHide(false).setProvideSwitchTargets(false).setInnerInsets(new Insets(0, 0, 0, 0)).setToDrawBorderIfTabsHidden(false).setTabDraggingEnabled(this.isMoveToGridActionEnabled()).setUiDecorator(null).getJBTabs();
        this.rebuildTabPopup();
        this.myTabs.getPresentation().setPaintBorder(0, 0, 0, 0).setPaintFocus(false).setRequestFocusOnLastFocusedComponent(true);
        this.myTabs.getComponent().setBackground(this.myToolbar.getBackground());
        this.myTabs.getComponent().setBorder(new EmptyBorder(0, 2, 0, 0));
        NonOpaquePanel wrappper = new NonOpaquePanel((LayoutManager)new BorderLayout(0, 0));
        wrappper.add((Component)this.myToolbar, (Object)"West");
        wrappper.add((Component)this.myTabs.getComponent(), (Object)"Center");
        this.myComponent.setContent((JComponent)wrappper);
        this.myTabs.addListener((TabsListener)new TabsListener.Adapter(){

            public void beforeSelectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                GridImpl grid;
                if (oldSelection != null && !RunnerContentUi.this.isStateBeingRestored() && (grid = RunnerContentUi.getGridFor(oldSelection)) != null && RunnerContentUi.this.getTabFor(grid) != null) {
                    grid.saveUiState();
                }
            }

            public void tabsMoved() {
                RunnerContentUi.this.saveUiState();
            }

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                if (!RunnerContentUi.this.myTabs.getComponent().isShowing()) {
                    return;
                }
                if (newSelection != null) {
                    newSelection.stopAlerting();
                    RunnerContentUi.getGridFor(newSelection).processAddToUi(false);
                }
                if (oldSelection != null) {
                    RunnerContentUi.getGridFor(oldSelection).processRemoveFromUi();
                }
            }
        });
        this.myTabs.addTabMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/ui/layout/impl/RunnerContentUi$5", "mousePressed"));
                }
                if (UIUtil.isCloseClick((MouseEvent)e)) {
                    Content[] contents;
                    TabInfo tabInfo = RunnerContentUi.this.myTabs.findInfo(e);
                    GridImpl grid = tabInfo == null ? null : RunnerContentUi.getGridFor(tabInfo);
                    Content[] contentArray = contents = grid != null ? (Content[])ViewContext.CONTENT_KEY.getData((DataProvider)grid) : null;
                    if (contents == null) {
                        return;
                    }
                    if (CloseViewAction.isEnabled(contents)) {
                        CloseViewAction.perform(RunnerContentUi.this, contents[0]);
                    } else if (MinimizeViewAction.isEnabled(RunnerContentUi.this, contents, "debuggerTabToolbar")) {
                        grid.getCellFor(contents[0]).minimize(contents[0]);
                    }
                }
            }
        });
        if (this.myOriginal != null) {
            ContentManager manager = ContentFactory.SERVICE.getInstance().createContentManager((ContentUI)this, false, this.myProject);
            Disposer.register((Disposable)((Disposable)this.myRunnerUi), (Disposable)manager);
            manager.getComponent();
        } else {
            DockManager dockManager = DockManager.getInstance((Project)this.myProject);
            if (dockManager != null) {
                dockManager.register((DockContainer)this);
            }
        }
    }

    private void rebuildTabPopup() {
        this.initUi();
        this.myTabs.setPopupGroup(this.getCellPopupGroup("debuggerTabPopup"), "debuggerTabPopup", true);
        for (GridImpl each : this.getGrids()) {
            each.rebuildTabPopup();
        }
    }

    @Override
    public ActionGroup getCellPopupGroup(String place) {
        AnAction[] originalActions;
        ActionGroup original = this.myTabPopupActions != null ? this.myTabPopupActions : (ActionGroup)this.myActionManager.getAction(VIEW_POPUP);
        ActionGroup focusPlaceholder = (ActionGroup)this.myActionManager.getAction("Runner.Focus");
        DefaultActionGroup group = new DefaultActionGroup(VIEW_POPUP, original.isPopup());
        AnActionEvent event = new AnActionEvent(null, DataManager.getInstance().getDataContext(), place, new Presentation(), ActionManager.getInstance(), 0);
        for (AnAction each : originalActions = original.getChildren(event)) {
            if (each == focusPlaceholder) {
                AnAction[] focusActions;
                for (AnAction eachFocus : focusActions = ((ActionGroup)each).getChildren(event)) {
                    group.add(eachFocus);
                }
                if (this.myAdditionalFocusActions == null) continue;
                for (AnAction action : this.myAdditionalFocusActions.getChildren(event)) {
                    group.add(action);
                }
                continue;
            }
            group.add(each);
        }
        return group;
    }

    @Override
    public boolean isOriginal() {
        return this.myOriginal == null;
    }

    @Override
    public int getWindow() {
        return this.myWindow;
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent evt) {
        if (evt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "propertyChange"));
        }
        Content content = (Content)evt.getSource();
        GridImpl grid = this.getGridFor(content, false);
        if (grid == null) {
            return;
        }
        GridCellImpl cell = grid.findCell(content);
        if (cell == null) {
            return;
        }
        String property = evt.getPropertyName();
        if ("alerting".equals(property)) {
            this.attract(content, true);
        } else if ("displayName".equals(property) || "icon".equals(property) || "actions".equals(property) || "description".equals(property)) {
            cell.updateTabPresentation(content);
            this.updateTabsUI(false);
        }
    }

    public void processBounce(Content content, boolean activate) {
        GridImpl grid = this.getGridFor(content, false);
        if (grid == null) {
            return;
        }
        GridCellImpl cell = grid.findCell(content);
        if (cell == null) {
            return;
        }
        TabInfo tab = this.myTabs.findInfo((Component)((Object)grid));
        if (tab == null) {
            return;
        }
        if (this.getSelectedGrid() != grid) {
            tab.setAlertIcon(content.getAlertIcon());
            if (activate) {
                tab.fireAlert();
            } else {
                tab.stopAlerting();
            }
        } else {
            grid.processAlert(content, activate);
        }
    }

    @Override
    public ActionCallback detachTo(int window, GridCell cell) {
        if (this.myOriginal != null) {
            return this.myOriginal.detachTo(window, cell);
        }
        RunnerContentUi target = null;
        if (window > 0) {
            for (RunnerContentUi child : this.myChildren) {
                if (child.myWindow != window) continue;
                target = child;
                break;
            }
        }
        GridCellImpl gridCell = (GridCellImpl)cell;
        Content[] contents = gridCell.getContents();
        this.storeDefaultIndices(contents);
        for (Content content : contents) {
            content.putUserData(RunnerLayout.DROP_INDEX, (Object)this.getStateFor(content).getTab().getIndex());
        }
        Dimension size = gridCell.getSize();
        if (size == null) {
            size = new Dimension(200, 200);
        }
        DockableGrid content = new DockableGrid(null, null, size, Arrays.asList(contents), window);
        if (target != null) {
            target.add(content, null);
        } else {
            Point location = gridCell.getLocation();
            if (location == null) {
                location = this.getComponent().getLocationOnScreen();
            }
            location.translate(size.width / 2, size.height / 2);
            this.getDockManager().createNewDockContainerFor(content, new RelativePoint(location));
        }
        return new ActionCallback.Done();
    }

    private void storeDefaultIndices(@NotNull Content[] contents) {
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "storeDefaultIndices"));
        }
        for (Content content : contents) {
            content.putUserData(RunnerLayout.DEFAULT_INDEX, (Object)this.getStateFor(content).getTab().getDefaultIndex());
        }
    }

    public RelativeRectangle getAcceptArea() {
        return new RelativeRectangle(this.myTabs.getComponent());
    }

    public RelativeRectangle getAcceptAreaFallback() {
        return this.getAcceptArea();
    }

    @NotNull
    public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent content, RelativePoint point) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "getContentResponse"));
        }
        if (!(content instanceof DockableGrid)) {
            DockContainer.ContentResponse contentResponse = DockContainer.ContentResponse.DENY;
            if (contentResponse == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "getContentResponse"));
            }
            return contentResponse;
        }
        RunnerContentUi ui = ((DockableGrid)content).getOriginalRunnerUi();
        DockContainer.ContentResponse contentResponse = ui.getProject() == this.myProject && ui.mySessionName.equals(this.mySessionName) ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
        if (contentResponse == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "getContentResponse"));
        }
        return contentResponse;
    }

    public JComponent getComponent() {
        this.initUi();
        return this.myComponent;
    }

    public JComponent getContainerComponent() {
        this.initUi();
        return this.myManager.getComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull DockableContent dockable, RelativePoint dropTarget) {
        if (dockable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockable", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "add"));
        }
        DockableGrid dockableGrid = (DockableGrid)dockable;
        RunnerContentUi prev = dockableGrid.getRunnerUi();
        this.saveUiState();
        List<Content> contents = dockableGrid.getContents();
        boolean wasRestoring = this.myOriginal != null && this.myOriginal.isStateBeingRestored();
        this.setStateIsBeingRestored(true, this);
        try {
            Point point = dropTarget != null ? dropTarget.getPoint((Component)((Object)this.myComponent)) : null;
            boolean hadGrid = !this.myTabs.shouldAddToGlobal(point);
            for (Content content : contents) {
                View view = this.getStateFor(content);
                if (view.isMinimizedInGrid()) continue;
                prev.myManager.removeContent(content, false);
                this.myManager.removeContent(content, false);
                if (hadGrid && !wasRestoring) {
                    view.assignTab(this.getTabFor(this.getSelectedGrid()));
                    view.setPlaceInGrid(RunnerContentUi.calcPlaceInGrid(point, this.myComponent.getSize()));
                } else if (contents.size() == 1 && !wasRestoring) {
                    view.assignTab(null);
                    view.setPlaceInGrid(this.myLayoutSettings.getDefaultGridPlace(content));
                }
                view.setWindow(this.myWindow);
                this.myManager.addContent(content);
            }
        }
        finally {
            this.setStateIsBeingRestored(false, this);
        }
        this.saveUiState();
        this.updateTabsUI(true);
    }

    public void closeAll() {
        Content[] contents = this.myManager.getContents();
        if (this.myOriginal != null) {
            for (Content content : contents) {
                this.getStateFor(content).setWindow(0);
                this.myOriginal.myManager.addContent(content);
                GridCell cell = this.myOriginal.findCellFor(content);
                if (cell == null) continue;
                this.myOriginal.restoreContent((String)content.getUserData(ViewImpl.ID));
                cell.minimize(content);
            }
        }
        this.myManager.removeAllContents(false);
    }

    public void addListener(final DockContainer.Listener listener, Disposable parent) {
        this.myDockingListeners.add(listener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                RunnerContentUi.this.myDockingListeners.remove(listener);
            }
        });
    }

    public boolean isEmpty() {
        return this.myTabs.isEmptyVisible() || this.myDisposing;
    }

    public Image startDropOver(@NotNull DockableContent content, RelativePoint point) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "startDropOver"));
        }
        return null;
    }

    public Image processDropOver(@NotNull DockableContent dockable, RelativePoint dropTarget) {
        if (dockable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockable", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "processDropOver"));
        }
        JBTabs current = this.getTabsAt(dockable, dropTarget);
        if (this.myCurrentOver != null && this.myCurrentOver != current) {
            this.resetDropOver(dockable);
        }
        if (this.myCurrentOver == null && current != null) {
            this.myCurrentOver = current;
            Presentation presentation = dockable.getPresentation();
            this.myCurrentOverInfo = new TabInfo((JComponent)new JLabel("")).setText(presentation.getText()).setIcon(presentation.getIcon());
            this.myCurrentOverImg = this.myCurrentOver.startDropOver(this.myCurrentOverInfo, dropTarget);
        }
        if (this.myCurrentOver != null) {
            this.myCurrentOver.processDropOver(this.myCurrentOverInfo, dropTarget);
        }
        if (this.myCurrentPainter == null) {
            this.myCurrentPainter = new MyDropAreaPainter();
            IdeGlassPaneUtil.find((Component)((Object)this.myComponent)).addPainter((Component)((Object)this.myComponent), (Painter)this.myCurrentPainter, (Disposable)this);
        }
        this.myCurrentPainter.processDropOver(this, dockable, dropTarget);
        return this.myCurrentOverImg;
    }

    @NotNull
    private static PlaceInGrid calcPlaceInGrid(Point point, Dimension size) {
        if (point.x < size.width / 3) {
            PlaceInGrid placeInGrid = PlaceInGrid.left;
            if (placeInGrid == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "calcPlaceInGrid"));
            }
            return placeInGrid;
        }
        if (point.x > size.width * 2 / 3) {
            PlaceInGrid placeInGrid = PlaceInGrid.right;
            if (placeInGrid == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "calcPlaceInGrid"));
            }
            return placeInGrid;
        }
        if (point.y > size.height * 3 / 4) {
            PlaceInGrid placeInGrid = PlaceInGrid.bottom;
            if (placeInGrid == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "calcPlaceInGrid"));
            }
            return placeInGrid;
        }
        PlaceInGrid placeInGrid = PlaceInGrid.center;
        if (placeInGrid == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "calcPlaceInGrid"));
        }
        return placeInGrid;
    }

    @Nullable
    private JBTabs getTabsAt(DockableContent content, RelativePoint point) {
        if (content instanceof DockableGrid) {
            Point p = point.getPoint((Component)this.getComponent());
            for (Component c = SwingUtilities.getDeepestComponentAt(this.getComponent(), p.x, p.y); c != null; c = c.getParent()) {
                if (!(c instanceof JBRunnerTabs)) continue;
                return (JBTabs)c;
            }
        }
        return null;
    }

    public void resetDropOver(@NotNull DockableContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "resetDropOver"));
        }
        if (this.myCurrentOver != null) {
            this.myCurrentOver.resetDropOver(this.myCurrentOverInfo);
            this.myCurrentOver = null;
            this.myCurrentOverInfo = null;
            this.myCurrentOverImg = null;
            IdeGlassPaneUtil.find((Component)((Object)this.myComponent)).removePainter((Painter)this.myCurrentPainter);
            this.myCurrentPainter = null;
        }
    }

    public boolean isDisposeWhenEmpty() {
        return this.myOriginal != null;
    }

    public boolean isCycleRoot() {
        return false;
    }

    public void setManager(@NotNull ContentManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "setManager"));
        }
        assert (this.myManager == null);
        this.myManager = manager;
        this.myManager.addContentManagerListener(new ContentManagerListener(){

            public void contentAdded(ContentManagerEvent event) {
                RunnerContentUi.this.initUi();
                GridImpl grid = RunnerContentUi.this.getGridFor(event.getContent(), true);
                if (grid == null) {
                    return;
                }
                grid.add(event.getContent());
                if (RunnerContentUi.this.getSelectedGrid() == grid) {
                    grid.processAddToUi(false);
                }
                if (RunnerContentUi.this.myManager.getComponent().isShowing() && !RunnerContentUi.this.isStateBeingRestored()) {
                    grid.restoreLastUiState();
                }
                RunnerContentUi.this.updateTabsUI(false);
                event.getContent().addPropertyChangeListener((PropertyChangeListener)RunnerContentUi.this);
                RunnerContentUi.this.fireContentOpened(event.getContent());
            }

            public void contentRemoved(ContentManagerEvent event) {
                event.getContent().removePropertyChangeListener((PropertyChangeListener)RunnerContentUi.this);
                GridImpl grid = (GridImpl)RunnerContentUi.this.findGridFor(event.getContent());
                if (grid != null) {
                    grid.remove(event.getContent());
                    grid.processRemoveFromUi();
                    RunnerContentUi.this.removeGridIfNeeded(grid);
                }
                RunnerContentUi.this.updateTabsUI(false);
                RunnerContentUi.this.fireContentClosed(event.getContent());
            }

            public void contentRemoveQuery(ContentManagerEvent event) {
            }

            public void selectionChanged(ContentManagerEvent event) {
                if (RunnerContentUi.this.isStateBeingRestored()) {
                    return;
                }
                if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                    RunnerContentUi.this.select(event.getContent(), false);
                }
            }
        });
    }

    @Nullable
    private GridImpl getSelectedGrid() {
        TabInfo selection = this.myTabs.getSelectedInfo();
        return selection != null ? RunnerContentUi.getGridFor(selection) : null;
    }

    private void removeGridIfNeeded(GridImpl grid) {
        if (grid.isEmpty()) {
            this.myTabs.removeTab(this.myTabs.findInfo((Component)((Object)grid)));
            this.myMinimizedButtonsPlaceholder.remove((Object)grid);
            this.myCommonActionsPlaceholder.remove((Object)grid);
            Disposer.dispose((Disposable)grid);
        }
    }

    @Nullable
    private GridImpl getGridFor(@NotNull Content content, boolean createIfMissing) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "getGridFor"));
        }
        GridImpl grid = (GridImpl)this.findGridFor(content);
        if (grid != null || !createIfMissing) {
            return grid;
        }
        grid = new GridImpl(this, this.mySessionName);
        if (this.myCurrentOver != null || this.myOriginal != null) {
            int dropIndex;
            Integer forcedDropIndex = (Integer)content.getUserData(RunnerLayout.DROP_INDEX);
            int index = this.myTabs.getDropInfoIndex() + (this.myOriginal != null ? this.myOriginal.getTabOffsetFor(this) : 0);
            int n = dropIndex = forcedDropIndex != null ? forcedDropIndex : index;
            if (forcedDropIndex == null) {
                this.moveFollowingTabs(dropIndex);
            }
            int defaultIndex = (Integer)content.getUserData(RunnerLayout.DEFAULT_INDEX);
            TabImpl tab = this.myLayoutSettings.getOrCreateTab(forcedDropIndex != null ? forcedDropIndex : -1);
            tab.setDefaultIndex(defaultIndex);
            tab.setIndex(dropIndex);
            this.getStateFor(content).assignTab((Tab)tab);
            content.putUserData(RunnerLayout.DROP_INDEX, null);
            content.putUserData(RunnerLayout.DEFAULT_INDEX, null);
        }
        TabInfo tab = new TabInfo((JComponent)((Object)grid)).setObject((Object)this.getStateFor(content).getTab()).setText("Tab");
        Wrapper left = new Wrapper();
        this.myCommonActionsPlaceholder.put(grid, left);
        Wrapper minimizedToolbar = new Wrapper();
        this.myMinimizedButtonsPlaceholder.put(grid, minimizedToolbar);
        Wrapper searchComponent = new Wrapper();
        if (content.getSearchComponent() != null) {
            searchComponent.setContent(content.getSearchComponent());
        }
        TwoSideComponent right = new TwoSideComponent((JComponent)searchComponent, (JComponent)minimizedToolbar);
        TwoSideComponent sideComponent = new TwoSideComponent((JComponent)left, (JComponent)((Object)right));
        tab.setSideComponent((JComponent)((Object)sideComponent));
        tab.setTabLabelActions((ActionGroup)this.myActionManager.getAction(VIEW_TOOLBAR), "debuggerTabToolbar");
        this.myTabs.addTab(tab);
        this.myTabs.sortTabs(this.myTabsComparator);
        return grid;
    }

    private void moveFollowingTabs(int index) {
        if (this.myOriginal != null) {
            this.myOriginal.moveFollowingTabs(index);
            return;
        }
        RunnerContentUi.moveFollowingTabs(index, this.myTabs);
        for (RunnerContentUi child : this.myChildren) {
            RunnerContentUi.moveFollowingTabs(index, child.myTabs);
        }
    }

    public ActionGroup getSettingsActions() {
        return (ActionGroup)this.myActionManager.getAction(SETTINGS);
    }

    public ContentManager getContentManager(Content content) {
        if (RunnerContentUi.hasContent(this.myManager, content)) {
            return this.myManager;
        }
        for (RunnerContentUi child : this.myChildren) {
            if (!RunnerContentUi.hasContent(child.myManager, content)) continue;
            return child.myManager;
        }
        return this.myManager;
    }

    private static boolean hasContent(ContentManager manager, Content content) {
        for (Content c : manager.getContents()) {
            if (c != content) continue;
            return true;
        }
        return false;
    }

    private static void moveFollowingTabs(int index, JBRunnerTabs tabs) {
        for (TabInfo info : tabs.getTabs()) {
            int tabIndex;
            TabImpl tab = RunnerContentUi.getTabFor(info);
            if (tab == null || (tabIndex = tab.getIndex()) < index) continue;
            tab.setIndex(tabIndex + 1);
        }
    }

    private int getTabOffsetFor(RunnerContentUi ui) {
        int offset = this.myTabs.getTabCount();
        for (RunnerContentUi child : this.myChildren) {
            if (child == ui) break;
            offset += child.myTabs.getTabCount();
        }
        return offset;
    }

    @Nullable
    public GridCell findCellFor(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "findCellFor"));
        }
        GridImpl cell = this.getGridFor(content, false);
        return cell != null ? cell.getCellFor(content) : null;
    }

    private boolean rebuildToolbar() {
        boolean hasToolbarContent = this.rebuildCommonActions();
        return hasToolbarContent |= this.rebuildMinimizedActions();
    }

    private boolean rebuildCommonActions() {
        boolean hasToolbarContent = false;
        for (Map.Entry<GridImpl, Wrapper> entry : this.myCommonActionsPlaceholder.entrySet()) {
            DefaultActionGroup groupToBuild;
            Wrapper eachPlaceholder = entry.getValue();
            List<Content> contentList = entry.getKey().getContents();
            HashSet<Content> contents = new HashSet<Content>();
            contents.addAll(contentList);
            JComponent contextComponent = null;
            if (this.isHorizontalToolbar() && contents.size() == 1) {
                Content content = contentList.get(0);
                groupToBuild = new DefaultActionGroup();
                if (content.getActions() != null) {
                    groupToBuild.addAll(content.getActions());
                    groupToBuild.addSeparator();
                    contextComponent = content.getActionsContextComponent();
                }
                groupToBuild.addAll(this.myTopActions);
            } else {
                DefaultActionGroup group = new DefaultActionGroup();
                group.addAll(this.myTopActions);
                groupToBuild = group;
            }
            Object[] actions = groupToBuild.getChildren(null);
            if (!Arrays.equals(actions, this.myContextActions.get((Object)entry.getKey()))) {
                ActionToolbar tb = this.myActionManager.createActionToolbar(this.myActionsPlace, (ActionGroup)groupToBuild, true);
                tb.getComponent().setBorder(null);
                tb.setTargetComponent(contextComponent);
                eachPlaceholder.setContent(tb.getComponent());
            }
            if (groupToBuild.getChildrenCount() > 0) {
                hasToolbarContent = true;
            }
            this.myContextActions.put(entry.getKey(), (AnAction[])actions);
        }
        return hasToolbarContent;
    }

    private boolean rebuildMinimizedActions() {
        for (Map.Entry<GridImpl, Wrapper> entry : this.myMinimizedButtonsPlaceholder.entrySet()) {
            Wrapper eachPlaceholder = entry.getValue();
            ActionToolbar tb = this.myActionManager.createActionToolbar("DebuggerToolbar", (ActionGroup)this.myMinimizedViewActions, true);
            tb.getComponent().setBorder(null);
            tb.setReservePlaceAutoPopupIcon(false);
            JComponent minimized = tb.getComponent();
            eachPlaceholder.setContent(minimized);
        }
        this.myTabs.getComponent().revalidate();
        this.myTabs.getComponent().repaint();
        return this.myMinimizedViewActions.getChildrenCount() > 0;
    }

    private void updateTabsUI(boolean validateNow) {
        boolean hasToolbarContent = this.rebuildToolbar();
        HashSet<String> usedNames = new HashSet<String>();
        List tabs = this.myTabs.getTabs();
        for (TabInfo each : tabs) {
            hasToolbarContent |= this.updateTabUI(each, usedNames);
        }
        int tabsCount = tabs.size();
        for (RunnerContentUi child : this.myChildren) {
            tabsCount += child.myTabs.getTabCount();
        }
        this.myTabs.getPresentation().setHideTabs(!hasToolbarContent && tabsCount <= 1 && this.myOriginal == null);
        this.myTabs.updateTabActions(validateNow);
        if (validateNow) {
            this.myTabs.sortTabs(this.myTabsComparator);
        }
    }

    private boolean updateTabUI(TabInfo tab, Set<String> usedNames) {
        String title;
        TabImpl t = RunnerContentUi.getTabFor(tab);
        if (t == null) {
            return false;
        }
        Icon icon = t.getIcon();
        GridImpl grid = RunnerContentUi.getGridFor(tab);
        boolean hasToolbarContent = grid.updateGridUI();
        List<Content> contents = grid.getContents();
        String string = title = contents.size() > 1 ? t.getDisplayName() : null;
        if (title == null) {
            String name = this.myLayoutSettings.getDefaultDisplayName(t.getDefaultIndex());
            title = name != null && contents.size() > 1 && !usedNames.contains(name) ? name : StringUtil.join(contents, (Function)new NotNullFunction<Content, String>(){

                @NotNull
                public String fun(Content dom) {
                    String string = dom.getTabName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerContentUi$8", "fun"));
                    }
                    return string;
                }
            }, (String)" | ");
        }
        usedNames.add(title);
        boolean hidden = true;
        for (Content content : contents) {
            if (grid.isMinimized(content)) continue;
            hidden = false;
            break;
        }
        tab.setHidden(hidden);
        if (icon == null && contents.size() == 1) {
            icon = contents.get(0).getIcon();
        }
        tab.setDragOutDelegate((TabInfo.DragOutDelegate)(this.myTabs.getTabs().size() > 1 || !this.isOriginal() ? this.myDragOutDelegate : null));
        Tab gridTab = grid.getTab();
        tab.setText(title).setIcon((Icon)(gridTab != null && gridTab.isDefault() && contents.size() > 1 ? null : icon));
        return hasToolbarContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionCallback restoreLastUiState() {
        if (this.isStateBeingRestored()) {
            return new ActionCallback.Rejected();
        }
        try {
            this.setStateIsBeingRestored(true, this);
            ArrayList tabs = new ArrayList();
            tabs.addAll(this.myTabs.getTabs());
            ActionCallback result = new ActionCallback(tabs.size());
            for (TabInfo each : tabs) {
                RunnerContentUi.getGridFor(each).restoreLastUiState().notifyWhenDone(result);
            }
            ActionCallback actionCallback = result;
            return actionCallback;
        }
        finally {
            this.setStateIsBeingRestored(false, this);
        }
    }

    public void saveUiState() {
        if (this.isStateBeingRestored()) {
            return;
        }
        if (this.myOriginal != null) {
            this.myOriginal.saveUiState();
            return;
        }
        int offset = RunnerContentUi.updateTabsIndices(this.myTabs, 0);
        for (RunnerContentUi child : this.myChildren) {
            offset = RunnerContentUi.updateTabsIndices(child.myTabs, offset);
        }
        this.doSaveUiState();
    }

    private static int updateTabsIndices(JBRunnerTabs tabs, int offset) {
        for (TabInfo each : tabs.getTabs()) {
            int index = tabs.getIndexOf(each);
            TabImpl tab = RunnerContentUi.getTabFor(each);
            if (tab == null) continue;
            tab.setIndex(index >= 0 ? index + offset : index);
        }
        return offset + tabs.getTabCount();
    }

    private void doSaveUiState() {
        if (this.isStateBeingRestored()) {
            return;
        }
        for (TabInfo each : this.myTabs.getTabs()) {
            GridImpl eachGrid = RunnerContentUi.getGridFor(each);
            eachGrid.saveUiState();
        }
        for (RunnerContentUi child : this.myChildren) {
            child.doSaveUiState();
        }
    }

    @Nullable
    public Tab getTabFor(Grid grid) {
        TabInfo info = this.myTabs.findInfo((Component)grid);
        return RunnerContentUi.getTabFor(info);
    }

    public void showNotify() {
        Window window = SwingUtilities.getWindowAncestor((Component)((Object)this.myComponent));
        if (window instanceof IdeFrame.Child) {
            ((IdeFrame.Child)window).setFrameTitle(this.mySessionName);
        }
    }

    public void hideNotify() {
    }

    @Nullable
    private static TabImpl getTabFor(@Nullable TabInfo tab) {
        if (tab == null) {
            return null;
        }
        return (TabImpl)tab.getObject();
    }

    private static GridImpl getGridFor(TabInfo tab) {
        return (GridImpl)((Object)tab.getComponent());
    }

    @Nullable
    public Grid findGridFor(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "findGridFor"));
        }
        TabImpl tab = (TabImpl)this.getStateFor(content).getTab();
        for (TabInfo each : this.myTabs.getTabs()) {
            TabImpl t = RunnerContentUi.getTabFor(each);
            if (t == null || !t.equals(tab)) continue;
            return RunnerContentUi.getGridFor(each);
        }
        return null;
    }

    private ArrayList<GridImpl> getGrids() {
        ArrayList<GridImpl> result = new ArrayList<GridImpl>();
        for (TabInfo each : this.myTabs.getTabs()) {
            result.add(RunnerContentUi.getGridFor(each));
        }
        return result;
    }

    public void setHorizontalToolbar(boolean state2) {
        this.myLayoutSettings.setToolbarHorizontal(state2);
        for (GridImpl each : this.getGrids()) {
            each.setToolbarHorizontal(state2);
        }
        this.myContextActions.clear();
        this.updateTabsUI(false);
    }

    public boolean isSingleSelection() {
        return false;
    }

    public boolean isToSelectAddedContent() {
        return false;
    }

    public boolean canBeEmptySelection() {
        return true;
    }

    public void beforeDispose() {
        if (this.myOriginal != null) {
            this.myDisposing = true;
            this.fireContentClosed(null);
        }
    }

    public boolean canChangeSelectionTo(@NotNull Content content, boolean implicit) {
        GridImpl grid;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "canChangeSelectionTo"));
        }
        if (implicit && (grid = this.getGridFor(content, false)) != null) {
            return !grid.isMinimized(content);
        }
        return true;
    }

    @NotNull
    public String getCloseActionName() {
        String string = UIBundle.message((String)"tabbed.pane.close.tab.action.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "getCloseActionName"));
        }
        return string;
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        String string = UIBundle.message((String)"tabbed.pane.close.all.tabs.but.this.action.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "getCloseAllButThisActionName"));
        }
        return string;
    }

    @NotNull
    public String getPreviousContentActionName() {
        if ("Select Previous Tab" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "getPreviousContentActionName"));
        }
        return "Select Previous Tab";
    }

    @NotNull
    public String getNextContentActionName() {
        if ("Select Next Tab" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "getNextContentActionName"));
        }
        return "Select Next Tab";
    }

    public void dispose() {
        if (this.myOriginal != null) {
            this.myOriginal.myChildren.remove(this);
        }
        this.myMinimizedButtonsPlaceholder.clear();
        this.myCommonActionsPlaceholder.clear();
        this.myContextActions.clear();
        this.myOriginal = null;
        this.myTopActions = null;
        this.myAdditionalFocusActions = null;
        this.myLeftToolbarActions = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void restoreLayout() {
        void var6_13;
        int len$;
        RunnerContentUi[] arr$;
        RunnerContentUi[] children = this.myChildren.toArray(new RunnerContentUi[this.myChildren.size()]);
        ArrayList<Content> contents = new ArrayList<Content>();
        Collections.addAll(contents, this.myManager.getContents());
        for (RunnerContentUi runnerContentUi : children) {
            Collections.addAll(contents, runnerContentUi.myManager.getContents());
        }
        for (RunnerContentUi runnerContentUi : this.myMinimizedViewActions.getChildren(null)) {
            Content content = ((RestoreViewAction)((Object)runnerContentUi)).getContent();
            contents.add(content);
        }
        Content[] all = contents.toArray(new Content[contents.size()]);
        Arrays.sort(all, new Comparator<Content>(){

            @Override
            public int compare(@NotNull Content content, @NotNull Content content1) {
                if (content == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/ui/layout/impl/RunnerContentUi$9", "compare"));
                }
                if (content1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content1", "com/intellij/execution/ui/layout/impl/RunnerContentUi$9", "compare"));
                }
                int i = RunnerContentUi.this.getStateFor(content).getTab().getDefaultIndex();
                int i1 = RunnerContentUi.this.getStateFor(content1).getTab().getDefaultIndex();
                return i - i1;
            }
        });
        this.setStateIsBeingRestored(true, this);
        try {
            void var6_11;
            arr$ = children;
            len$ = arr$.length;
            boolean bl = false;
            while (var6_11 < len$) {
                RunnerContentUi runnerContentUi = arr$[var6_11];
                runnerContentUi.myManager.removeAllContents(false);
                ++var6_11;
            }
            this.myManager.removeAllContents(false);
            this.myMinimizedViewActions.removeAll();
        }
        finally {
            this.setStateIsBeingRestored(false, this);
        }
        this.myLayoutSettings.resetToDefault();
        arr$ = all;
        len$ = arr$.length;
        boolean bl = false;
        while (var6_13 < len$) {
            RunnerContentUi runnerContentUi = arr$[var6_13];
            this.myManager.addContent((Content)runnerContentUi);
            ++var6_13;
        }
        this.updateTabsUI(true);
    }

    public boolean isStateBeingRestored() {
        return !this.myRestoreStateRequestors.isEmpty();
    }

    public void setStateIsBeingRestored(boolean restoredNow, Object requestor) {
        if (restoredNow) {
            this.myRestoreStateRequestors.add(requestor);
        } else {
            this.myRestoreStateRequestors.remove(requestor);
        }
    }

    public ActionGroup getLayoutActions() {
        return (ActionGroup)this.myActionManager.getAction(LAYOUT);
    }

    public void updateActionsImmediately() {
        if (this.myToolbar.getTargetComponent() instanceof ActionToolbar) {
            ((ActionToolbar)this.myToolbar.getTargetComponent()).updateActionsImmediately();
        }
    }

    public void setMinimizeActionEnabled(boolean enabled) {
        this.myMinimizeActionEnabled = enabled;
    }

    public void setMovetoGridActionEnabled(boolean enabled) {
        this.myMoveToGridActionEnabled = enabled;
    }

    public boolean isMinimizeActionEnabled() {
        return this.myMinimizeActionEnabled && this.myOriginal == null;
    }

    public boolean isMoveToGridActionEnabled() {
        return this.myMoveToGridActionEnabled;
    }

    public void setPolicy(String contentId, LayoutAttractionPolicy policy) {
        this.myAttractions.put(contentId, policy);
    }

    public void setConditionPolicy(String condition, LayoutAttractionPolicy policy) {
        this.myConditionAttractions.put(condition, policy);
    }

    private static LayoutAttractionPolicy getOrCreatePolicyFor(String key, Map<String, LayoutAttractionPolicy> map, LayoutAttractionPolicy defaultPolicy) {
        LayoutAttractionPolicy policy = map.get(key);
        if (policy == null) {
            policy = defaultPolicy;
            map.put(key, policy);
        }
        return policy;
    }

    @Nullable
    public Content findContent(String key) {
        Content[] contents;
        ContentManager manager = this.getContentManager();
        if (manager == null || key == null) {
            return null;
        }
        for (Content content : contents = manager.getContents()) {
            String kind = (String)content.getUserData(ViewImpl.ID);
            if (!key.equals(kind)) continue;
            return content;
        }
        return null;
    }

    public void restoreContent(String key) {
        for (AnAction action : this.myMinimizedViewActions.getChildren(null)) {
            Content content = ((RestoreViewAction)action).getContent();
            if (!key.equals(content.getUserData(ViewImpl.ID))) continue;
            action.actionPerformed(null);
            return;
        }
    }

    public void setToDisposeRemovedContent(boolean toDispose) {
        this.myToDisposeRemovedContent = toDispose;
    }

    public boolean isToDisposeRemovedContent() {
        return this.myToDisposeRemovedContent;
    }

    private void attractOnStartup() {
        final int currentCount = this.myAttractionCount;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (currentCount < RunnerContentUi.this.myAttractionCount) {
                    return;
                }
                RunnerContentUi.this.attractByCondition("startup", false);
            }
        });
    }

    public void attract(Content content, boolean afterInitialized) {
        this.processAttraction((String)content.getUserData(ViewImpl.ID), this.myAttractions, (LayoutAttractionPolicy)new LayoutAttractionPolicy.Bounce(), afterInitialized, true);
    }

    public void attractByCondition(@NotNull String condition, boolean afterInitialized) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "attractByCondition"));
        }
        this.processAttraction(this.myLayoutSettings.getToFocus(condition), this.myConditionAttractions, this.myLayoutSettings.getAttractionPolicy(condition), afterInitialized, true);
    }

    public void clearAttractionByCondition(String condition, boolean afterInitialized) {
        this.processAttraction(this.myLayoutSettings.getToFocus(condition), this.myConditionAttractions, (LayoutAttractionPolicy)new LayoutAttractionPolicy.FocusOnce(), afterInitialized, false);
    }

    private void processAttraction(final String contentId, final Map<String, LayoutAttractionPolicy> policyMap, final LayoutAttractionPolicy defaultPolicy, final boolean afterInitialized, final boolean activate) {
        IdeFocusManager.getInstance((Project)this.getProject()).doWhenFocusSettlesDown(new Runnable(){

            @Override
            public void run() {
                RunnerContentUi.this.myInitialized.processOnDone(new Runnable(){

                    @Override
                    public void run() {
                        Content content = RunnerContentUi.this.findContent(contentId);
                        if (content == null) {
                            return;
                        }
                        LayoutAttractionPolicy policy = RunnerContentUi.getOrCreatePolicyFor(contentId, policyMap, defaultPolicy);
                        if (activate) {
                            if (!(policy instanceof LayoutAttractionPolicy.Bounce)) {
                                RunnerContentUi.this.myAttractionCount++;
                            }
                            policy.attract(content, RunnerContentUi.this.myRunnerUi);
                        } else {
                            policy.clearAttraction(content, RunnerContentUi.this.myRunnerUi);
                        }
                    }
                }, afterInitialized);
            }
        });
    }

    public static boolean ensureValid(JComponent c) {
        Container eachParent;
        if (c.getRootPane() == null) {
            return false;
        }
        for (eachParent = c.getParent(); eachParent != null && eachParent.isValid(); eachParent = eachParent.getParent()) {
        }
        if (eachParent == null) {
            eachParent = c.getRootPane();
        }
        eachParent.validate();
        return true;
    }

    public ContentUI getContentUI() {
        return this;
    }

    public void minimize(final Content content, CellTransform.Restore restore) {
        final Ref restoreAction = new Ref();
        this.myManager.removeContent(content, false);
        restoreAction.set((Object)new RestoreViewAction(content, new CellTransform.Restore(){

            public ActionCallback restoreInGrid() {
                RunnerContentUi.this.myMinimizedViewActions.remove((AnAction)restoreAction.get());
                GridImpl grid = RunnerContentUi.this.getGridFor(content, false);
                if (grid == null) {
                    RunnerContentUi.this.getStateFor(content).assignTab((Tab)RunnerContentUi.this.myLayoutSettings.getOrCreateTab(-1));
                } else {
                    ((GridCellImpl)RunnerContentUi.this.findCellFor(content)).restore(content);
                }
                RunnerContentUi.this.getStateFor(content).setMinimizedInGrid(false);
                RunnerContentUi.this.myManager.addContent(content);
                RunnerContentUi.this.saveUiState();
                RunnerContentUi.this.select(content, true);
                RunnerContentUi.this.updateTabsUI(false);
                return new ActionCallback.Done();
            }
        }));
        this.myMinimizedViewActions.add((AnAction)restoreAction.get());
        this.saveUiState();
        this.updateTabsUI(false);
    }

    public Project getProject() {
        return this.myProject;
    }

    public CellTransform.Facade getCellTransform() {
        return this;
    }

    public ContentManager getContentManager() {
        return this.myManager;
    }

    @NotNull
    public ActionManager getActionManager() {
        ActionManager actionManager = this.myActionManager;
        if (actionManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "getActionManager"));
        }
        return actionManager;
    }

    @Override
    public RunnerLayout getLayoutSettings() {
        return this.myLayoutSettings;
    }

    public View getStateFor(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/ui/layout/impl/RunnerContentUi", "getStateFor"));
        }
        return this.myLayoutSettings.getStateFor(content);
    }

    public boolean isHorizontalToolbar() {
        return this.myLayoutSettings.isToolbarHorizontal();
    }

    public ActionCallback select(final Content content, final boolean requestFocus) {
        final GridImpl grid = (GridImpl)this.findGridFor(content);
        if (grid == null) {
            return new ActionCallback.Done();
        }
        TabInfo info = this.myTabs.findInfo((Component)((Object)grid));
        if (info == null) {
            return new ActionCallback.Done();
        }
        final ActionCallback result = new ActionCallback();
        this.myTabs.select(info, false).doWhenDone(new Runnable(){

            @Override
            public void run() {
                grid.select(content, requestFocus).notifyWhenDone(result);
            }
        });
        return result;
    }

    public void validate(Content content, final ActiveRunnable toRestore) {
        final TabInfo current = this.myTabs.getSelectedInfo();
        this.myTabs.getPresentation().setPaintBlocked(true, true);
        this.select(content, false).doWhenDone(new Runnable(){

            @Override
            public void run() {
                RunnerContentUi.this.myTabs.getComponent().validate();
                toRestore.run().doWhenDone(new Runnable(){

                    @Override
                    public void run() {
                        assert (current != null);
                        RunnerContentUi.this.myTabs.select(current, true);
                        RunnerContentUi.this.myTabs.getPresentation().setPaintBlocked(false, true);
                    }
                });
            }
        });
    }

    public IdeFocusManager getFocusManager() {
        return this.myFocusManager;
    }

    public RunnerLayoutUi getRunnerLayoutUi() {
        return this.myRunnerUi;
    }

    public String getName() {
        return this.mySessionName;
    }

    public List<AnAction> getActions(boolean originalProvider) {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        if (this.myLeftToolbarActions != null) {
            Object[] kids = this.myLeftToolbarActions.getChildren(null);
            ContainerUtil.addAll(result, (Object[])kids);
        }
        return result;
    }

    public SwitchTarget getCurrentTarget() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            return this.myTabs.getCurrentTarget();
        }
        GridImpl grid = this.getSelectedGrid();
        if (grid != null && grid.getContents().size() <= 1) {
            return this.myTabs.getCurrentTarget();
        }
        if (grid != null) {
            SwitchTarget cell = grid.getCellFor(owner);
            return cell != null ? cell : this.myTabs.getCurrentTarget();
        }
        return this.myTabs.getCurrentTarget();
    }

    public List<SwitchTarget> getTargets(boolean onlyVisible, boolean originalProvider) {
        ArrayList<SwitchTarget> result = new ArrayList<SwitchTarget>();
        result.addAll(this.myTabs.getTargets(true, false));
        GridImpl grid = this.getSelectedGrid();
        if (grid != null) {
            result.addAll(grid.getTargets(onlyVisible));
        }
        for (Wrapper wrapper : this.myMinimizedButtonsPlaceholder.values()) {
            JComponent target;
            if (!wrapper.isShowing() || !((target = wrapper.getTargetComponent()) instanceof ActionToolbar)) continue;
            ActionToolbar tb = (ActionToolbar)target;
            result.addAll(tb.getTargets(onlyVisible, false));
        }
        return result;
    }

    private int findFreeWindow() {
        int i;
        for (i = 1; i < Integer.MAX_VALUE; ++i) {
            if (this.isUsed(i)) continue;
            return i;
        }
        return i;
    }

    private boolean isUsed(int i) {
        for (RunnerContentUi child : this.myChildren) {
            if (child.getWindow() != i) continue;
            return true;
        }
        return false;
    }

    private DockManagerImpl getDockManager() {
        return (DockManagerImpl)DockManager.getInstance((Project)this.myProject);
    }

    void fireContentOpened(Content content) {
        for (DockContainer.Listener each : this.myDockingListeners) {
            each.contentAdded((Object)content);
        }
    }

    void fireContentClosed(Content content) {
        for (DockContainer.Listener each : this.myDockingListeners) {
            each.contentRemoved((Object)content);
        }
    }

    class DockableGrid
    implements DockableContent<List<Content>> {
        private final Image myImg;
        private final Presentation myPresentation;
        private final Dimension myPreferredSize;
        private final List<Content> myContents;
        private final int myWindow;

        public DockableGrid(Image img, Presentation presentation, Dimension size, List<Content> contents, int window) {
            this.myImg = img;
            this.myPresentation = presentation;
            this.myPreferredSize = size;
            this.myContents = contents;
            this.myWindow = window;
        }

        @NotNull
        public List<Content> getKey() {
            List<Content> list = this.myContents;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerContentUi$DockableGrid", "getKey"));
            }
            return list;
        }

        public Image getPreviewImage() {
            return this.myImg;
        }

        public Dimension getPreferredSize() {
            return this.myPreferredSize;
        }

        public String getDockContainerType() {
            return "runner-grid";
        }

        public Presentation getPresentation() {
            return this.myPresentation;
        }

        public RunnerContentUi getRunnerUi() {
            return RunnerContentUi.this;
        }

        public RunnerContentUi getOriginalRunnerUi() {
            return RunnerContentUi.this.myOriginal != null ? RunnerContentUi.this.myOriginal : RunnerContentUi.this;
        }

        @NotNull
        public List<Content> getContents() {
            List<Content> list = this.myContents;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerContentUi$DockableGrid", "getContents"));
            }
            return list;
        }

        public void close() {
        }

        public int getWindow() {
            return this.myWindow;
        }
    }

    class MyDragOutDelegate
    implements TabInfo.DragOutDelegate {
        private DragSession mySession;

        MyDragOutDelegate() {
        }

        public void dragOutStarted(MouseEvent mouseEvent, TabInfo info) {
            JComponent component = info.getComponent();
            Content[] data = (Content[])ViewContext.CONTENT_KEY.getData((DataProvider)component);
            assert (data != null);
            RunnerContentUi.this.storeDefaultIndices(data);
            Dimension size = info.getComponent().getSize();
            Image image = JBTabsImpl.getComponentImage((TabInfo)info);
            if (component instanceof Grid) {
                info.setHidden(true);
            }
            Presentation presentation = new Presentation(info.getText());
            presentation.setIcon(info.getIcon());
            this.mySession = RunnerContentUi.this.getDockManager().createDragSession(mouseEvent, new DockableGrid(image, presentation, size, Arrays.asList(data), 0));
        }

        public void processDragOut(MouseEvent event, TabInfo source) {
            this.mySession.process(event);
        }

        public void dragOutFinished(MouseEvent event, TabInfo source) {
            Component component = event.getComponent();
            IdeFrame window = (IdeFrame)UIUtil.getParentOfType(IdeFrame.class, (Component)component);
            this.mySession.process(event);
            this.mySession = null;
        }

        public void dragOutCancelled(TabInfo source) {
            source.setHidden(false);
            this.mySession.cancel();
            this.mySession = null;
        }
    }

    private static class CommonToolbarLayout
    extends AbstractLayoutManager {
        private final JComponent myLeft;
        private final JComponent myRight;

        public CommonToolbarLayout(JComponent left, JComponent right) {
            this.myLeft = left;
            this.myRight = right;
        }

        public Dimension preferredLayoutSize(@NotNull Container parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/execution/ui/layout/impl/RunnerContentUi$CommonToolbarLayout", "preferredLayoutSize"));
            }
            Dimension size = new Dimension();
            Dimension leftSize = this.myLeft.getPreferredSize();
            Dimension rightSize = this.myRight.getPreferredSize();
            size.width = leftSize.width + rightSize.width;
            size.height = Math.max(leftSize.height, rightSize.height);
            return size;
        }

        public void layoutContainer(@NotNull Container parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/execution/ui/layout/impl/RunnerContentUi$CommonToolbarLayout", "layoutContainer"));
            }
            Dimension size = parent.getSize();
            Dimension prefSize = parent.getPreferredSize();
            if (prefSize.width <= size.width) {
                this.myLeft.setBounds(0, 0, this.myLeft.getPreferredSize().width, parent.getHeight());
                Dimension rightSize = this.myRight.getPreferredSize();
                this.myRight.setBounds(parent.getWidth() - rightSize.width, 0, rightSize.width, parent.getHeight());
            } else {
                Dimension leftMinSize = this.myLeft.getMinimumSize();
                Dimension rightMinSize = this.myRight.getMinimumSize();
                int delta = (prefSize.width - size.width) / 2;
                this.myLeft.setBounds(0, 0, this.myLeft.getPreferredSize().width - delta, parent.getHeight());
                int rightX = (int)this.myLeft.getBounds().getMaxX();
                int rightWidth = size.width - rightX;
                if (rightWidth < rightMinSize.width) {
                    Dimension leftSize = this.myLeft.getSize();
                    int diffToRightMin = rightMinSize.width - rightWidth;
                    if (leftSize.width - diffToRightMin >= leftMinSize.width) {
                        leftSize.width -= diffToRightMin;
                        this.myLeft.setSize(leftSize);
                    }
                }
                this.myRight.setBounds((int)this.myLeft.getBounds().getMaxX(), 0, parent.getWidth() - this.myLeft.getWidth(), parent.getHeight());
            }
            CommonToolbarLayout.toMakeVerticallyInCenter(this.myLeft, parent);
            CommonToolbarLayout.toMakeVerticallyInCenter(this.myRight, parent);
        }

        private static void toMakeVerticallyInCenter(JComponent comp, Container parent) {
            Rectangle compBounds = comp.getBounds();
            int compHeight = comp.getPreferredSize().height;
            int parentHeight = parent.getHeight();
            if (compHeight > parentHeight) {
                compHeight = parentHeight;
            }
            int y = (int)Math.floor((double)parentHeight / 2.0 - (double)compHeight / 2.0);
            comp.setBounds(compBounds.x, y, compBounds.width, compHeight);
        }
    }

    private static class TwoSideComponent
    extends NonOpaquePanel {
        private TwoSideComponent(JComponent left, JComponent right) {
            this.setLayout((LayoutManager)((Object)new CommonToolbarLayout(left, right)));
            this.add(left);
            this.add(right);
        }
    }

    private class MyComponent
    extends Wrapper.FocusHolder
    implements DataProvider,
    QuickActionProvider {
        private boolean myWasEverAdded;

        public MyComponent() {
            this.setOpaque(true);
            this.setFocusCycleRoot(true);
            this.setBorder((Border)new ToolWindow.Border(true, false, true, true));
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            JComponent originalContentComponent;
            if (KEY.is(dataId)) {
                return RunnerContentUi.this;
            }
            ContentManager originalContentManager = RunnerContentUi.this.myOriginal == null ? null : RunnerContentUi.this.myOriginal.getContentManager();
            JComponent jComponent = originalContentComponent = originalContentManager == null ? null : originalContentManager.getComponent();
            if (originalContentComponent instanceof DataProvider) {
                return ((DataProvider)originalContentComponent).getData(dataId);
            }
            return null;
        }

        public String getName() {
            return RunnerContentUi.this.getName();
        }

        public List<AnAction> getActions(boolean originalProvider) {
            return RunnerContentUi.this.getActions(originalProvider);
        }

        public JComponent getComponent() {
            return RunnerContentUi.this.getComponent();
        }

        public boolean isCycleRoot() {
            return RunnerContentUi.this.isCycleRoot();
        }

        public void addNotify() {
            super.addNotify();
            if (!RunnerContentUi.this.myUiLastStateWasRestored && RunnerContentUi.this.myOriginal == null) {
                RunnerContentUi.this.myUiLastStateWasRestored = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RunnerContentUi.this.restoreLastUiState().doWhenDone(new Runnable(){

                            @Override
                            public void run() {
                                if (!MyComponent.this.myWasEverAdded) {
                                    MyComponent.this.myWasEverAdded = true;
                                    RunnerContentUi.this.attractOnStartup();
                                    RunnerContentUi.this.myInitialized.setDone();
                                }
                            }
                        });
                    }
                });
            }
        }

        public void removeNotify() {
            super.removeNotify();
            if (!ScreenUtil.isStandardAddRemoveNotify((Component)((Object)this))) {
                return;
            }
            if (Disposer.isDisposed((Disposable)RunnerContentUi.this)) {
                return;
            }
            RunnerContentUi.this.saveUiState();
        }
    }

    private static class MyDropAreaPainter
    extends AbstractPainter {
        private Shape myBoundingBox;
        private final Color myColor = ColorUtil.mix((Color)JBColor.BLUE, (Color)JBColor.WHITE, (double)0.3);

        private MyDropAreaPainter() {
        }

        public boolean needsRepaint() {
            return this.myBoundingBox != null;
        }

        public void executePaint(Component component, Graphics2D g) {
            if (this.myBoundingBox == null) {
                return;
            }
            GraphicsUtil.setupAAPainting((Graphics)g);
            g.setColor(ColorUtil.toAlpha((Color)this.myColor, (int)200));
            g.setStroke(new BasicStroke(2.0f));
            g.draw(this.myBoundingBox);
            g.setColor(ColorUtil.toAlpha((Color)this.myColor, (int)40));
            g.fill(this.myBoundingBox);
        }

        private void processDropOver(RunnerContentUi ui, DockableContent dockable, RelativePoint dropTarget) {
            Point point;
            this.myBoundingBox = null;
            this.setNeedsRepaint(true);
            if (!(dockable instanceof DockableGrid)) {
                return;
            }
            MyComponent component = ui.myComponent;
            Point point2 = point = dropTarget != null ? dropTarget.getPoint((Component)((Object)component)) : null;
            if (ui.myTabs.shouldAddToGlobal(point)) {
                return;
            }
            PlaceInGrid targetPlaceInGrid = null;
            for (Content c : ((DockableGrid)dockable).getContents()) {
                View view = ui.getStateFor(c);
                if (view.isMinimizedInGrid()) continue;
                PlaceInGrid defaultGridPlace = ui.getLayoutSettings().getDefaultGridPlace(c);
                PlaceInGrid placeInGrid = targetPlaceInGrid = point == null ? defaultGridPlace : RunnerContentUi.calcPlaceInGrid(point, ((Component)((Object)component)).getSize());
                break;
            }
            if (targetPlaceInGrid == null) {
                return;
            }
            Dimension size = ((Component)((Object)component)).getSize();
            Rectangle r = new Rectangle(size);
            switch (targetPlaceInGrid) {
                case left: {
                    r.width /= 3;
                    break;
                }
                case center: {
                    r.width /= 3;
                    r.x += r.width;
                    break;
                }
                case right: {
                    r.width /= 3;
                    r.x += 2 * r.width;
                    break;
                }
                case bottom: {
                    r.height /= 4;
                    r.y += 3 * r.height;
                }
            }
            for (Content c : ui.getContentManager().getContents()) {
                JComponent cellWrapper;
                PlaceInGrid placeInGrid;
                GridCell cellFor = ui.findCellFor(c);
                PlaceInGrid placeInGrid2 = placeInGrid = cellFor == null ? null : ((GridCellImpl)cellFor).getPlaceInGrid();
                if (placeInGrid != targetPlaceInGrid) continue;
                Wrapper wrapper = (Wrapper)UIUtil.getParentOfType(Wrapper.class, (Component)c.getComponent());
                JComponent jComponent = cellWrapper = wrapper == null ? null : (JComponent)wrapper.getParent();
                if (cellWrapper == null || !cellWrapper.isShowing()) continue;
                r = new RelativeRectangle(cellWrapper).getRectangleOn((Component)((Object)component));
                break;
            }
            this.myBoundingBox = new RoundRectangle2D.Double(r.x, r.y, r.width, r.height, 16.0, 16.0);
        }
    }
}

