/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.StringTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestsLocationProviderUtil {
    @NonNls
    private static final String PROTOCOL_SEPARATOR = "://";
    private static final int MIN_PROXIMITY_THRESHOLD = 1;

    private TestsLocationProviderUtil() {
    }

    @Nullable
    public static String extractPath(@NotNull String locationUrl) {
        if (locationUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locationUrl", "com/intellij/execution/testframework/sm/TestsLocationProviderUtil", "extractPath"));
        }
        int index = locationUrl.indexOf(PROTOCOL_SEPARATOR);
        if (index >= 0) {
            return locationUrl.substring(index + PROTOCOL_SEPARATOR.length());
        }
        return null;
    }

    public static List<VirtualFile> findSuitableFilesFor(String filePath, Project project) {
        boolean inProjectContent;
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile file = TestsLocationProviderUtil.getByFullPath(filePath);
        boolean bl = inProjectContent = file != null && index.isInContent(file);
        if (inProjectContent) {
            return Collections.singletonList(file);
        }
        LinkedList<String> folders = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(filePath, "/", false);
        String fileName = null;
        while (st.hasMoreTokens()) {
            String pathComponent = st.nextToken();
            if (st.hasMoreTokens()) {
                folders.addFirst(pathComponent);
                continue;
            }
            fileName = pathComponent;
        }
        if (fileName == null) {
            return Collections.emptyList();
        }
        return TestsLocationProviderUtil.findFilesClosestToTarget(folders, TestsLocationProviderUtil.collectCandidates(project, fileName, true), 1);
    }

    public static List<VirtualFile> findFilesClosestToTarget(@NotNull List<String> targetParentFolders, List<FileInfo> candidates, int minProximityThreshold) {
        if (targetParentFolders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetParentFolders", "com/intellij/execution/testframework/sm/TestsLocationProviderUtil", "findFilesClosestToTarget"));
        }
        if (candidates.isEmpty()) {
            return Collections.emptyList();
        }
        for (String folderName : targetParentFolders) {
            for (FileInfo info : candidates) {
                info.processRelativePathComponent(folderName);
            }
        }
        int maxProximity = 0;
        for (FileInfo fileInfo : candidates) {
            int proximity = fileInfo.getProximity();
            if (proximity <= maxProximity) continue;
            maxProximity = proximity;
        }
        if (maxProximity >= minProximityThreshold) {
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
            for (FileInfo info : candidates) {
                if (info.getProximity() != maxProximity) continue;
                files.add(info.getFile());
            }
            return files;
        }
        return Collections.emptyList();
    }

    public static List<FileInfo> collectCandidates(Project project, String fileName, boolean includeNonProjectItems) {
        ChooseByNameContributor[] contributors;
        ArrayList<FileInfo> filesInfo = new ArrayList<FileInfo>();
        for (ChooseByNameContributor contributor : contributors = (ChooseByNameContributor[])Extensions.getExtensions((ExtensionPointName)ChooseByNameContributor.FILE_EP_NAME)) {
            NavigationItem[] navigationItems;
            for (NavigationItem navigationItem : navigationItems = contributor.getItemsByName(fileName, fileName, project, includeNonProjectItems)) {
                if (!(navigationItem instanceof PsiFile)) continue;
                VirtualFile itemFile = ((PsiFile)navigationItem).getVirtualFile();
                assert (itemFile != null);
                filesInfo.add(new FileInfo(itemFile));
            }
        }
        return filesInfo;
    }

    @Nullable
    private static VirtualFile getByFullPath(String filePath) {
        VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (fileByPath != null) {
            return fileByPath;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return TempFileSystem.getInstance().findFileByPath(filePath);
        }
        return null;
    }

    public static class FileInfo {
        private final VirtualFile myFile;
        private VirtualFile myCurrentFolder;
        private int myProximity = 0;

        public FileInfo(VirtualFile file) {
            this.myFile = file;
            this.myCurrentFolder = this.myFile.getParent();
        }

        public void processRelativePathComponent(String folderName) {
            if (this.myCurrentFolder == null) {
                return;
            }
            if (!folderName.equals(this.myCurrentFolder.getName())) {
                this.myCurrentFolder = null;
                return;
            }
            ++this.myProximity;
            this.myCurrentFolder = this.myCurrentFolder.getParent();
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public int getProximity() {
            return this.myProximity;
        }
    }
}

