/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class SMRunnerUtil {
    private static final Logger LOG = Logger.getInstance((String)SMRunnerUtil.class.getName());

    private SMRunnerUtil() {
    }

    public static void addToInvokeLater(Runnable runnable) {
        Application application = ApplicationManager.getApplication();
        if (application.isHeadlessEnvironment() && !application.isUnitTestMode()) {
            runnable.run();
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        }
    }

    public static void registerAsAction(KeyStroke keyStroke, String actionKey, final Runnable action, JComponent component) {
        InputMap inputMap = component.getInputMap(1);
        inputMap.put(keyStroke, actionKey);
        component.getActionMap().put(inputMap.get(keyStroke), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                action.run();
            }
        });
    }

    public static void runInEventDispatchThread(final Runnable runnable, ModalityState state2) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        runnable.run();
                    }
                }, state2);
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }
}

