/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.autotest;

import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.autotest.AutoTestManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdjustAutotestDelayActionGroup
extends ActionGroup {
    public static final int MAX_DELAY = 10;
    private final ExecutionEnvironment myEnvironment;

    public AdjustAutotestDelayActionGroup(ExecutionEnvironment environment) {
        super("Set AutoTest Delay", true);
        this.myEnvironment = environment;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(Boolean.TRUE == this.myEnvironment.getUserData(AutoTestManager.AUTOTESTABLE));
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] actions = new AnAction[10];
        for (int i = 0; i < 10; ++i) {
            actions[i] = new SetAutoTestDelayAction(this.myEnvironment.getProject(), i + 1);
        }
        if (actions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/autotest/AdjustAutotestDelayActionGroup", "getChildren"));
        }
        return actions;
    }

    private static class SetAutoTestDelayAction
    extends ToggleAction {
        private final int myDelay;
        @NotNull
        private final Project myProject;

        public SetAutoTestDelayAction(@NotNull Project project, int delay) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/autotest/AdjustAutotestDelayActionGroup$SetAutoTestDelayAction", "<init>"));
            }
            super(delay + "s");
            this.myProject = project;
            this.myDelay = delay * 1000;
        }

        public boolean isSelected(AnActionEvent e) {
            return AutoTestManager.getInstance(this.myProject).getDelay() == this.myDelay;
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            AutoTestManager.getInstance(this.myProject).setDelay(this.myDelay);
        }
    }
}

