/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RerunTestsAction
extends DumbAwareAction
implements AnAction.TransparentUpdate {
    public static final String ID = "RerunTests";
    private static final Set<ExecutionEnvironment> REGISTRY = ContainerUtil.newHashSet();

    public static void register(final @NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/runners/RerunTestsAction", "register"));
        }
        if (REGISTRY.add(environment)) {
            Disposer.register((Disposable)environment, (Disposable)new Disposable(){

                public void dispose() {
                    REGISTRY.remove(environment);
                }
            });
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ExecutionEnvironment[] environments;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/runners/RerunTestsAction", "actionPerformed"));
        }
        for (ExecutionEnvironment environment : environments = REGISTRY.toArray(new ExecutionEnvironment[REGISTRY.size()])) {
            if (Disposer.isDisposed((Disposable)environment)) {
                REGISTRY.remove(environment);
                continue;
            }
            if (environment.getProject() != e.getProject()) continue;
            ExecutionUtil.restart((ExecutionEnvironment)environment);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/runners/RerunTestsAction", "update"));
        }
        e.getPresentation().setEnabled(true);
    }
}

