/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.NameGeneratingListenerDecorator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerComposite;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import java.util.List;

public class RunConfigurationRefactoringElementListenerProvider
implements RefactoringElementListenerProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.impl.RunConfigurationRefactoringElementListenerProvider");

    public RefactoringElementListener getListener(PsiElement element) {
        RefactoringElementListenerComposite composite = null;
        List configurations = RunManager.getInstance((Project)element.getProject()).getAllConfigurationsList();
        for (RunConfiguration configuration : configurations) {
            RefactoringElementListener listener;
            if (!(configuration instanceof RefactoringListenerProvider)) continue;
            try {
                listener = ((RefactoringListenerProvider)configuration).getRefactoringElementListener(element);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            if (listener == null) continue;
            if (configuration instanceof LocatableConfiguration) {
                listener = new NameGeneratingListenerDecorator((LocatableConfiguration)configuration, listener);
            }
            if (composite == null) {
                composite = new RefactoringElementListenerComposite();
            }
            composite.addListener(listener);
        }
        return composite;
    }
}

