/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.util.Condition;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class ProcessBackedConsoleExecuteActionHandler
extends BaseConsoleExecuteActionHandler
implements Condition<LanguageConsoleImpl> {
    private volatile ProcessHandler myProcessHandler;

    public ProcessBackedConsoleExecuteActionHandler(ProcessHandler processHandler, boolean preserveMarkup) {
        super(preserveMarkup);
        this.myProcessHandler = processHandler;
    }

    public void setProcessHandler(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/console/ProcessBackedConsoleExecuteActionHandler", "setProcessHandler"));
        }
        this.myProcessHandler = processHandler;
    }

    @Override
    @Deprecated
    protected void execute(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/console/ProcessBackedConsoleExecuteActionHandler", "execute"));
        }
        this.processLine(text);
    }

    public void processLine(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/execution/console/ProcessBackedConsoleExecuteActionHandler", "processLine"));
        }
        this.sendText(line + "\n");
    }

    public void sendText(String line) {
        Charset charset = this.myProcessHandler instanceof BaseOSProcessHandler ? ((BaseOSProcessHandler)this.myProcessHandler).getCharset() : null;
        OutputStream outputStream = this.myProcessHandler.getProcessInput();
        assert (outputStream != null) : "output stream is null";
        try {
            byte[] bytes = charset != null ? (line + "\n").getBytes(charset) : line.getBytes();
            outputStream.write(bytes);
            outputStream.flush();
        }
        catch (IOException ignored) {
            // empty catch block
        }
    }

    public final boolean isProcessTerminated() {
        ProcessHandler handler = this.myProcessHandler;
        return handler == null || handler.isProcessTerminated();
    }

    public boolean value(LanguageConsoleImpl console) {
        return !this.isProcessTerminated();
    }
}

