/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class LanguageConsoleViewImpl
extends ConsoleViewImpl
implements LanguageConsoleView {
    @NotNull
    protected final LanguageConsoleImpl myConsole;

    public LanguageConsoleViewImpl(Project project, String title, Language language) {
        this(new LanguageConsoleImpl(project, title, language));
    }

    public LanguageConsoleViewImpl(@NotNull LanguageConsoleImpl console) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/LanguageConsoleViewImpl", "<init>"));
        }
        this(console, true);
    }

    public LanguageConsoleViewImpl(@NotNull LanguageConsoleImpl console, boolean usePredefinedMessageFilter) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/LanguageConsoleViewImpl", "<init>"));
        }
        super(console.getProject(), GlobalSearchScope.allScope((Project)console.getProject()), true, usePredefinedMessageFilter);
        this.myConsole = console;
        Disposer.register((Disposable)this, (Disposable)this.myConsole);
    }

    @Override
    @NotNull
    public LanguageConsoleImpl getConsole() {
        LanguageConsoleImpl languageConsoleImpl = this.myConsole;
        if (languageConsoleImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleViewImpl", "getConsole"));
        }
        return languageConsoleImpl;
    }

    @Override
    protected EditorEx createRealEditor() {
        return this.myConsole.getHistoryViewer();
    }

    @Override
    protected void disposeEditor() {
    }

    @Override
    protected JComponent createCenterComponent() {
        return this.myConsole.getComponent();
    }

    @Override
    public JComponent getPreferredFocusableComponent() {
        return this.myConsole.getConsoleEditor().getContentComponent();
    }
}

