/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.SizedIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationsComboBoxAction
extends ComboBoxAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.actions.RunConfigurationAction");
    private static final Key<ComboBoxAction.ComboBoxButton> BUTTON_KEY = Key.create((String)"COMBOBOX_BUTTON");
    public static final Icon CHECKED_ICON = new SizedIcon(AllIcons.Actions.Checked, 16, 16);
    public static final Icon CHECKED_SELECTED_ICON = new SizedIcon(AllIcons.Actions.Checked_selected, 16, 16);
    public static final Icon EMPTY_ICON = EmptyIcon.ICON_16;

    public void actionPerformed(AnActionEvent e) {
        IdeFrame ideFrame = RunConfigurationsComboBoxAction.findFrame((Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT));
        ComboBoxAction.ComboBoxButton button = (ComboBoxAction.ComboBoxButton)ideFrame.getComponent().getRootPane().getClientProperty(BUTTON_KEY);
        if (button == null || !button.isShowing()) {
            return;
        }
        button.showPopup();
    }

    private static IdeFrame findFrame(Component component) {
        return (IdeFrame)UIUtil.getParentOfType(IdeFrame.class, (Component)component);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace())) {
            presentation.setDescription(ExecutionBundle.message((String)"choose.run.configuration.action.description", (Object[])new Object[0]));
            presentation.setEnabled(RunConfigurationsComboBoxAction.findFrame((Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT)) != null);
            return;
        }
        try {
            if (project == null || project.isDisposed() || !project.isInitialized()) {
                RunConfigurationsComboBoxAction.updateButton(null, null, null, presentation);
                presentation.setEnabled(false);
            } else if (DumbService.getInstance((Project)project).isDumb()) {
                presentation.setEnabled(false);
                presentation.setText("");
                presentation.setIcon(null);
            } else {
                RunConfigurationsComboBoxAction.updateButton(ExecutionTargetManager.getActiveTarget((Project)project), RunManagerEx.getInstanceEx(project).getSelectedConfiguration(), project, presentation);
                presentation.setEnabled(true);
            }
        }
        catch (IndexNotReadyException e1) {
            presentation.setEnabled(false);
        }
    }

    private static void updateButton(@Nullable ExecutionTarget target, @Nullable RunnerAndConfigurationSettings settings, @Nullable Project project, @NotNull Presentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/execution/actions/RunConfigurationsComboBoxAction", "updateButton"));
        }
        if (project != null && target != null && settings != null) {
            String name = settings.getName();
            if (target != DefaultExecutionTarget.INSTANCE) {
                name = name + " | " + target.getDisplayName();
            } else if (!settings.canRunOn(target)) {
                name = name + " | Nothing to run on";
            }
            presentation.setText(name, false);
            RunConfigurationsComboBoxAction.setConfigurationIcon(presentation, settings, project);
        } else {
            presentation.setText("");
            presentation.setIcon(null);
        }
    }

    private static void setConfigurationIcon(Presentation presentation, RunnerAndConfigurationSettings settings, Project project) {
        try {
            presentation.setIcon(RunManagerEx.getInstanceEx(project).getConfigurationIcon(settings));
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    public JComponent createCustomComponent(Presentation presentation) {
        ComboBoxAction.ComboBoxButton comboBoxButton = new ComboBoxAction.ComboBoxButton(presentation){

            public void addNotify() {
                super.addNotify();
                IdeFrame frame = RunConfigurationsComboBoxAction.findFrame((Component)((Object)this));
                LOG.assertTrue(frame != null);
                frame.getComponent().getRootPane().putClientProperty(BUTTON_KEY, (Object)this);
            }

            public void removeNotify() {
                IdeFrame frame = RunConfigurationsComboBoxAction.findFrame((Component)((Object)this));
                LOG.assertTrue(frame != null);
                frame.getComponent().getRootPane().putClientProperty(BUTTON_KEY, null);
                super.removeNotify();
            }
        };
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        panel.add((Component)comboBoxButton);
        panel.setOpaque(false);
        return panel;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup allActionsGroup = new DefaultActionGroup();
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)button));
        if (project != null) {
            ConfigurationType[] types;
            RunManagerEx runManager = RunManagerEx.getInstanceEx(project);
            allActionsGroup.add(ActionManager.getInstance().getAction("editRunConfigurations"));
            allActionsGroup.add((AnAction)new SaveTemporaryAction());
            allActionsGroup.addSeparator();
            RunnerAndConfigurationSettings selected = RunManager.getInstance((Project)project).getSelectedConfiguration();
            if (selected != null) {
                ExecutionTarget activeTarget = ExecutionTargetManager.getActiveTarget((Project)project);
                for (ExecutionTarget eachTarget : ExecutionTargetManager.getTargetsToChooseFor((Project)project, (RunnerAndConfigurationSettings)selected)) {
                    allActionsGroup.add((AnAction)new SelectTargetAction(project, eachTarget, eachTarget.equals((Object)activeTarget)));
                }
                allActionsGroup.addSeparator();
            }
            for (ConfigurationType type : types = runManager.getConfigurationFactories()) {
                DefaultActionGroup actionGroup = new DefaultActionGroup();
                Map<String, List<RunnerAndConfigurationSettings>> structure = runManager.getStructure(type);
                for (Map.Entry<String, List<RunnerAndConfigurationSettings>> entry : structure.entrySet()) {
                    DefaultActionGroup group = entry.getKey() != null ? new DefaultActionGroup(entry.getKey(), true) : actionGroup;
                    group.getTemplatePresentation().setIcon(AllIcons.Nodes.Folder);
                    for (RunnerAndConfigurationSettings settings : entry.getValue()) {
                        group.add((AnAction)new SelectConfigAction(settings, project));
                    }
                    if (group == actionGroup) continue;
                    actionGroup.add((AnAction)group);
                }
                allActionsGroup.add((AnAction)actionGroup);
                allActionsGroup.addSeparator();
            }
        }
        DefaultActionGroup defaultActionGroup = allActionsGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/RunConfigurationsComboBoxAction", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }

    private static class SelectConfigAction
    extends AnAction {
        private final RunnerAndConfigurationSettings myConfiguration;
        private final Project myProject;

        public SelectConfigAction(RunnerAndConfigurationSettings configuration, Project project) {
            this.myConfiguration = configuration;
            this.myProject = project;
            String name = configuration.getName();
            if (name == null || name.length() == 0) {
                name = " ";
            }
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(name, false);
            ConfigurationType type = configuration.getType();
            if (type != null) {
                presentation.setDescription("Select " + type.getConfigurationTypeDescription() + " '" + name + "'");
            }
            this.updateIcon(presentation);
        }

        private void updateIcon(Presentation presentation) {
            RunConfigurationsComboBoxAction.setConfigurationIcon(presentation, this.myConfiguration, this.myProject);
        }

        public void actionPerformed(AnActionEvent e) {
            RunManager.getInstance((Project)this.myProject).setSelectedConfiguration(this.myConfiguration);
            RunConfigurationsComboBoxAction.updateButton(ExecutionTargetManager.getActiveTarget((Project)this.myProject), this.myConfiguration, this.myProject, e.getPresentation());
        }

        public void update(AnActionEvent e) {
            super.update(e);
            this.updateIcon(e.getPresentation());
        }
    }

    private static class SelectTargetAction
    extends AnAction {
        private final Project myProject;
        private final ExecutionTarget myTarget;

        public SelectTargetAction(Project project, ExecutionTarget target, boolean selected) {
            this.myProject = project;
            this.myTarget = target;
            String name = target.getDisplayName();
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(name, false);
            presentation.setDescription("Select " + name);
            presentation.setIcon(selected ? CHECKED_ICON : EMPTY_ICON);
            presentation.setSelectedIcon(selected ? CHECKED_SELECTED_ICON : EMPTY_ICON);
        }

        public void actionPerformed(AnActionEvent e) {
            ExecutionTargetManager.setActiveTarget((Project)this.myProject, (ExecutionTarget)this.myTarget);
            RunConfigurationsComboBoxAction.updateButton(ExecutionTargetManager.getActiveTarget((Project)this.myProject), RunManagerEx.getInstanceEx(this.myProject).getSelectedConfiguration(), this.myProject, e.getPresentation());
        }
    }

    private static class SaveTemporaryAction
    extends AnAction {
        public SaveTemporaryAction() {
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(AllIcons.Actions.Menu_saveall);
        }

        public void actionPerformed(AnActionEvent e) {
            RunnerAndConfigurationSettings settings;
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project != null && (settings = SaveTemporaryAction.chooseTempSettings(project)) != null) {
                RunManager runManager = RunManager.getInstance((Project)project);
                runManager.makeStable(settings);
            }
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project == null) {
                SaveTemporaryAction.disable(presentation);
                return;
            }
            RunnerAndConfigurationSettings settings = SaveTemporaryAction.chooseTempSettings(project);
            if (settings == null) {
                SaveTemporaryAction.disable(presentation);
            } else {
                presentation.setText(ExecutionBundle.message((String)"save.temporary.run.configuration.action.name", (Object[])new Object[]{settings.getName()}));
                presentation.setDescription(presentation.getText());
                presentation.setVisible(true);
                presentation.setEnabled(true);
            }
        }

        private static void disable(Presentation presentation) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
        }

        @Nullable
        private static RunnerAndConfigurationSettings chooseTempSettings(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/RunConfigurationsComboBoxAction$SaveTemporaryAction", "chooseTempSettings"));
            }
            RunnerAndConfigurationSettings selectedConfiguration = RunManager.getInstance((Project)project).getSelectedConfiguration();
            if (selectedConfiguration != null && selectedConfiguration.isTemporary()) {
                return selectedConfiguration;
            }
            Iterator iterator = RunManager.getInstance((Project)project).getTempConfigurationsList().iterator();
            return iterator.hasNext() ? (RunnerAndConfigurationSettings)iterator.next() : null;
        }
    }
}

