/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class TerminateRemoteProcessDialog {
    public static int show(Project project, String sessionName, TerminateOption option) {
        String message = option.myAlwaysUseDefault && !option.myDetach ? ExecutionBundle.message((String)"terminate.process.confirmation.text", (Object[])new Object[]{sessionName}) : ExecutionBundle.message((String)"disconnect.process.confirmation.text", (Object[])new Object[]{sessionName});
        String okButtonText = option.myAlwaysUseDefault && !option.myDetach ? ExecutionBundle.message((String)"button.terminate", (Object[])new Object[0]) : ExecutionBundle.message((String)"button.disconnect", (Object[])new Object[0]);
        String[] options = new String[]{okButtonText, CommonBundle.getCancelButtonText()};
        return Messages.showDialog((Project)project, (String)message, (String)ExecutionBundle.message((String)"process.is.running.dialog.title", (Object[])new Object[]{sessionName}), (String[])options, (int)0, (Icon)Messages.getWarningIcon(), (DialogWrapper.DoNotAskOption)option);
    }

    public static class TerminateOption
    implements DialogWrapper.DoNotAskOption {
        private boolean myDetach;
        private final boolean myAlwaysUseDefault;

        public TerminateOption(boolean detachIsDefault, boolean alwaysUseDefault) {
            this.myDetach = detachIsDefault;
            this.myAlwaysUseDefault = alwaysUseDefault;
        }

        public boolean isToBeShown() {
            return this.myDetach;
        }

        public void setToBeShown(boolean value, int exitCode) {
            this.myDetach = value;
        }

        public boolean canBeHidden() {
            return !this.myAlwaysUseDefault;
        }

        public boolean shouldSaveOptionsOnCancel() {
            return false;
        }

        @NotNull
        public String getDoNotShowMessage() {
            String string = ExecutionBundle.message((String)"terminate.after.disconnect.checkbox", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/TerminateRemoteProcessDialog$TerminateOption", "getDoNotShowMessage"));
            }
            return string;
        }
    }
}

