/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.embedding;

import com.intellij.embedding.MasqueradingLexer;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndentEatingLexer
extends MasqueradingLexer {
    public IndentEatingLexer(@NotNull Lexer delegate, int baseIndent) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/embedding/IndentEatingLexer", "<init>"));
        }
        super((Lexer)new MyLexer(delegate, baseIndent));
    }

    @Override
    @Nullable
    public IElementType getMasqueTokenType() {
        if (this.isForeignToken()) {
            return null;
        }
        return this.getTokenType();
    }

    @Override
    @Nullable
    public String getMasqueTokenText() {
        if (this.getMasqueTokenType() == null) {
            return null;
        }
        return this.getTokenText();
    }

    public boolean isForeignToken() {
        return this.myDelegate.getTokenType() == TokenType.DUMMY_HOLDER;
    }

    @Nullable
    public IElementType getTokenType() {
        IElementType type = this.myDelegate.getTokenType();
        if (type == TokenType.DUMMY_HOLDER) {
            return TokenType.WHITE_SPACE;
        }
        return type;
    }

    private static class MyLexer
    extends LayeredLexer {
        public MyLexer(Lexer baseLexer, int indent) {
            super(baseLexer);
            this.registerLayer((Lexer)new MyWhiteSpaceLexer(indent), new IElementType[]{TokenType.WHITE_SPACE});
        }

        private class MyWhiteSpaceLexer
        extends LexerBase {
            int myIndent;
            CharSequence myBuffer;
            int myState;
            int myStart;
            int myEnd;
            int[] myPositions = new int[0];

            public MyWhiteSpaceLexer(int indent) {
                this.myIndent = indent;
            }

            public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
                if (buffer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/embedding/IndentEatingLexer$MyLexer$MyWhiteSpaceLexer", "start"));
                }
                this.myBuffer = buffer;
                this.myState = initialState;
                this.myStart = startOffset;
                this.myEnd = endOffset;
                this.initPositions();
            }

            private void initPositions() {
                String s = ((Object)this.myBuffer.subSequence(this.myStart, this.myEnd)).toString();
                int i = s.lastIndexOf(10) + 1;
                this.myPositions = i == 0 || i == s.length() ? new int[]{this.myStart, this.myEnd} : (s.length() - i > this.myIndent ? new int[]{this.myStart, this.myStart + i, this.myStart + i + this.myIndent, this.myEnd} : new int[]{this.myStart, this.myStart + i, this.myEnd});
            }

            public int getState() {
                return this.myState;
            }

            @Nullable
            public IElementType getTokenType() {
                if (this.myState + 1 >= this.myPositions.length) {
                    return null;
                }
                if (this.myState == 1) {
                    return TokenType.DUMMY_HOLDER;
                }
                return TokenType.WHITE_SPACE;
            }

            public int getTokenStart() {
                return this.myPositions[this.myState];
            }

            public int getTokenEnd() {
                if (this.myState + 1 >= this.myPositions.length) {
                    return this.myEnd;
                }
                return this.myPositions[this.myState + 1];
            }

            public void advance() {
                ++this.myState;
            }

            @NotNull
            public CharSequence getBufferSequence() {
                CharSequence charSequence = this.myBuffer;
                if (charSequence == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/embedding/IndentEatingLexer$MyLexer$MyWhiteSpaceLexer", "getBufferSequence"));
                }
                return charSequence;
            }

            public int getBufferEnd() {
                return this.myEnd;
            }
        }
    }
}

