/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import java.util.List;

public class GroupedLogMessage
extends AbstractMessage {
    private final List<AbstractMessage> myMessages;

    public GroupedLogMessage(List<AbstractMessage> messages) {
        this.myMessages = messages;
    }

    public List<AbstractMessage> getMessages() {
        return this.myMessages;
    }

    @Override
    public String getThrowableText() {
        StringBuilder result = new StringBuilder();
        for (AbstractMessage each : this.myMessages) {
            result.append(each.getThrowableText()).append("\n\n\n");
        }
        return result.toString();
    }

    @Override
    public void setRead(boolean aReadFlag) {
        for (AbstractMessage message : this.myMessages) {
            message.setRead(aReadFlag);
        }
        super.setRead(aReadFlag);
    }

    @Override
    public Throwable getThrowable() {
        return this.myMessages.get(0).getThrowable();
    }

    @Override
    public String getMessage() {
        return this.myMessages.get(0).getMessage();
    }

    @Override
    public void setAssigneeId(Integer assigneeId) {
        for (AbstractMessage message : this.myMessages) {
            message.setAssigneeId(assigneeId);
        }
        super.setAssigneeId(assigneeId);
    }
}

