/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.ErrorNotifier;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.OutOfMemoryDialog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.ErrorLogger;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.io.MappingFailedException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;

public class DefaultIdeaErrorLogger
implements ErrorLogger {
    private static boolean ourOomOccurred = false;
    private static boolean ourLoggerBroken = false;
    private static boolean ourMappingFailedNotificationPosted = false;
    @NonNls
    private static final String FATAL_ERROR_NOTIFICATION_PROPERTY = "idea.fatal.error.notification";
    @NonNls
    private static final String DISABLED_VALUE = "disabled";
    @NonNls
    private static final String ENABLED_VALUE = "enabled";
    @NonNls
    private static final String PARAM_PERM_GEN = "PermGen";

    public boolean canHandle(IdeaLoggingEvent event) {
        if (ourLoggerBroken) {
            return false;
        }
        try {
            UpdateChecker.checkForUpdate(event);
            boolean notificationEnabled = !DISABLED_VALUE.equals(System.getProperty(FATAL_ERROR_NOTIFICATION_PROPERTY, ENABLED_VALUE));
            ErrorReportSubmitter submitter = IdeErrorsDialog.getSubmitter(event.getThrowable());
            boolean showPluginError = !(submitter instanceof ITNReporter) || ((ITNReporter)submitter).showErrorInRelease(event);
            return notificationEnabled || showPluginError || ApplicationManagerEx.getApplicationEx().isInternal() || DefaultIdeaErrorLogger.isOOMError(event.getThrowable()) || event.getThrowable() instanceof MappingFailedException;
        }
        catch (LinkageError e) {
            if (e.getMessage().contains("Could not initialize class com.intellij.diagnostic.IdeErrorsDialog")) {
                ourLoggerBroken = true;
            }
            throw e;
        }
    }

    public void handle(IdeaLoggingEvent event) {
        block8: {
            if (ourLoggerBroken) {
                return;
            }
            try {
                MessagePool messagePool;
                LogMessage message;
                Throwable throwable = event.getThrowable();
                if (DefaultIdeaErrorLogger.isOOMError(throwable)) {
                    DefaultIdeaErrorLogger.processOOMError(throwable);
                } else if (throwable instanceof MappingFailedException) {
                    DefaultIdeaErrorLogger.processMappingFailed(event);
                } else if (!ourOomOccurred && (message = (messagePool = MessagePool.getInstance()).addIdeFatalMessage(event)) != null && ApplicationManager.getApplication() != null) {
                    ErrorNotifier.notifyUi(message, messagePool);
                }
            }
            catch (Throwable e) {
                String message = e.getMessage();
                if ((message == null || !message.contains("Could not initialize class com.intellij.diagnostic.MessagePool")) && (!(e instanceof NullPointerException) || ApplicationManager.getApplication() != null)) break block8;
                ourLoggerBroken = true;
            }
        }
    }

    private static boolean isOOMError(Throwable throwable) {
        return throwable instanceof OutOfMemoryError || throwable instanceof VirtualMachineError && throwable.getMessage() != null && throwable.getMessage().contains("CodeCache");
    }

    private static void processOOMError(final Throwable throwable) throws InterruptedException, InvocationTargetException {
        ourOomOccurred = true;
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                String message = throwable.getMessage();
                OutOfMemoryDialog.MemoryKind k = message != null && message.contains(DefaultIdeaErrorLogger.PARAM_PERM_GEN) ? OutOfMemoryDialog.MemoryKind.PERM_GEN : (message != null && message.contains("CodeCache") ? OutOfMemoryDialog.MemoryKind.CODE_CACHE : OutOfMemoryDialog.MemoryKind.HEAP);
                new OutOfMemoryDialog(k).show();
            }
        });
    }

    private static void processMappingFailed(IdeaLoggingEvent event) throws InterruptedException, InvocationTargetException {
        if (!ourMappingFailedNotificationPosted && SystemInfo.isWindows && SystemInfo.is32Bit) {
            ourMappingFailedNotificationPosted = true;
            String exceptionMessage = event.getThrowable().getMessage();
            String text = exceptionMessage + "<br>Possible cause: unable to allocate continuous memory chunk of necessary size.<br>" + "Reducing JVM maximum heap size (-Xmx) may help.";
            Notifications.Bus.notify((Notification)new Notification("Memory", "Memory Mapping Failed", text, NotificationType.WARNING), null);
        }
    }
}

