/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;

public class AttachmentFactory {
    private static final String ERROR_MESSAGE_PATTERN = "[[[Can't get file contents: {0}]]]";

    public static Attachment createAttachment(Document document) {
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        return new Attachment(file != null ? file.getPath() : "unknown.txt", document.getText());
    }

    public static Attachment createAttachment(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diagnostic/AttachmentFactory", "createAttachment"));
        }
        return new Attachment(file.getPresentableUrl(), AttachmentFactory.getBytes(file), file.getFileType().isBinary() ? "File is binary" : ((Object)LoadTextUtil.loadText(file)).toString());
    }

    public static Attachment createAttachment(@NotNull File file, boolean isBinary) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diagnostic/AttachmentFactory", "createAttachment"));
        }
        byte[] bytes = AttachmentFactory.getBytes(file);
        return new Attachment(file.getPath(), bytes, isBinary ? "File is binary" : new String(bytes));
    }

    private static byte[] getBytes(File file) {
        try {
            return FileUtil.loadFileBytes((File)file);
        }
        catch (IOException e) {
            return Attachment.getBytes((String)MessageFormat.format(ERROR_MESSAGE_PATTERN, e.getMessage()));
        }
    }

    private static byte[] getBytes(VirtualFile file) {
        try {
            return file.contentsToByteArray();
        }
        catch (IOException e) {
            return Attachment.getBytes((String)MessageFormat.format(ERROR_MESSAGE_PATTERN, e.getMessage()));
        }
    }
}

