/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import javax.swing.JComponent;

public class LightFillLayout
implements LayoutManager2 {
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return LightFillLayout.layoutSize(parent, new Function<Component, Dimension>(){

            public Dimension fun(Component component) {
                return component.getPreferredSize();
            }
        });
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return LightFillLayout.layoutSize(parent, new Function<Component, Dimension>(){

            public Dimension fun(Component component) {
                return component.getMinimumSize();
            }
        });
    }

    private static Dimension layoutSize(Container parent, Function<Component, Dimension> getSize) {
        Component toolbar = parent.getComponent(0);
        Dimension toolbarSize = toolbar.isVisible() ? (Dimension)getSize.fun((Object)toolbar) : new Dimension();
        Dimension contentSize = (Dimension)getSize.fun((Object)parent.getComponent(1));
        int extraWidth = 0;
        JComponent jParent = (JComponent)parent;
        if (jParent.getClientProperty("left") != null) {
            extraWidth += 25;
        }
        if (jParent.getClientProperty("right") != null) {
            extraWidth += 25;
        }
        return new Dimension(Math.max(toolbarSize.width, contentSize.width + extraWidth), toolbarSize.height + contentSize.height);
    }

    @Override
    public void layoutContainer(Container parent) {
        JComponent right;
        int leftWidth = 0;
        int rightWidth = 0;
        JComponent jParent = (JComponent)parent;
        JComponent left = (JComponent)jParent.getClientProperty("left");
        if (left != null) {
            leftWidth = 25;
        }
        if ((right = (JComponent)jParent.getClientProperty("right")) != null) {
            rightWidth = 25;
        }
        int extraWidth = leftWidth + rightWidth;
        int width = parent.getWidth() - extraWidth;
        int height = parent.getHeight();
        Component toolbar = parent.getComponent(0);
        Dimension toolbarSize = toolbar.isVisible() ? toolbar.getPreferredSize() : new Dimension();
        toolbar.setBounds(leftWidth, 0, width, toolbarSize.height);
        parent.getComponent(1).setBounds(leftWidth, toolbarSize.height, width, height - toolbarSize.height);
        if (left != null) {
            left.setBounds(0, 0, leftWidth, height);
        }
        if (right != null) {
            right.setBounds(width + leftWidth, 0, rightWidth, height);
        }
    }
}

