/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CoreProgressManager
extends ProgressManager {
    private static final ThreadLocal<ProgressIndicator> myIndicator = new ThreadLocal();

    CoreProgressManager() {
    }

    public boolean hasProgressIndicator() {
        return this.getProgressIndicator() != null;
    }

    public boolean hasModalProgressIndicator() {
        return false;
    }

    public boolean hasUnsafeProgressIndicator() {
        return false;
    }

    public void runProcess(final @NotNull Runnable process, final ProgressIndicator progress) throws ProcessCanceledException {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/core/CoreProgressManager", "runProcess"));
        }
        this.executeProcessUnderProgress(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (progress != null && !progress.isRunning()) {
                        progress.start();
                    }
                    process.run();
                }
                finally {
                    if (progress != null && progress.isRunning()) {
                        progress.stop();
                    }
                }
            }
        }, progress);
    }

    public <T> T runProcess(final @NotNull Computable<T> process, ProgressIndicator progress) throws ProcessCanceledException {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/core/CoreProgressManager", "runProcess"));
        }
        final AtomicReference result = new AtomicReference();
        this.executeProcessUnderProgress(new Runnable(){

            @Override
            public void run() {
                result.set(process.compute());
            }
        }, progress);
        return (T)result.get();
    }

    public void executeNonCancelableSection(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/core/CoreProgressManager", "executeNonCancelableSection"));
        }
        this.executeProcessUnderProgress(runnable, (ProgressIndicator)new EmptyProgressIndicator());
    }

    public void setCancelButtonText(String cancelButtonText) {
    }

    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process, @NotNull @Nls String progressTitle, boolean canBeCanceled, @Nullable Project project) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/core/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/core/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        this.executeProcessUnderProgress(process, (ProgressIndicator)new EmptyProgressIndicator());
        return true;
    }

    public <T, E extends Exception> T runProcessWithProgressSynchronously(final @NotNull ThrowableComputable<T, E> process, @NotNull @Nls String progressTitle, boolean canBeCanceled, @Nullable Project project) throws E {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/core/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/core/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        final AtomicReference result = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        this.executeProcessUnderProgress(new Runnable(){

            @Override
            public void run() {
                try {
                    result.set(process.compute());
                }
                catch (Exception e) {
                    exception.set(e);
                }
            }
        }, (ProgressIndicator)new EmptyProgressIndicator());
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
        return (T)result.get();
    }

    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process, @NotNull @Nls String progressTitle, boolean canBeCanceled, @Nullable Project project, @Nullable JComponent parentComponent) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/core/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/core/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        return this.runProcessWithProgressSynchronously(process, progressTitle, canBeCanceled, project);
    }

    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull @Nls String progressTitle, @NotNull Runnable process, @Nullable Runnable successRunnable, @Nullable Runnable canceledRunnable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/core/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/core/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/core/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        this.runProcess(process, (ProgressIndicator)new EmptyProgressIndicator());
    }

    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull @Nls String progressTitle, @NotNull Runnable process, @Nullable Runnable successRunnable, @Nullable Runnable canceledRunnable, @NotNull PerformInBackgroundOption option) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/core/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/core/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/core/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/core/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        this.runProcess(process, (ProgressIndicator)new EmptyProgressIndicator());
    }

    public void run(final @NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/core/CoreProgressManager", "run"));
        }
        this.runProcess(new Runnable(){

            @Override
            public void run() {
                task.run(CoreProgressManager.this.getProgressIndicator());
            }
        }, (ProgressIndicator)new EmptyProgressIndicator());
    }

    public void runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/core/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/core/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        this.run((Task)task);
    }

    public ProgressIndicator getProgressIndicator() {
        return myIndicator.get();
    }

    protected void doCheckCanceled() throws ProcessCanceledException {
        ProgressIndicator indicator = this.getProgressIndicator();
        if (indicator != null) {
            indicator.checkCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeProcessUnderProgress(@NotNull Runnable process, @Nullable(value="null means reuse current progress") ProgressIndicator progress) throws ProcessCanceledException {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/core/CoreProgressManager", "executeProcessUnderProgress"));
        }
        ProgressIndicator old = null;
        if (progress != null) {
            old = this.getProgressIndicator();
            myIndicator.set(progress);
        }
        try {
            process.run();
        }
        finally {
            if (progress != null) {
                myIndicator.set(old);
            }
        }
    }

    @NotNull
    public NonCancelableSection startNonCancelableSection() {
        NonCancelableSection nonCancelableSection = NonCancelableSection.EMPTY;
        if (nonCancelableSection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProgressManager", "startNonCancelableSection"));
        }
        return nonCancelableSection;
    }
}

