/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.icons.AllIcons;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.IconUtil;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class InspectionNode
extends InspectionTreeNode {
    public static final Icon TOOL = LayeredIcon.create((Icon)AllIcons.Toolwindows.ToolWindowInspection, (Icon)IconUtil.getEmptyIcon((boolean)false));
    private boolean myTooBigForOnlineRefresh;

    public InspectionNode(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ui/InspectionNode", "<init>"));
        }
        super(toolWrapper);
        this.myTooBigForOnlineRefresh = false;
    }

    @Override
    public String toString() {
        return this.getToolWrapper().getDisplayName();
    }

    @NotNull
    public InspectionToolWrapper getToolWrapper() {
        InspectionToolWrapper inspectionToolWrapper = (InspectionToolWrapper)this.getUserObject();
        if (inspectionToolWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionNode", "getToolWrapper"));
        }
        return inspectionToolWrapper;
    }

    @Override
    public Icon getIcon(boolean expanded) {
        return TOOL;
    }

    public boolean isTooBigForOnlineRefresh() {
        if (!this.myTooBigForOnlineRefresh) {
            this.myTooBigForOnlineRefresh = this.getProblemCount() > 1000;
        }
        return this.myTooBigForOnlineRefresh;
    }

    @Override
    public int getProblemCount() {
        int sum = 0;
        Enumeration<TreeNode> children = this.children();
        while (children.hasMoreElements()) {
            InspectionTreeNode child = (InspectionTreeNode)children.nextElement();
            if (child instanceof InspectionNode) continue;
            sum += child.getProblemCount();
        }
        return sum;
    }
}

