/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

@Tag(value="profile-state")
public class VisibleTreeState {
    @Tag(value="expanded-state")
    @AbstractCollection(surroundWithTag=false, elementTag="expanded", elementValueAttribute="path", elementTypes={State.class})
    public TreeSet<State> myExpandedNodes = new TreeSet();
    @Tag(value="selected-state")
    @AbstractCollection(surroundWithTag=false, elementTag="selected", elementValueAttribute="path", elementTypes={State.class})
    public TreeSet<State> mySelectedNodes = new TreeSet();

    public VisibleTreeState(VisibleTreeState src) {
        this.myExpandedNodes.addAll(src.myExpandedNodes);
        this.mySelectedNodes.addAll(src.mySelectedNodes);
    }

    public VisibleTreeState() {
    }

    public void expandNode(InspectionConfigTreeNode node) {
        this.myExpandedNodes.add(VisibleTreeState.getState(node));
    }

    public void collapseNode(InspectionConfigTreeNode node) {
        this.myExpandedNodes.remove(VisibleTreeState.getState(node));
    }

    public void restoreVisibleState(Tree tree) {
        ArrayList<TreePath> pathsToExpand = new ArrayList<TreePath>();
        ArrayList<TreePath> toSelect = new ArrayList<TreePath>();
        this.traverseNodes((DefaultMutableTreeNode)tree.getModel().getRoot(), pathsToExpand, toSelect);
        TreeUtil.restoreExpandedPaths((JTree)tree, pathsToExpand);
        if (toSelect.isEmpty()) {
            TreeUtil.selectFirstNode((JTree)tree);
        } else {
            for (TreePath aToSelect : toSelect) {
                TreeUtil.selectPath((JTree)tree, (TreePath)aToSelect);
            }
        }
    }

    private void traverseNodes(DefaultMutableTreeNode root, List<TreePath> pathsToExpand, List<TreePath> toSelect) {
        State state2 = VisibleTreeState.getState((InspectionConfigTreeNode)root);
        Object[] rootPath = root.getPath();
        if (this.mySelectedNodes.contains(state2)) {
            toSelect.add(new TreePath(rootPath));
        }
        if (this.myExpandedNodes.contains(state2)) {
            pathsToExpand.add(new TreePath(rootPath));
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.traverseNodes((DefaultMutableTreeNode)root.getChildAt(i), pathsToExpand, toSelect);
        }
    }

    public void saveVisibleState(Tree tree) {
        this.myExpandedNodes.clear();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)tree.getModel().getRoot();
        Enumeration expanded = tree.getExpandedDescendants(new TreePath(rootNode.getPath()));
        if (expanded != null) {
            while (expanded.hasMoreElements()) {
                TreePath treePath = (TreePath)expanded.nextElement();
                InspectionConfigTreeNode node = (InspectionConfigTreeNode)treePath.getLastPathComponent();
                this.myExpandedNodes.add(VisibleTreeState.getState(node));
            }
        }
        this.setSelectionPaths(tree.getSelectionPaths());
    }

    private static State getState(InspectionConfigTreeNode node) {
        State expandedNode;
        Descriptor descriptor = node.getDefaultDescriptor();
        if (descriptor != null) {
            expandedNode = new State(descriptor);
        } else {
            StringBuilder buf = new StringBuilder();
            while (node.getParent() != null) {
                buf.append(node.getGroupName());
                node = (InspectionConfigTreeNode)node.getParent();
            }
            expandedNode = new State(buf.toString());
        }
        return expandedNode;
    }

    public void setSelectionPaths(TreePath[] selectionPaths) {
        this.mySelectedNodes.clear();
        if (selectionPaths != null) {
            for (TreePath selectionPath : selectionPaths) {
                InspectionConfigTreeNode node = (InspectionConfigTreeNode)selectionPath.getLastPathComponent();
                this.mySelectedNodes.add(VisibleTreeState.getState(node));
            }
        }
    }

    public static class State
    implements Comparable {
        @Tag(value="id")
        public String myKey;
        Descriptor myDescriptor;

        public State(String key) {
            this.myKey = key;
        }

        public State(Descriptor descriptor) {
            this.myKey = descriptor.toString();
            this.myDescriptor = descriptor;
        }

        public State() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state2 = (State)o;
            return !(this.myKey != null ? !this.myKey.equals(state2.myKey) : state2.myKey != null);
        }

        public int hashCode() {
            int result = this.myKey != null ? this.myKey.hashCode() : 0;
            result = 31 * result + (this.myDescriptor != null ? this.myDescriptor.hashCode() : 0);
            return result;
        }

        public int compareTo(Object o) {
            if (!(o instanceof State)) {
                return -1;
            }
            State other = (State)o;
            if (this.myKey.equals(other.myKey) && this.myDescriptor != null && other.myDescriptor != null) {
                String scope1 = this.myDescriptor.getScopeName();
                String scope2 = other.myDescriptor.getScopeName();
                return scope1.compareTo(scope2);
            }
            return this.myKey.compareTo(other.myKey);
        }
    }
}

