/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.profile.ProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import org.jetbrains.annotations.NotNull;

public class GlobalInspectionContextUtil {
    public static RefElement retrieveRefElement(@NotNull PsiElement element, @NotNull GlobalInspectionContext globalContext) {
        PsiLanguageInjectionHost context;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/GlobalInspectionContextUtil", "retrieveRefElement"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/ex/GlobalInspectionContextUtil", "retrieveRefElement"));
        }
        PsiFile elementFile = element.getContainingFile();
        RefElement refElement = globalContext.getRefManager().getReference((PsiElement)elementFile);
        if (refElement == null && (context = InjectedLanguageManager.getInstance((Project)elementFile.getProject()).getInjectionHost((PsiElement)elementFile)) != null) {
            refElement = globalContext.getRefManager().getReference((PsiElement)context.getContainingFile());
        }
        return refElement;
    }

    public static boolean isToCheckMember(@NotNull RefElement owner, @NotNull InspectionProfileEntry tool, Tools tools, ProfileManager profileManager) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/ex/GlobalInspectionContextUtil", "isToCheckMember"));
        }
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInspection/ex/GlobalInspectionContextUtil", "isToCheckMember"));
        }
        return GlobalInspectionContextUtil.isToCheckFile(((RefElementImpl)owner).getContainingFile(), tool, tools, profileManager) && !((RefElementImpl)owner).isSuppressed(tool.getShortName());
    }

    public static boolean isToCheckFile(PsiFile file, @NotNull InspectionProfileEntry tool, Tools tools, ProfileManager profileManager) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInspection/ex/GlobalInspectionContextUtil", "isToCheckFile"));
        }
        if (tools != null && file != null) {
            for (ScopeToolState state2 : tools.getTools()) {
                InspectionToolWrapper toolWrapper;
                NamedScope namedScope = state2.getScope(file.getProject());
                if (namedScope != null && !namedScope.getValue().contains(file, profileManager.getScopesManager())) continue;
                return state2.isEnabled() && (toolWrapper = state2.getTool()).getTool() == tool;
            }
        }
        return false;
    }

    public static boolean canRunInspections(@NotNull Project project, boolean online) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/GlobalInspectionContextUtil", "canRunInspections"));
        }
        for (InspectionExtensionsFactory factory : (InspectionExtensionsFactory[])Extensions.getExtensions((ExtensionPointName)InspectionExtensionsFactory.EP_NAME)) {
            if (factory.isProjectConfiguredToRunInspections(project, online)) continue;
            return false;
        }
        return true;
    }
}

