/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ProblemDescriptorUtil {
    public static final int NONE = 0;
    public static final int APPEND_LINE_NUMBER = 1;
    public static final int TRIM_AT_END = 2;
    public static final int TRIM_AT_TREE_END = 4;
    public static Couple<String> XML_CODE_MARKER = Couple.of((Object)"<xml-code>", (Object)"</xml-code>");

    public static String extractHighlightedText(@NotNull CommonProblemDescriptor descriptor, PsiElement psiElement) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ProblemDescriptorUtil", "extractHighlightedText"));
        }
        if (psiElement == null || !psiElement.isValid()) {
            return "";
        }
        String ref = psiElement.getText();
        if (descriptor instanceof ProblemDescriptorBase) {
            TextRange textRange = ((ProblemDescriptorBase)descriptor).getTextRange();
            TextRange elementRange = psiElement.getTextRange();
            if (textRange != null && elementRange != null && (textRange = textRange.shiftRight(-elementRange.getStartOffset())).getStartOffset() >= 0 && textRange.getEndOffset() <= elementRange.getLength()) {
                ref = textRange.substring(ref);
            }
        }
        ref = StringUtil.replaceChar((String)ref, (char)'\n', (char)' ').trim();
        ref = StringUtil.first((String)ref, (int)100, (boolean)true);
        return ref;
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor, PsiElement element, boolean appendLineNumber) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ProblemDescriptorUtil", "renderDescriptionMessage"));
        }
        String string = ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element, appendLineNumber ? 1 : 0);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemDescriptorUtil", "renderDescriptionMessage"));
        }
        return string;
    }

    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor, PsiElement element, @FlagConstant int flags) {
        int endIndex;
        int lineNumber;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ProblemDescriptorUtil", "renderDescriptionMessage"));
        }
        String message = descriptor.getDescriptionTemplate();
        if (message == null) {
            return "";
        }
        if ((flags & 1) != 0 && descriptor instanceof ProblemDescriptor && !message.contains("#ref") && message.contains("#loc") && (lineNumber = ((ProblemDescriptor)descriptor).getLineNumber()) >= 0) {
            message = StringUtil.replace((String)message, (String)"#loc", (String)("(" + InspectionsBundle.message((String)"inspection.export.results.at.line", (Object[])new Object[0]) + " " + lineNumber + ")"));
        }
        message = StringUtil.replace((String)message, (String)"<code>", (String)"'");
        message = StringUtil.replace((String)message, (String)"</code>", (String)"'");
        message = StringUtil.replace((String)message, (String)"#loc ", (String)"");
        message = StringUtil.replace((String)message, (String)" #loc", (String)"");
        if ((message = StringUtil.replace((String)message, (String)"#loc", (String)"")).contains("#ref")) {
            String ref = ProblemDescriptorUtil.extractHighlightedText(descriptor, element);
            message = StringUtil.replace((String)message, (String)"#ref", (String)ref);
        }
        int n = (flags & 2) != 0 ? message.indexOf("#end") : (endIndex = (flags & 4) != 0 ? message.indexOf("#treeend") : -1);
        if (endIndex > 0) {
            message = message.substring(0, endIndex);
        }
        message = StringUtil.replace((String)message, (String)"#end", (String)"");
        message = (message = StringUtil.replace((String)message, (String)"#treeend", (String)"")).contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.first) ? ProblemDescriptorUtil.unescapeXmlCode(message) : StringUtil.unescapeXml((String)message).trim();
        return message;
    }

    private static String unescapeXmlCode(String message) {
        ArrayList<String> strings = new ArrayList<String>();
        for (String string : StringUtil.split((String)message, (String)((String)ProblemDescriptorUtil.XML_CODE_MARKER.first))) {
            if (string.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                strings.addAll(StringUtil.split((String)string, (String)((String)ProblemDescriptorUtil.XML_CODE_MARKER.second), (boolean)false));
                continue;
            }
            strings.add(string);
        }
        StringBuilder builder = new StringBuilder();
        for (String string : strings) {
            if (string.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                builder.append(string.replace((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second, ""));
                continue;
            }
            builder.append(StringUtil.unescapeXml((String)string));
        }
        return builder.toString();
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor, PsiElement element) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ProblemDescriptorUtil", "renderDescriptionMessage"));
        }
        String string = ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemDescriptorUtil", "renderDescriptionMessage"));
        }
        return string;
    }

    @NotNull
    public static HighlightInfoType highlightTypeFromDescriptor(@NotNull ProblemDescriptor problemDescriptor, @NotNull HighlightSeverity severity, @NotNull SeverityRegistrar severityRegistrar) {
        if (problemDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptor", "com/intellij/codeInspection/ProblemDescriptorUtil", "highlightTypeFromDescriptor"));
        }
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeInspection/ProblemDescriptorUtil", "highlightTypeFromDescriptor"));
        }
        if (severityRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severityRegistrar", "com/intellij/codeInspection/ProblemDescriptorUtil", "highlightTypeFromDescriptor"));
        }
        ProblemHighlightType highlightType = problemDescriptor.getHighlightType();
        switch (highlightType) {
            case GENERIC_ERROR_OR_WARNING: {
                HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = severityRegistrar.getHighlightInfoTypeBySeverity(severity);
                if (highlightInfoTypeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemDescriptorUtil", "highlightTypeFromDescriptor"));
                }
                return highlightInfoTypeImpl;
            }
            case LIKE_DEPRECATED: {
                HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.DEPRECATED.getAttributesKey());
                if (highlightInfoTypeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemDescriptorUtil", "highlightTypeFromDescriptor"));
                }
                return highlightInfoTypeImpl;
            }
            case LIKE_UNKNOWN_SYMBOL: {
                if (severity == HighlightSeverity.ERROR) {
                    HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.WRONG_REF.getAttributesKey());
                    if (highlightInfoTypeImpl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemDescriptorUtil", "highlightTypeFromDescriptor"));
                    }
                    return highlightInfoTypeImpl;
                }
                if (severity == HighlightSeverity.WARNING) {
                    HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = new HighlightInfoType.HighlightInfoTypeImpl(severity, CodeInsightColors.WEAK_WARNING_ATTRIBUTES);
                    if (highlightInfoTypeImpl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemDescriptorUtil", "highlightTypeFromDescriptor"));
                    }
                    return highlightInfoTypeImpl;
                }
                HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = severityRegistrar.getHighlightInfoTypeBySeverity(severity);
                if (highlightInfoTypeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemDescriptorUtil", "highlightTypeFromDescriptor"));
                }
                return highlightInfoTypeImpl;
            }
            case LIKE_UNUSED_SYMBOL: {
                HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.UNUSED_SYMBOL.getAttributesKey());
                if (highlightInfoTypeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemDescriptorUtil", "highlightTypeFromDescriptor"));
                }
                return highlightInfoTypeImpl;
            }
            case INFO: {
                HighlightInfoType highlightInfoType = HighlightInfoType.INFO;
                if (highlightInfoType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemDescriptorUtil", "highlightTypeFromDescriptor"));
                }
                return highlightInfoType;
            }
            case WEAK_WARNING: {
                HighlightInfoType highlightInfoType = HighlightInfoType.WEAK_WARNING;
                if (highlightInfoType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemDescriptorUtil", "highlightTypeFromDescriptor"));
                }
                return highlightInfoType;
            }
            case ERROR: {
                HighlightInfoType highlightInfoType = HighlightInfoType.WRONG_REF;
                if (highlightInfoType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemDescriptorUtil", "highlightTypeFromDescriptor"));
                }
                return highlightInfoType;
            }
            case GENERIC_ERROR: {
                HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
                if (highlightInfoType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemDescriptorUtil", "highlightTypeFromDescriptor"));
                }
                return highlightInfoType;
            }
            case INFORMATION: {
                TextAttributesKey attributes = ((ProblemDescriptorBase)problemDescriptor).getEnforcedTextAttributes();
                if (attributes != null) {
                    HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, attributes);
                    if (highlightInfoTypeImpl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemDescriptorUtil", "highlightTypeFromDescriptor"));
                    }
                    return highlightInfoTypeImpl;
                }
                HighlightInfoType highlightInfoType = HighlightInfoType.INFORMATION;
                if (highlightInfoType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemDescriptorUtil", "highlightTypeFromDescriptor"));
                }
                return highlightInfoType;
            }
        }
        throw new RuntimeException("Cannot map " + highlightType);
    }

    static @interface FlagConstant {
    }
}

