/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateWithExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChooserExpressionSelector
implements PostfixTemplateExpressionSelector {
    @NotNull
    private final Condition<PsiElement> myCondition;

    public ChooserExpressionSelector(@NotNull Condition<PsiElement> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/codeInsight/template/postfix/templates/ChooserExpressionSelector", "<init>"));
        }
        this.myCondition = condition;
    }

    @Override
    public boolean hasExpression(@NotNull PostfixTemplateWithExpressionSelector postfixTemplate, @NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
        if (postfixTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postfixTemplate", "com/intellij/codeInsight/template/postfix/templates/ChooserExpressionSelector", "hasExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/templates/ChooserExpressionSelector", "hasExpression"));
        }
        if (copyDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyDocument", "com/intellij/codeInsight/template/postfix/templates/ChooserExpressionSelector", "hasExpression"));
        }
        return !this.getExpressions(postfixTemplate, context, copyDocument, newOffset).isEmpty();
    }

    @Override
    public void expandTemplate(final @NotNull PostfixTemplateWithExpressionSelector postfixTemplate, @NotNull PsiElement context, final @NotNull Editor editor) {
        if (postfixTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postfixTemplate", "com/intellij/codeInsight/template/postfix/templates/ChooserExpressionSelector", "expandTemplate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/templates/ChooserExpressionSelector", "expandTemplate"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/postfix/templates/ChooserExpressionSelector", "expandTemplate"));
        }
        List<PsiElement> expressions = this.getExpressions(postfixTemplate, context, editor.getDocument(), editor.getCaretModel().getOffset());
        if (expressions.isEmpty()) {
            PostfixTemplatesUtils.showErrorHint(context.getProject(), editor);
        } else if (expressions.size() == 1) {
            postfixTemplate.expandForChooseExpression(expressions.get(0), editor);
        } else {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                PsiElement item = (PsiElement)ContainerUtil.getLastItem(expressions);
                assert (item != null);
                postfixTemplate.expandForChooseExpression(item, editor);
                return;
            }
            IntroduceTargetChooser.showChooser(editor, expressions, new Pass<PsiElement>(){

                public void pass(final @NotNull PsiElement e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/postfix/templates/ChooserExpressionSelector$1", "pass"));
                    }
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            CommandProcessor.getInstance().executeCommand(e.getProject(), new Runnable(){

                                @Override
                                public void run() {
                                    postfixTemplate.expandForChooseExpression(e, editor);
                                }
                            }, "Expand postfix template", (Object)"POSTFIX_TEMPLATE_ID");
                        }
                    });
                }
            }, postfixTemplate.getPsiInfo().getRenderer(), "Expressions", 0, ScopeHighlighter.NATURAL_RANGER);
        }
    }

    @NotNull
    private List<PsiElement> getExpressions(@NotNull PostfixTemplateWithExpressionSelector postfixTemplate, @NotNull PsiElement context, @NotNull Document document, final int offset) {
        if (postfixTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postfixTemplate", "com/intellij/codeInsight/template/postfix/templates/ChooserExpressionSelector", "getExpressions"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/templates/ChooserExpressionSelector", "getExpressions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/template/postfix/templates/ChooserExpressionSelector", "getExpressions"));
        }
        List<PsiElement> possibleExpressions = postfixTemplate.getPsiInfo().getExpressions(context, document, offset);
        List<PsiElement> expressions = ContainerUtil.filter(possibleExpressions, (Condition)new Condition<PsiElement>(){

            public boolean value(PsiElement expression) {
                return expression.getTextRange().getEndOffset() == offset;
            }
        });
        List list = ContainerUtil.filter(expressions.isEmpty() ? ChooserExpressionSelector.maybeTopmostExpression(postfixTemplate, context) : expressions, this.myCondition);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/ChooserExpressionSelector", "getExpressions"));
        }
        return list;
    }

    @NotNull
    private static List<PsiElement> maybeTopmostExpression(@NotNull PostfixTemplateWithExpressionSelector postfixTemplate, @NotNull PsiElement context) {
        if (postfixTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postfixTemplate", "com/intellij/codeInsight/template/postfix/templates/ChooserExpressionSelector", "maybeTopmostExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/templates/ChooserExpressionSelector", "maybeTopmostExpression"));
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)postfixTemplate.getPsiInfo().getTopmostExpression(context));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/ChooserExpressionSelector", "maybeTopmostExpression"));
        }
        return list;
    }
}

