/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.tokens;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LocalTimeCounter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateToken
extends ZenCodingToken {
    public static final String ATTRS = "ATTRS";
    public static final TemplateToken EMPTY_TEMPLATE_TOKEN = new TemplateToken("", new ArrayList<Couple<String>>());
    private final String myKey;
    private TemplateImpl myTemplate;
    private final List<Couple<String>> myAttribute2Value;
    private XmlFile myFile;

    public TemplateToken(String key) {
        this(key, new ArrayList<Couple<String>>());
    }

    public TemplateToken(String key, List<Couple<String>> attribute2value) {
        this.myKey = key;
        this.myAttribute2Value = attribute2value;
    }

    public List<Couple<String>> getAttribute2Value() {
        return this.myAttribute2Value;
    }

    public XmlFile getFile() {
        return this.myFile;
    }

    public void setFile(XmlFile file) {
        this.myFile = file;
    }

    public String getKey() {
        return this.myKey;
    }

    public boolean setTemplate(TemplateImpl template, CustomTemplateCallback callback) {
        this.myTemplate = template;
        XmlFile xmlFile = TemplateToken.parseXmlFileInTemplate(template, callback, this.getAttribute2Value());
        this.setFile(xmlFile);
        XmlTag tag = xmlFile.getRootTag();
        return this.getAttribute2Value().size() <= 0 || tag != null;
    }

    private static boolean containsAttrsVar(TemplateImpl template) {
        for (int i = 0; i < template.getVariableCount(); ++i) {
            String varName = template.getVariableNameAt(i);
            if (!ATTRS.equals(varName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static XmlFile parseXmlFileInTemplate(TemplateImpl template, CustomTemplateCallback callback, List<Couple<String>> attributes) {
        XmlFile xmlFile;
        VirtualFile vFile;
        XmlFile dummyFile;
        XmlTag dummyRootTag = null;
        String templateString = template.getString();
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)callback.getProject());
        if (!TemplateToken.containsAttrsVar(template) && (dummyRootTag = (dummyFile = (XmlFile)psiFileFactory.createFileFromText("dummy.xml", (FileType)StdFileTypes.XML, (CharSequence)templateString)).getRootTag()) != null) {
            TemplateToken.addMissingAttributes(dummyRootTag, attributes);
        }
        if ((vFile = (xmlFile = (XmlFile)psiFileFactory.createFileFromText("dummy.xml", (FileType)StdFileTypes.XML, (CharSequence)(templateString = dummyRootTag != null ? dummyRootTag.getContainingFile().getText() : templateString), LocalTimeCounter.currentTime(), true)).getVirtualFile()) != null) {
            vFile.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        }
        XmlFile xmlFile2 = xmlFile;
        if (xmlFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "parseXmlFileInTemplate"));
        }
        return xmlFile2;
    }

    private static void addMissingAttributes(XmlTag tag, List<Couple<String>> value) {
        ArrayList<Couple<String>> attr2value = new ArrayList<Couple<String>>(value);
        Iterator iterator = attr2value.iterator();
        while (iterator.hasNext()) {
            Couple pair = (Couple)iterator.next();
            if (tag.getAttribute((String)pair.first) == null) continue;
            iterator.remove();
        }
        TemplateToken.addAttributesBefore(tag, attr2value);
    }

    private static void addAttributesBefore(XmlTag tag, List<Couple<String>> attr2value) {
        XmlAttribute firstAttribute = (XmlAttribute)ArrayUtil.getFirstElement((Object[])tag.getAttributes());
        XmlElementFactory factory = XmlElementFactory.getInstance((Project)tag.getProject());
        for (Couple<String> pair : attr2value) {
            XmlAttribute xmlAttribute = factory.createXmlAttribute((String)pair.first, "");
            if (firstAttribute != null) {
                tag.addBefore((PsiElement)xmlAttribute, (PsiElement)firstAttribute);
                continue;
            }
            tag.add((PsiElement)xmlAttribute);
        }
    }

    @Nullable
    public TemplateImpl getTemplate() {
        return this.myTemplate;
    }

    public String toString() {
        return "TEMPLATE";
    }
}

