/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.filters;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BemEmmetFilter
extends ZenCodingFilter {
    public static final String SUFFIX = "bem";
    private static final Key<BemState> BEM_STATE = Key.create((String)"BEM_STATE");
    private static final String ELEMENT_SEPARATOR = "__";
    private static final String MODIFIER_SEPARATOR = "_";
    private static final String SHORT_ELEMENT_PREFIX = "-";
    private static final Joiner ELEMENTS_JOINER = Joiner.on((String)"__").skipNulls();
    private static final Splitter ELEMENTS_SPLITTER = Splitter.on((String)"__");
    private static final Splitter MODIFIERS_SPLITTER = Splitter.on((String)"_").limit(2);
    private static final Splitter CLASS_NAME_SPLITTER = Splitter.on((char)' ').trimResults().omitEmptyStrings();
    private static final Joiner CLASS_NAME_JOINER = Joiner.on((char)' ');
    private static final Function<String, String> CLASS_NAME_NORMALIZER = new Function<String, String>(){

        @NotNull
        public String apply(@NotNull String input) {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter$1", "apply"));
            }
            if (!input.startsWith(BemEmmetFilter.SHORT_ELEMENT_PREFIX)) {
                String string = input;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter$1", "apply"));
                }
                return string;
            }
            StringBuilder result = new StringBuilder();
            while (input.startsWith(BemEmmetFilter.SHORT_ELEMENT_PREFIX)) {
                input = input.substring(BemEmmetFilter.SHORT_ELEMENT_PREFIX.length());
                result.append(BemEmmetFilter.ELEMENT_SEPARATOR);
            }
            String string = result.append(input).toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter$1", "apply"));
            }
            return string;
        }
    };
    private static final Predicate<String> BLOCK_NAME_PREDICATE = new Predicate<String>(){

        public boolean apply(String className) {
            return Pattern.compile("^[A-z]-").matcher(className).matches();
        }
    };
    private static final Predicate<String> STARTS_WITH_LETTER = new Predicate<String>(){

        public boolean apply(@Nullable String input) {
            return input != null && input.length() > 0 && Character.isLetter(input.charAt(0));
        }
    };

    @Override
    @NotNull
    public String getDisplayName() {
        if ("BEM" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "getDisplayName"));
        }
        return "BEM";
    }

    @Override
    @NotNull
    public String getSuffix() {
        if (SUFFIX == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "getSuffix"));
        }
        return SUFFIX;
    }

    @Override
    public boolean isMyContext(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "isMyContext"));
        }
        return context.getLanguage() instanceof XMLLanguage;
    }

    @Override
    @NotNull
    public GenerationNode filterNode(final @NotNull GenerationNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "filterNode"));
        }
        List<Couple<String>> attribute2Value = node.getTemplateToken().getAttribute2Value();
        Couple<String> classNamePair = BemEmmetFilter.getClassPair(attribute2Value);
        if (classNamePair != null) {
            Iterable<String> classNames = BemEmmetFilter.extractClasses((String)classNamePair.second);
            BEM_STATE.set((UserDataHolder)node, (Object)new BemState(BemEmmetFilter.suggestBlockName(classNames), null, null));
            ImmutableSet newClassNames = ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(classNames, (Function)new Function<String, Iterable<String>>(){

                public Iterable<String> apply(String className) {
                    return BemEmmetFilter.processClassName(className, node);
                }
            })));
            attribute2Value.add((Couple<String>)Couple.of((Object)"class", (Object)CLASS_NAME_JOINER.join((Iterable)newClassNames)));
        }
        GenerationNode generationNode = node;
        if (generationNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "filterNode"));
        }
        return generationNode;
    }

    private static Iterable<String> processClassName(String className, @NotNull GenerationNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "processClassName"));
        }
        className = BemEmmetFilter.fillWithBemElements(className, node);
        className = BemEmmetFilter.fillWithBemModifiers(className, node);
        BemState nodeBemState = (BemState)BEM_STATE.get((UserDataHolder)node);
        BemState bemState = BemEmmetFilter.extractBemStateFromClassName(className);
        LinkedList result = Lists.newLinkedList();
        if (!bemState.isEmpty()) {
            String block = bemState.getBlock();
            if (Strings.isNullOrEmpty((String)block)) {
                block = Strings.nullToEmpty((String)(nodeBemState != null ? nodeBemState.getBlock() : null));
                bemState.setBlock(block);
            }
            String prefix = block;
            String element = bemState.getElement();
            if (!Strings.isNullOrEmpty((String)element)) {
                prefix = prefix + ELEMENT_SEPARATOR + element;
            }
            result.add(prefix);
            String modifier = bemState.getModifier();
            if (!Strings.isNullOrEmpty((String)modifier)) {
                result.add(prefix + MODIFIER_SEPARATOR + modifier);
            }
            BEM_STATE.set((UserDataHolder)node, (Object)bemState.copy());
        } else {
            result.add(className);
        }
        return result;
    }

    @NotNull
    private static BemState extractBemStateFromClassName(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "extractBemStateFromClassName"));
        }
        BemState result = new BemState();
        if (className.contains(ELEMENT_SEPARATOR)) {
            Iterator elementsIterator = ELEMENTS_SPLITTER.split((CharSequence)className).iterator();
            result.setBlock((String)elementsIterator.next());
            LinkedList elementParts = Lists.newLinkedList();
            while (elementsIterator.hasNext()) {
                String elementPart = (String)elementsIterator.next();
                if (!elementsIterator.hasNext()) {
                    ArrayList elementModifiers = Lists.newArrayList((Iterable)MODIFIERS_SPLITTER.split((CharSequence)elementPart));
                    elementParts.add(Iterables.getFirst((Iterable)elementModifiers, null));
                    if (elementModifiers.size() <= 1) continue;
                    result.setModifier((String)Iterables.getLast((Iterable)elementModifiers, (Object)""));
                    continue;
                }
                elementParts.add(elementPart);
            }
            result.setElement(ELEMENTS_JOINER.join((Iterable)elementParts));
        } else if (className.contains(MODIFIER_SEPARATOR)) {
            Iterable blockModifiers = MODIFIERS_SPLITTER.split((CharSequence)className);
            result.setBlock((String)Iterables.getFirst((Iterable)blockModifiers, (Object)""));
            result.setModifier((String)Iterables.getLast((Iterable)blockModifiers, (Object)""));
        }
        BemState bemState = result;
        if (bemState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "extractBemStateFromClassName"));
        }
        return bemState;
    }

    @NotNull
    private static String fillWithBemElements(@NotNull String className, @NotNull GenerationNode node) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "fillWithBemElements"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "fillWithBemElements"));
        }
        String string = BemEmmetFilter.transformClassNameToBemFormat(className, ELEMENT_SEPARATOR, node);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "fillWithBemElements"));
        }
        return string;
    }

    @NotNull
    private static String fillWithBemModifiers(@NotNull String className, @NotNull GenerationNode node) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "fillWithBemModifiers"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "fillWithBemModifiers"));
        }
        String string = BemEmmetFilter.transformClassNameToBemFormat(className, MODIFIER_SEPARATOR, node);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "fillWithBemModifiers"));
        }
        return string;
    }

    @NotNull
    private static String transformClassNameToBemFormat(@NotNull String className, @NotNull String separator, @NotNull GenerationNode node) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "transformClassNameToBemFormat"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "transformClassNameToBemFormat"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "transformClassNameToBemFormat"));
        }
        Pair<String, Integer> cleanStringAndDepth = BemEmmetFilter.getCleanStringAndDepth(className, separator);
        Integer depth = (Integer)cleanStringAndDepth.second;
        if (depth > 0) {
            String prefix;
            GenerationNode donor = node;
            while (donor.getParent() != null && depth > 0) {
                donor = donor.getParent();
                Integer n = depth;
                Integer n2 = depth = Integer.valueOf(depth - 1);
            }
            BemState bemState = (BemState)BEM_STATE.get((UserDataHolder)donor);
            if (bemState != null && !Strings.isNullOrEmpty((String)(prefix = bemState.getBlock()))) {
                String element = bemState.getElement();
                if (MODIFIER_SEPARATOR.equals(separator) && !Strings.isNullOrEmpty((String)element)) {
                    prefix = prefix + separator + element;
                }
                String string = prefix + separator + (String)cleanStringAndDepth.first;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "transformClassNameToBemFormat"));
                }
                return string;
            }
        }
        String string = className;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "transformClassNameToBemFormat"));
        }
        return string;
    }

    @NotNull
    private static Pair<String, Integer> getCleanStringAndDepth(@NotNull String name, @NotNull String separator) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "getCleanStringAndDepth"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "getCleanStringAndDepth"));
        }
        int result = 0;
        while (name.startsWith(separator)) {
            ++result;
            name = name.substring(separator.length());
        }
        Pair pair = Pair.create((Object)name, (Object)result);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "getCleanStringAndDepth"));
        }
        return pair;
    }

    @NotNull
    private static Iterable<String> extractClasses(String classAttributeValue) {
        Iterable iterable = Iterables.transform((Iterable)CLASS_NAME_SPLITTER.split((CharSequence)classAttributeValue), CLASS_NAME_NORMALIZER);
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "extractClasses"));
        }
        return iterable;
    }

    @NotNull
    private static String suggestBlockName(Iterable<String> classNames) {
        String string = (String)Iterables.find(classNames, BLOCK_NAME_PREDICATE, (Object)Iterables.find(classNames, STARTS_WITH_LETTER, (Object)""));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "suggestBlockName"));
        }
        return string;
    }

    @Nullable
    private static Couple<String> getClassPair(@NotNull List<Couple<String>> attribute2Value) {
        if (attribute2Value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute2Value", "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter", "getClassPair"));
        }
        for (int i = 0; i < attribute2Value.size(); ++i) {
            Couple<String> pair = attribute2Value.get(i);
            if (!"class".equals(pair.first) || Strings.isNullOrEmpty((String)((String)pair.second))) continue;
            return attribute2Value.remove(i);
        }
        return null;
    }

    private static class BemState {
        @Nullable
        private String block;
        @Nullable
        private String element;
        @Nullable
        private String modifier;

        private BemState() {
        }

        private BemState(@Nullable String block, @Nullable String element, @Nullable String modifier) {
            this.block = block;
            this.element = element;
            this.modifier = modifier;
        }

        public void setModifier(@Nullable String modifier) {
            this.modifier = modifier;
        }

        public void setElement(@Nullable String element) {
            this.element = element;
        }

        public void setBlock(@Nullable String block) {
            this.block = block;
        }

        @Nullable
        public String getBlock() {
            return this.block;
        }

        @Nullable
        public String getElement() {
            return this.element;
        }

        @Nullable
        public String getModifier() {
            return this.modifier;
        }

        public boolean isEmpty() {
            return Strings.isNullOrEmpty((String)this.block) && Strings.isNullOrEmpty((String)this.element) && Strings.isNullOrEmpty((String)this.modifier);
        }

        @Nullable
        public BemState copy() {
            return new BemState(this.block, this.element, this.modifier);
        }
    }
}

