/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.template.emmet.EmmetPreviewHint;
import com.intellij.codeInsight.template.emmet.EmmetPreviewUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class EmmetPreviewTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        String templateText;
        EmmetPreviewHint existingBalloon;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/template/emmet/EmmetPreviewTypedHandler", "charTyped"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/emmet/EmmetPreviewTypedHandler", "charTyped"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/emmet/EmmetPreviewTypedHandler", "charTyped"));
        }
        if (EmmetOptions.getInstance().isPreviewEnabled() && (existingBalloon = EmmetPreviewHint.getExistingHint(editor)) == null && StringUtil.isNotEmpty((String)(templateText = EmmetPreviewUtil.calculateTemplateText(editor, file, false)))) {
            EmmetPreviewHint.createHint((EditorEx)editor, templateText, file.getFileType()).showHint();
            EmmetPreviewUtil.addEmmetPreviewListeners(editor, file, false);
        }
        return super.charTyped(c, project, editor, file);
    }
}

