/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.GotoTargetRendererProvider;
import com.intellij.codeInsight.navigation.ListBackgroundUpdaterTask;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindUtil;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.JBListWithHintProvider;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.usages.UsageView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GotoTargetHandler
implements CodeInsightActionHandler {
    private static final PsiElementListCellRenderer ourDefaultTargetElementRenderer = new DefaultPsiElementListCellRenderer();
    private final DefaultListCellRenderer myActionElementRenderer = new ActionCellRenderer();

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/navigation/GotoTargetHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/GotoTargetHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/navigation/GotoTargetHandler", "invoke"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed(this.getFeatureUsedKey());
        try {
            GotoData gotoData = this.getSourceAndTargetElements(editor, file);
            if (gotoData != null && gotoData.source != null) {
                this.show(project, editor, file, gotoData);
            }
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)project).showDumbModeNotification("Navigation is not available here during index update");
        }
    }

    @NonNls
    protected abstract String getFeatureUsedKey();

    @Nullable
    protected abstract GotoData getSourceAndTargetElements(Editor var1, PsiFile var2);

    private void show(final @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, final @NotNull GotoData gotoData) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/navigation/GotoTargetHandler", "show"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/GotoTargetHandler", "show"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/navigation/GotoTargetHandler", "show"));
        }
        if (gotoData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gotoData", "com/intellij/codeInsight/navigation/GotoTargetHandler", "show"));
        }
        PsiElement[] targets = gotoData.targets;
        List<AdditionalAction> additionalActions = gotoData.additionalActions;
        if (targets.length == 0 && additionalActions.isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, this.getNotFoundMessage(project, editor, file));
            return;
        }
        if (targets.length == 1 && additionalActions.isEmpty()) {
            Navigatable descriptor;
            Navigatable navigatable = descriptor = targets[0] instanceof Navigatable ? (Navigatable)targets[0] : EditSourceUtil.getDescriptor((PsiElement)targets[0]);
            if (descriptor != null && descriptor.canNavigate()) {
                this.navigateToElement(descriptor);
            }
            return;
        }
        for (PsiElement eachTarget : targets) {
            gotoData.renderers.put(eachTarget, GotoTargetHandler.createRenderer(gotoData, eachTarget));
        }
        final String name = ((PsiNamedElement)gotoData.source).getName();
        String title = this.getChooserTitle(gotoData.source, name, targets.length);
        if (this.shouldSortTargets()) {
            Arrays.sort(targets, GotoTargetHandler.createComparator(gotoData.renderers, gotoData));
        }
        ArrayList<AdditionalAction> allElements = new ArrayList<AdditionalAction>(targets.length + additionalActions.size());
        Collections.addAll(allElements, targets);
        allElements.addAll(additionalActions);
        final JBListWithHintProvider list = new JBListWithHintProvider((ListModel)new CollectionListModel(allElements)){

            protected PsiElement getPsiElementForHint(Object selectedValue) {
                return selectedValue instanceof PsiElement ? (PsiElement)selectedValue : null;
            }
        };
        list.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == null) {
                    return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                }
                if (value instanceof AdditionalAction) {
                    return GotoTargetHandler.this.myActionElementRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                }
                PsiElementListCellRenderer renderer = GotoTargetHandler.getRenderer(value, gotoData.renderers, gotoData);
                return renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object[] selectedElements;
                int[] ids = list.getSelectedIndices();
                if (ids == null || ids.length == 0) {
                    return;
                }
                for (Object element : selectedElements = list.getSelectedValues()) {
                    Navigatable nav;
                    if (element instanceof AdditionalAction) {
                        ((AdditionalAction)element).execute();
                        continue;
                    }
                    Navigatable navigatable = nav = element instanceof Navigatable ? (Navigatable)element : EditSourceUtil.getDescriptor((PsiElement)((PsiElement)element));
                    if (nav == null || !nav.canNavigate()) continue;
                    GotoTargetHandler.this.navigateToElement(nav);
                }
            }
        };
        PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
        builder.setFilteringEnabled((Function)new Function<Object, String>(){

            public String fun(Object o) {
                if (o instanceof AdditionalAction) {
                    return ((AdditionalAction)o).getText();
                }
                return GotoTargetHandler.getRenderer(o, gotoData.renderers, gotoData).getElementText((PsiElement)o);
            }
        });
        final Ref usageView = new Ref();
        JBPopup popup = builder.setTitle(title).setItemChoosenCallback(runnable).setMovable(true).setCancelCallback((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                HintUpdateSupply.hideHint((JComponent)list);
                return true;
            }
        }).setCouldPin((Processor)new Processor<JBPopup>(){

            public boolean process(JBPopup popup) {
                usageView.set((Object)FindUtil.showInUsageView(gotoData.source, gotoData.targets, GotoTargetHandler.this.getFindUsagesTitle(gotoData.source, name, gotoData.targets.length), project));
                popup.cancel();
                return false;
            }
        }).setAdText(this.getAdText(gotoData.source, targets.length)).createPopup();
        if (gotoData.listUpdaterTask != null) {
            gotoData.listUpdaterTask.init((AbstractPopup)popup, list, (Ref<UsageView>)usageView);
            ProgressManager.getInstance().run((Task)gotoData.listUpdaterTask);
        }
        popup.showInBestPositionFor(editor);
    }

    private static PsiElementListCellRenderer getRenderer(Object value, Map<Object, PsiElementListCellRenderer> targetsWithRenderers, GotoData gotoData) {
        PsiElementListCellRenderer renderer = targetsWithRenderers.get(value);
        if (renderer == null) {
            renderer = gotoData.getRenderer(value);
        }
        if (renderer != null) {
            return renderer;
        }
        return ourDefaultTargetElementRenderer;
    }

    protected static Comparator<PsiElement> createComparator(final Map<Object, PsiElementListCellRenderer> targetsWithRenderers, final GotoData gotoData) {
        return new Comparator<PsiElement>(){

            @Override
            public int compare(PsiElement o1, PsiElement o2) {
                return this.getComparingObject(o1).compareTo(this.getComparingObject(o2));
            }

            private Comparable getComparingObject(PsiElement o1) {
                return GotoTargetHandler.getRenderer(o1, targetsWithRenderers, gotoData).getComparingObject(o1);
            }
        };
    }

    protected static PsiElementListCellRenderer createRenderer(GotoData gotoData, PsiElement eachTarget) {
        GotoTargetRendererProvider eachProvider;
        PsiElementListCellRenderer renderer = null;
        GotoTargetRendererProvider[] arr$ = (GotoTargetRendererProvider[])Extensions.getExtensions(GotoTargetRendererProvider.EP_NAME);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (renderer = (eachProvider = arr$[i$]).getRenderer(eachTarget, gotoData)) == null; ++i$) {
        }
        if (renderer == null) {
            renderer = ourDefaultTargetElementRenderer;
        }
        return renderer;
    }

    protected void navigateToElement(Navigatable descriptor) {
        descriptor.navigate(true);
    }

    protected boolean shouldSortTargets() {
        return true;
    }

    @NotNull
    protected abstract String getChooserTitle(PsiElement var1, String var2, int var3);

    @NotNull
    protected String getFindUsagesTitle(PsiElement sourceElement, String name, int length) {
        String string = this.getChooserTitle(sourceElement, name, length);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/GotoTargetHandler", "getFindUsagesTitle"));
        }
        return string;
    }

    @NotNull
    protected abstract String getNotFoundMessage(@NotNull Project var1, @NotNull Editor var2, @NotNull PsiFile var3);

    @Nullable
    protected String getAdText(PsiElement source, int length) {
        return null;
    }

    private static class ActionCellRenderer
    extends DefaultListCellRenderer {
        private ActionCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                AdditionalAction action = (AdditionalAction)value;
                this.setText(action.getText());
                this.setIcon(action.getIcon());
            }
            return result;
        }
    }

    private static class DefaultPsiElementListCellRenderer
    extends PsiElementListCellRenderer {
        private DefaultPsiElementListCellRenderer() {
        }

        public String getElementText(PsiElement element) {
            String name;
            if (element instanceof PsiNamedElement && (name = ((PsiNamedElement)element).getName()) != null) {
                return name;
            }
            return element.getContainingFile().getName();
        }

        protected String getContainerText(PsiElement element, String name) {
            if (element instanceof NavigationItem) {
                ItemPresentation presentation = ((NavigationItem)element).getPresentation();
                return presentation != null ? presentation.getLocationString() : null;
            }
            return null;
        }

        @Override
        protected int getIconFlags() {
            return 0;
        }
    }

    public static class GotoData {
        @NotNull
        public final PsiElement source;
        public PsiElement[] targets;
        public final List<AdditionalAction> additionalActions;
        private boolean hasDifferentNames;
        public ListBackgroundUpdaterTask listUpdaterTask;
        protected final Set<String> myNames;
        public Map<Object, PsiElementListCellRenderer> renderers;

        public GotoData(@NotNull PsiElement source, @NotNull PsiElement[] targets, @NotNull List<AdditionalAction> additionalActions) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/codeInsight/navigation/GotoTargetHandler$GotoData", "<init>"));
            }
            if (targets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/codeInsight/navigation/GotoTargetHandler$GotoData", "<init>"));
            }
            if (additionalActions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalActions", "com/intellij/codeInsight/navigation/GotoTargetHandler$GotoData", "<init>"));
            }
            this.renderers = new HashMap<Object, PsiElementListCellRenderer>();
            this.source = source;
            this.targets = targets;
            this.additionalActions = additionalActions;
            this.myNames = new HashSet();
            for (PsiElement target : targets) {
                if (!(target instanceof PsiNamedElement)) continue;
                this.myNames.add(((PsiNamedElement)target).getName());
                if (this.myNames.size() > 1) break;
            }
            this.hasDifferentNames = this.myNames.size() > 1;
        }

        public boolean hasDifferentNames() {
            return this.hasDifferentNames;
        }

        public boolean addTarget(final PsiElement element) {
            if (ArrayUtil.find((Object[])this.targets, (Object)element) > -1) {
                return false;
            }
            this.targets = (PsiElement[])ArrayUtil.append((Object[])this.targets, (Object)element);
            this.renderers.put(element, GotoTargetHandler.createRenderer(this, element));
            if (!this.hasDifferentNames && element instanceof PsiNamedElement) {
                String name = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return ((PsiNamedElement)element).getName();
                    }
                });
                this.myNames.add(name);
                this.hasDifferentNames = this.myNames.size() > 1;
            }
            return true;
        }

        public PsiElementListCellRenderer getRenderer(Object value) {
            return this.renderers.get(value);
        }
    }

    public static interface AdditionalAction {
        @NotNull
        public String getText();

        public Icon getIcon();

        public void execute();
    }
}

