/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.impl.QuickEditHandler;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickEditAction
implements IntentionAction,
LowPriorityAction {
    public static final Key<QuickEditHandler> QUICK_EDIT_HANDLER = Key.create((String)"QUICK_EDIT_HANDLER");
    public static final Key<Boolean> EDIT_ACTION_AVAILABLE = Key.create((String)"EDIT_ACTION_AVAILABLE");
    private String myLastLanguageName;

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/QuickEditAction", "isAvailable"));
        }
        return this.getRangePair(file, editor) != null;
    }

    @Nullable
    protected Pair<PsiElement, TextRange> getRangePair(PsiFile file, Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), PsiLanguageInjectionHost.class, (boolean)false);
        if (host == null || ElementManipulators.getManipulator((PsiElement)host) == null) {
            return null;
        }
        List injections = InjectedLanguageManager.getInstance((Project)host.getProject()).getInjectedPsiFiles((PsiElement)host);
        if (injections == null || injections.isEmpty()) {
            return null;
        }
        final int offsetInElement = offset - host.getTextRange().getStartOffset();
        Pair rangePair = (Pair)ContainerUtil.find((Iterable)injections, (Condition)new Condition<Pair<PsiElement, TextRange>>(){

            public boolean value(Pair<PsiElement, TextRange> pair) {
                return ((TextRange)pair.second).containsRange(offsetInElement, offsetInElement);
            }
        });
        if (rangePair != null) {
            Language language = ((PsiElement)rangePair.first).getContainingFile().getLanguage();
            Object action = language.getUserData(EDIT_ACTION_AVAILABLE);
            if (action != null && action.equals(false)) {
                return null;
            }
            this.myLastLanguageName = language.getDisplayName();
        }
        return rangePair;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/QuickEditAction", "invoke"));
        }
        this.invokeImpl(project, editor, file);
    }

    public QuickEditHandler invokeImpl(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        DocumentWindow documentWindow;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/QuickEditAction", "invokeImpl"));
        }
        int offset = editor.getCaretModel().getOffset();
        Pair pair = (Pair)ObjectUtils.assertNotNull(this.getRangePair(file, editor));
        PsiFile injectedFile = (PsiFile)pair.first;
        QuickEditHandler handler = this.getHandler(project, injectedFile, editor, file);
        if (!ApplicationManager.getApplication().isUnitTestMode() && (documentWindow = InjectedLanguageUtil.getDocumentWindow((PsiElement)injectedFile)) != null) {
            handler.navigate(((DocumentWindowImpl)documentWindow).hostToInjectedUnescaped(offset));
        }
        return handler;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    private QuickEditHandler getHandler(Project project, PsiFile injectedFile, Editor editor, PsiFile origFile) {
        QuickEditHandler handler = QuickEditAction.getExistingHandler(injectedFile);
        if (handler != null && handler.isValid()) {
            QuickEditHandler quickEditHandler = handler;
            if (quickEditHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/QuickEditAction", "getHandler"));
            }
            return quickEditHandler;
        }
        handler = new QuickEditHandler(project, injectedFile, origFile, editor, this);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            injectedFile.putUserData(QUICK_EDIT_HANDLER, (Object)handler);
        }
        QuickEditHandler quickEditHandler = handler;
        if (quickEditHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/QuickEditAction", "getHandler"));
        }
        return quickEditHandler;
    }

    public static QuickEditHandler getExistingHandler(@NotNull PsiFile injectedFile) {
        if (injectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedFile", "com/intellij/codeInsight/intention/impl/QuickEditAction", "getExistingHandler"));
        }
        Place shreds = InjectedLanguageUtil.getShreds(injectedFile);
        DocumentWindow documentWindow = InjectedLanguageUtil.getDocumentWindow((PsiElement)injectedFile);
        if (shreds == null || documentWindow == null) {
            return null;
        }
        TextRange hostRange = TextRange.create((int)((PsiLanguageInjectionHost.Shred)shreds.get(0)).getHostRangeMarker().getStartOffset(), (int)((PsiLanguageInjectionHost.Shred)shreds.get(shreds.size() - 1)).getHostRangeMarker().getEndOffset());
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            QuickEditHandler handler;
            if (editor.getDocument() != documentWindow.getDelegate() || (handler = (QuickEditHandler)((Object)editor.getUserData(QUICK_EDIT_HANDLER))) == null || !handler.changesRange(hostRange)) continue;
            return handler;
        }
        return null;
    }

    protected boolean isShowInBalloon() {
        return false;
    }

    @Nullable
    protected JComponent createBalloonComponent(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/intention/impl/QuickEditAction", "createBalloonComponent"));
        }
        return null;
    }

    @NotNull
    public String getText() {
        String string = "Edit " + StringUtil.notNullize((String)this.myLastLanguageName, (String)"Injected") + " Fragment";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/QuickEditAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Edit Injected Fragment" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/QuickEditAction", "getFamilyName"));
        }
        return "Edit Injected Fragment";
    }

    public static Balloon.Position getBalloonPosition(Editor editor) {
        int line = editor.getCaretModel().getVisualPosition().line;
        Rectangle area = editor.getScrollingModel().getVisibleArea();
        int startLine = area.y / editor.getLineHeight() + 1;
        return (line - startLine) * editor.getLineHeight() < 200 ? Balloon.Position.below : Balloon.Position.above;
    }
}

