/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class CollapseExpandDocCommentsHandler
implements CodeInsightActionHandler {
    private final boolean myExpand;

    public CollapseExpandDocCommentsHandler(boolean isExpand) {
        this.myExpand = isExpand;
    }

    public void invoke(@NotNull Project project, final @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/folding/impl/CollapseExpandDocCommentsHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/CollapseExpandDocCommentsHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/folding/impl/CollapseExpandDocCommentsHandler", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        CodeFoldingManager foldingManager = CodeFoldingManager.getInstance(project);
        foldingManager.updateFoldRegions(editor);
        final FoldRegion[] allFoldRegions = editor.getFoldingModel().getAllFoldRegions();
        Runnable processor = new Runnable(){

            @Override
            public void run() {
                for (FoldRegion region : allFoldRegions) {
                    PsiElement element = EditorFoldingInfo.get(editor).getPsiElement(region);
                    if (!(element instanceof PsiDocCommentBase)) continue;
                    region.setExpanded(CollapseExpandDocCommentsHandler.this.myExpand);
                }
            }
        };
        editor.getFoldingModel().runBatchFoldingOperation(processor);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

