/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.DocumentFoldingInfo;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseMotionAdapter;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import com.intellij.util.containers.WeakList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeFoldingManagerImpl
extends CodeFoldingManager
implements ProjectComponent {
    private final Project myProject;
    private final List<Document> myDocumentsWithFoldingInfo = new WeakList();
    private final Key<DocumentFoldingInfo> myFoldingInfoInDocumentKey = Key.create((String)"FOLDING_INFO_IN_DOCUMENT_KEY");
    private static final Key<Boolean> FOLDING_STATE_KEY = Key.create((String)"FOLDING_STATE_KEY");

    CodeFoldingManagerImpl(Project project) {
        this.myProject = project;
        project.getMessageBus().connect().subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new DocumentBulkUpdateListener.Adapter(){

            @Override
            public void updateStarted(@NotNull Document doc) {
                if (doc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl$1", "updateStarted"));
                }
                CodeFoldingManagerImpl.resetFoldingInfo(doc);
            }
        });
    }

    @NotNull
    public String getComponentName() {
        if ("CodeFoldingManagerImpl" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "getComponentName"));
        }
        return "CodeFoldingManagerImpl";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        for (Document document : this.myDocumentsWithFoldingInfo) {
            if (document == null) continue;
            document.putUserData(this.myFoldingInfoInDocumentKey, null);
        }
    }

    public void projectOpened() {
        final EditorMouseMotionAdapter myMouseMotionListener = new EditorMouseMotionAdapter(){
            LightweightHint myCurrentHint = null;
            FoldRegion myCurrentFold = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseMoved(EditorMouseEvent e) {
                if (CodeFoldingManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                HintManager hintManager = HintManager.getInstance();
                if (hintManager != null && hintManager.hasShownHintsThatWillHideByOtherHint(false)) {
                    return;
                }
                if (e.getArea() != EditorMouseEventArea.FOLDING_OUTLINE_AREA) {
                    return;
                }
                LightweightHint hint = null;
                try {
                    Editor editor = e.getEditor();
                    if (PsiDocumentManager.getInstance((Project)CodeFoldingManagerImpl.this.myProject).isUncommited(editor.getDocument())) {
                        return;
                    }
                    MouseEvent mouseEvent = e.getMouseEvent();
                    FoldRegion fold = ((EditorEx)editor).getGutterComponentEx().findFoldingAnchorAt(mouseEvent.getX(), mouseEvent.getY());
                    if (fold == null || !fold.isValid()) {
                        return;
                    }
                    if (fold == this.myCurrentFold && this.myCurrentHint != null) {
                        hint = this.myCurrentHint;
                        return;
                    }
                    TextRange psiElementRange = EditorFoldingInfo.get(editor).getPsiElementRange(fold);
                    if (psiElementRange == null) {
                        return;
                    }
                    int textOffset = psiElementRange.getStartOffset();
                    Point foldStartXY = editor.visualPositionToXY(editor.offsetToVisualPosition(Math.max(textOffset, fold.getStartOffset())));
                    Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
                    if (visibleArea.y > foldStartXY.y) {
                        int desiredEndVisualLine;
                        int startVisualLine;
                        int endVisualLine;
                        Container contentPane;
                        if (this.myCurrentHint != null) {
                            this.myCurrentHint.hide();
                            this.myCurrentHint = null;
                        }
                        int availableVisualLines = 2;
                        JComponent editorComponent = editor.getComponent();
                        Container editorComponentParent = editorComponent.getParent();
                        if (editorComponentParent != null && (contentPane = editorComponent.getRootPane().getContentPane()) != null) {
                            int y = SwingUtilities.convertPoint((Component)editorComponentParent, (Point)editorComponent.getLocation(), (Component)contentPane).y;
                            int visualLines = y / editor.getLineHeight();
                            availableVisualLines = Math.max(availableVisualLines, visualLines);
                        }
                        if ((endVisualLine = (startVisualLine = editor.offsetToVisualPosition((int)textOffset).line) + availableVisualLines) > (desiredEndVisualLine = Math.max(0, editor.xyToVisualPosition((Point)new Point((int)0, (int)visibleArea.y)).line - 1))) {
                            endVisualLine = desiredEndVisualLine;
                        }
                        int endOffset = editor.logicalPositionToOffset(editor.visualToLogicalPosition(new VisualPosition(endVisualLine, 0)));
                        UnfairTextRange textRange = new UnfairTextRange(textOffset, endOffset);
                        hint = EditorFragmentComponent.showEditorFragmentHint(editor, (TextRange)textRange, true, true);
                        this.myCurrentFold = fold;
                        this.myCurrentHint = hint;
                    }
                }
                finally {
                    if (hint == null) {
                        if (this.myCurrentHint != null) {
                            this.myCurrentHint.hide();
                            this.myCurrentHint = null;
                        }
                        this.myCurrentFold = null;
                    }
                }
            }
        };
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                EditorFactory.getInstance().getEventMulticaster().addEditorMouseMotionListener((EditorMouseMotionListener)myMouseMotionListener, (Disposable)CodeFoldingManagerImpl.this.myProject);
            }
        });
    }

    @Override
    public void releaseFoldings(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "releaseFoldings"));
        }
        ApplicationManagerEx.getApplicationEx().assertIsDispatchThread();
        Project project = editor.getProject();
        if (!(project == null || project.equals(this.myProject) && project.isOpen())) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (file == null || !file.getViewProvider().isPhysical() || !file.isValid()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
        Editor[] otherEditors = EditorFactory.getInstance().getEditors(document, this.myProject);
        if (otherEditors.length == 0 && !editor.isDisposed()) {
            this.getDocumentFoldingInfo(document).loadFromEditor(editor);
        }
        EditorFoldingInfo.get(editor).dispose();
    }

    @Override
    public void buildInitialFoldings(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "buildInitialFoldings"));
        }
        Project project = editor.getProject();
        if (project == null || !project.equals(this.myProject) || editor.isDisposed()) {
            return;
        }
        if (!((FoldingModelEx)editor.getFoldingModel()).isFoldingEnabled()) {
            return;
        }
        if (!FoldingUpdate.supportsDumbModeFolding(editor)) {
            return;
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
        CodeFoldingState foldingState = this.buildInitialFoldings(document);
        if (foldingState != null) {
            foldingState.setToEditor(editor);
        }
    }

    @Override
    @Nullable
    public CodeFoldingState buildInitialFoldings(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "buildInitialFoldings"));
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        if (psiDocumentManager.isUncommited(document)) {
            return null;
        }
        final PsiFile file = psiDocumentManager.getPsiFile(document);
        if (file == null || !file.isValid() || !file.getViewProvider().isPhysical() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        final FoldingUpdate.FoldingMap foldingMap = FoldingUpdate.getFoldingsFor(this.myProject, file, document, true);
        return new CodeFoldingState(){

            @Override
            public void setToEditor(@NotNull Editor editor) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl$4", "setToEditor"));
                }
                ApplicationManagerEx.getApplicationEx().assertIsDispatchThread();
                if (CodeFoldingManagerImpl.this.myProject.isDisposed() || editor.isDisposed()) {
                    return;
                }
                FoldingModelEx foldingModel = (FoldingModelEx)editor.getFoldingModel();
                if (!foldingModel.isFoldingEnabled()) {
                    return;
                }
                if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
                    return;
                }
                if (DumbService.isDumb((Project)CodeFoldingManagerImpl.this.myProject) && !FoldingUpdate.supportsDumbModeFolding(editor)) {
                    return;
                }
                foldingModel.runBatchFoldingOperationDoNotCollapseCaret(new UpdateFoldRegionsOperation(CodeFoldingManagerImpl.this.myProject, editor, file, foldingMap, UpdateFoldRegionsOperation.ApplyDefaultStateMode.YES, false));
                CodeFoldingManagerImpl.this.initFolding(editor);
            }
        };
    }

    private void initFolding(final @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "initFolding"));
        }
        final Document document = editor.getDocument();
        editor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

            @Override
            public void run() {
                Editor[] editors;
                DocumentFoldingInfo documentFoldingInfo = CodeFoldingManagerImpl.this.getDocumentFoldingInfo(document);
                for (Editor otherEditor : editors = EditorFactory.getInstance().getEditors(document, CodeFoldingManagerImpl.this.myProject)) {
                    if (otherEditor == editor || !CodeFoldingManagerImpl.isFoldingsInitializedInEditor(otherEditor)) continue;
                    documentFoldingInfo.loadFromEditor(otherEditor);
                    break;
                }
                documentFoldingInfo.setToEditor(editor);
                documentFoldingInfo.clear();
                document.putUserData(FOLDING_STATE_KEY, (Object)Boolean.TRUE);
                editor.putUserData(FOLDING_STATE_KEY, (Object)Boolean.TRUE);
            }
        });
    }

    public void projectClosed() {
    }

    @Override
    @Nullable
    public FoldRegion findFoldRegion(@NotNull Editor editor, int startOffset, int endOffset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "findFoldRegion"));
        }
        return FoldingUtil.findFoldRegion(editor, startOffset, endOffset);
    }

    @Override
    public FoldRegion[] getFoldRegionsAtOffset(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "getFoldRegionsAtOffset"));
        }
        return FoldingUtil.getFoldRegionsAtOffset(editor, offset);
    }

    @Override
    public void updateFoldRegions(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "updateFoldRegions"));
        }
        this.updateFoldRegions(editor, false);
    }

    public void updateFoldRegions(Editor editor, boolean quick) {
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(editor.getDocument());
        Runnable runnable = this.updateFoldRegions(editor, false, quick);
        if (runnable != null) {
            runnable.run();
        }
    }

    @Override
    public void forceDefaultState(final @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "forceDefaultState"));
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(editor.getDocument());
        Runnable runnable = this.updateFoldRegions(editor, true, false);
        if (runnable != null) {
            runnable.run();
        }
        final FoldRegion[] regions = editor.getFoldingModel().getAllFoldRegions();
        editor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

            @Override
            public void run() {
                EditorFoldingInfo foldingInfo = EditorFoldingInfo.get(editor);
                for (FoldRegion region : regions) {
                    PsiElement element = foldingInfo.getPsiElement(region);
                    if (element == null) continue;
                    region.setExpanded(!FoldingPolicy.isCollapseByDefault(element));
                }
            }
        });
    }

    @Override
    @Nullable
    public Runnable updateFoldRegionsAsync(final @NotNull Editor editor, final boolean firstTime) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "updateFoldRegionsAsync"));
        }
        final Runnable runnable = this.updateFoldRegions(editor, firstTime, false);
        return new Runnable(){

            @Override
            public void run() {
                if (runnable != null) {
                    runnable.run();
                }
                if (firstTime && !CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
                    CodeFoldingManagerImpl.this.initFolding(editor);
                }
            }
        };
    }

    @Nullable
    private Runnable updateFoldRegions(@NotNull Editor editor, boolean applyDefaultState, boolean quick) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "updateFoldRegions"));
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
        if (file != null) {
            return FoldingUpdate.updateFoldRegions(editor, file, applyDefaultState, quick);
        }
        return null;
    }

    @Override
    public CodeFoldingState saveFoldingState(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "saveFoldingState"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        DocumentFoldingInfo info = this.getDocumentFoldingInfo(editor.getDocument());
        if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
            info.loadFromEditor(editor);
        }
        return info;
    }

    @Override
    public void restoreFoldingState(@NotNull Editor editor, @NotNull CodeFoldingState state2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "restoreFoldingState"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "restoreFoldingState"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
            state2.setToEditor(editor);
        }
    }

    @Override
    public void writeFoldingState(@NotNull CodeFoldingState state2, @NotNull Element element) throws WriteExternalException {
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "writeFoldingState"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "writeFoldingState"));
        }
        if (!(state2 instanceof DocumentFoldingInfo)) {
            throw new WriteExternalException();
        }
        ((DocumentFoldingInfo)state2).writeExternal(element);
    }

    @Override
    public CodeFoldingState readFoldingState(@NotNull Element element, @NotNull Document document) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "readFoldingState"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "readFoldingState"));
        }
        DocumentFoldingInfo info = this.getDocumentFoldingInfo(document);
        info.readExternal(element);
        return info;
    }

    @NotNull
    private DocumentFoldingInfo getDocumentFoldingInfo(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "getDocumentFoldingInfo"));
        }
        DocumentFoldingInfo info = (DocumentFoldingInfo)document.getUserData(this.myFoldingInfoInDocumentKey);
        if (info == null) {
            info = new DocumentFoldingInfo(this.myProject, document);
            DocumentFoldingInfo written = (DocumentFoldingInfo)((UserDataHolderEx)document).putUserDataIfAbsent(this.myFoldingInfoInDocumentKey, (Object)info);
            if (written == info) {
                this.myDocumentsWithFoldingInfo.add(document);
            } else {
                info = written;
            }
        }
        DocumentFoldingInfo documentFoldingInfo = info;
        if (documentFoldingInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "getDocumentFoldingInfo"));
        }
        return documentFoldingInfo;
    }

    private static void resetFoldingInfo(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "resetFoldingInfo"));
        }
        if (CodeFoldingManagerImpl.isFoldingsInitializedInDocument(document)) {
            Editor[] editors;
            for (Editor editor : editors = EditorFactory.getInstance().getEditors(document)) {
                EditorFoldingInfo.resetInfo(editor);
            }
            document.putUserData(FOLDING_STATE_KEY, null);
        }
    }

    static boolean isFoldingsInitializedInDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "isFoldingsInitializedInDocument"));
        }
        return Boolean.TRUE.equals(document.getUserData(FOLDING_STATE_KEY));
    }

    static boolean isFoldingsInitializedInEditor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl", "isFoldingsInitializedInEditor"));
        }
        return Boolean.TRUE.equals(editor.getUserData(FOLDING_STATE_KEY));
    }
}

