/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class DockablePopupManager<T extends JComponent> {
    protected ToolWindow myToolWindow;
    protected boolean myAutoUpdateDocumentation;
    protected Runnable myAutoUpdateRequest;
    @NotNull
    protected final Project myProject;

    public DockablePopupManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/documentation/DockablePopupManager", "<init>"));
        }
        this.myToolWindow = null;
        this.myAutoUpdateDocumentation = PropertiesComponent.getInstance().isTrueValue(this.getAutoUpdateEnabledProperty());
        this.myProject = project;
    }

    protected abstract String getShowInToolWindowProperty();

    protected abstract String getAutoUpdateEnabledProperty();

    protected abstract String getAutoUpdateTitle();

    protected abstract String getRestorePopupDescription();

    protected abstract String getAutoUpdateDescription();

    protected abstract T createComponent();

    protected abstract void doUpdateComponent(PsiElement var1, PsiElement var2, T var3);

    protected abstract void doUpdateComponent(Editor var1, PsiFile var2);

    protected abstract void doUpdateComponent(@NotNull PsiElement var1);

    protected abstract String getTitle(PsiElement var1);

    protected abstract String getToolwindowId();

    public Content recreateToolWindow(PsiElement element, PsiElement originalElement) {
        if (this.myToolWindow == null) {
            this.createToolWindow(element, originalElement);
            return null;
        }
        Content content = this.myToolWindow.getContentManager().getSelectedContent();
        if (content == null || !this.myToolWindow.isVisible()) {
            this.restorePopupBehavior();
            this.createToolWindow(element, originalElement);
            return null;
        }
        return content;
    }

    public void createToolWindow(PsiElement element, PsiElement originalElement) {
        assert (this.myToolWindow == null);
        T component = this.createComponent();
        ToolWindowManagerEx toolWindowManagerEx = ToolWindowManagerEx.getInstanceEx(this.myProject);
        ToolWindow toolWindow = toolWindowManagerEx.getToolWindow(this.getToolwindowId());
        this.myToolWindow = toolWindow == null ? toolWindowManagerEx.registerToolWindow(this.getToolwindowId(), true, ToolWindowAnchor.RIGHT, (Disposable)this.myProject) : toolWindow;
        this.myToolWindow.setIcon(AllIcons.Toolwindows.Documentation);
        this.myToolWindow.setAvailable(true, null);
        this.myToolWindow.setToHideOnEmptyContent(false);
        Rectangle rectangle = WindowManager.getInstance().getIdeFrame(this.myProject).suggestChildFrameBounds();
        this.myToolWindow.setDefaultState(ToolWindowAnchor.RIGHT, ToolWindowType.FLOATING, rectangle);
        ContentManager contentManager = this.myToolWindow.getContentManager();
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content = contentFactory.createContent(component, this.getTitle(element), false);
        contentManager.addContent(content);
        contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentRemoved(ContentManagerEvent event) {
                DockablePopupManager.this.restorePopupBehavior();
            }
        });
        new UiNotifyConnector(component, new Activatable(){

            public void showNotify() {
                DockablePopupManager.this.restartAutoUpdate(DockablePopupManager.this.myAutoUpdateDocumentation);
            }

            public void hideNotify() {
                DockablePopupManager.this.restartAutoUpdate(false);
            }
        });
        this.myToolWindow.show(null);
        PropertiesComponent.getInstance().setValue(this.getShowInToolWindowProperty(), Boolean.TRUE.toString());
        this.restartAutoUpdate(PropertiesComponent.getInstance().getBoolean(this.getAutoUpdateEnabledProperty(), true));
        this.doUpdateComponent(element, originalElement, component);
    }

    protected AnAction[] createActions() {
        ToggleAction toggleAutoUpdateAction = new ToggleAction(this.getAutoUpdateTitle(), this.getAutoUpdateDescription(), AllIcons.General.AutoscrollFromSource){

            public boolean isSelected(AnActionEvent e) {
                return DockablePopupManager.this.myAutoUpdateDocumentation;
            }

            public void setSelected(AnActionEvent e, boolean state2) {
                PropertiesComponent.getInstance().setValue(DockablePopupManager.this.getAutoUpdateEnabledProperty(), String.valueOf(state2));
                DockablePopupManager.this.myAutoUpdateDocumentation = state2;
                DockablePopupManager.this.restartAutoUpdate(state2);
            }
        };
        return new AnAction[]{toggleAutoUpdateAction, this.createRestorePopupAction()};
    }

    @NotNull
    protected AnAction createRestorePopupAction() {
        AnAction anAction = new AnAction("Restore Popup", this.getRestorePopupDescription(), AllIcons.Actions.Cancel){

            public void actionPerformed(AnActionEvent e) {
                DockablePopupManager.this.restorePopupBehavior();
            }
        };
        if (anAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/documentation/DockablePopupManager", "createRestorePopupAction"));
        }
        return anAction;
    }

    protected void restartAutoUpdate(boolean state2) {
        if (state2 && this.myToolWindow != null) {
            if (this.myAutoUpdateRequest == null) {
                this.myAutoUpdateRequest = new Runnable(){

                    @Override
                    public void run() {
                        DockablePopupManager.this.updateComponent();
                    }
                };
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IdeEventQueue.getInstance().addIdleListener(DockablePopupManager.this.myAutoUpdateRequest, 500);
                    }
                });
            }
        } else if (this.myAutoUpdateRequest != null) {
            IdeEventQueue.getInstance().removeIdleListener(this.myAutoUpdateRequest);
            this.myAutoUpdateRequest = null;
        }
    }

    public void updateComponent() {
        if (this.myProject.isDisposed()) {
            return;
        }
        DataManager.getInstance().getDataContextFromFocus().doWhenDone((Consumer)new Consumer<DataContext>(){

            public void consume(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/documentation/DockablePopupManager$7", "consume"));
                }
                if (!DockablePopupManager.this.myProject.isOpen()) {
                    return;
                }
                DockablePopupManager.this.updateComponentInner(dataContext);
            }
        });
    }

    private void updateComponentInner(@NotNull DataContext dataContext) {
        PsiFile psiFile;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/documentation/DockablePopupManager", "updateComponentInner"));
        }
        if (CommonDataKeys.PROJECT.getData(dataContext) != this.myProject) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element != null) {
                this.doUpdateComponent(element);
            }
            return;
        }
        PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)this.myProject);
        Editor injectedEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file);
        if (injectedEditor != null && (psiFile = PsiUtilBase.getPsiFileInEditor((Editor)injectedEditor, (Project)this.myProject)) != null) {
            this.doUpdateComponent(injectedEditor, psiFile);
            return;
        }
        if (file != null) {
            this.doUpdateComponent(editor, file);
        }
    }

    protected void restorePopupBehavior() {
        if (this.myToolWindow != null) {
            PropertiesComponent.getInstance().setValue(this.getShowInToolWindowProperty(), Boolean.FALSE.toString());
            ToolWindowManagerEx toolWindowManagerEx = ToolWindowManagerEx.getInstanceEx(this.myProject);
            toolWindowManagerEx.hideToolWindow(this.getToolwindowId(), false);
            toolWindowManagerEx.unregisterToolWindow(this.getToolwindowId());
            Disposer.dispose((Disposable)this.myToolWindow.getContentManager());
            this.myToolWindow = null;
            this.restartAutoUpdate(false);
        }
    }

    public boolean hasActiveDockedDocWindow() {
        return this.myToolWindow != null && this.myToolWindow.isVisible();
    }
}

