/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.tagTreeHighlighting;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.tagTreeHighlighting.XmlTagTreeHighlightingUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.ui.Gray;
import com.intellij.xml.breadcrumbs.BreadcrumbsInfoProvider;
import com.intellij.xml.breadcrumbs.BreadcrumbsXmlWrapper;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagTreeHighlightingPass
extends TextEditorHighlightingPass {
    private static final Key<List<RangeHighlighter>> TAG_TREE_HIGHLIGHTERS_IN_EDITOR_KEY = Key.create((String)"TAG_TREE_HIGHLIGHTERS_IN_EDITOR_KEY");
    private static final HighlightInfoType TYPE = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, TextAttributesKey.createTextAttributesKey((String)"TAG_TREE_HIGHLIGHTING_KEY"));
    private final PsiFile myFile;
    private final EditorEx myEditor;
    private final BreadcrumbsInfoProvider myInfoProvider;
    private final List<Pair<TextRange, TextRange>> myPairsToHighlight;

    public XmlTagTreeHighlightingPass(@NotNull PsiFile file, @NotNull EditorEx editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeHighlightingPass", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeHighlightingPass", "<init>"));
        }
        super(file.getProject(), editor.getDocument(), true);
        this.myPairsToHighlight = new ArrayList<Pair<TextRange, TextRange>>();
        this.myFile = file;
        this.myEditor = editor;
        FileViewProvider viewProvider = file.getManager().findViewProvider(file.getVirtualFile());
        this.myInfoProvider = BreadcrumbsXmlWrapper.findInfoProvider(viewProvider);
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeHighlightingPass", "doCollectInformation"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!WebEditorOptions.getInstance().isTagTreeHighlightingEnabled()) {
            return;
        }
        PsiElement[] elements = BreadcrumbsXmlWrapper.getLinePsiElements(this.myEditor.getCaretModel().getOffset(), this.myFile.getVirtualFile(), this.myProject, this.myInfoProvider);
        if (elements == null || elements.length == 0) {
            return;
        }
        if (!XmlTagTreeHighlightingUtil.containsTagsWithSameName(elements)) {
            return;
        }
        for (int i = elements.length - 1; i >= 0; --i) {
            if (!(elements[i] instanceof XmlTag)) continue;
            this.myPairsToHighlight.add(XmlTagTreeHighlightingPass.getTagRanges((XmlTag)elements[i]));
        }
    }

    @Nullable
    private static Pair<TextRange, TextRange> getTagRanges(XmlTag tag) {
        ASTNode tagNode = tag.getNode();
        return Pair.create((Object)XmlTagTreeHighlightingPass.getStartTagRange(tagNode), (Object)XmlTagTreeHighlightingPass.getEndTagRange(tagNode));
    }

    @Nullable
    private static TextRange getStartTagRange(ASTNode tagNode) {
        ASTNode startTagStart = XmlChildRole.START_TAG_START_FINDER.findChild(tagNode);
        if (startTagStart == null) {
            return null;
        }
        ASTNode tagName = startTagStart.getTreeNext();
        if (tagName == null || tagName.getElementType() != XmlTokenType.XML_NAME) {
            return null;
        }
        ASTNode next = tagName.getTreeNext();
        if (next != null && next.getElementType() == XmlTokenType.XML_TAG_END) {
            tagName = next;
        }
        return new TextRange(startTagStart.getStartOffset(), tagName.getTextRange().getEndOffset());
    }

    @Nullable
    private static TextRange getEndTagRange(ASTNode tagNode) {
        ASTNode endTagEnd;
        ASTNode endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(tagNode);
        if (endTagStart == null) {
            return null;
        }
        for (endTagEnd = endTagStart; endTagEnd != null && endTagEnd.getElementType() != XmlTokenType.XML_TAG_END; endTagEnd = endTagEnd.getTreeNext()) {
        }
        if (endTagEnd == null) {
            return null;
        }
        return new TextRange(endTagStart.getStartOffset(), endTagEnd.getTextRange().getEndOffset());
    }

    @Override
    public void doApplyInformationToEditor() {
        List<HighlightInfo> infos = this.getHighlights();
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, 0, this.myFile.getTextLength(), infos, this.getColorsScheme(), this.getId());
    }

    public List<HighlightInfo> getHighlights() {
        XmlTagTreeHighlightingPass.clearLineMarkers(this.myEditor);
        int count = this.myPairsToHighlight.size();
        ArrayList<HighlightInfo> highlightInfos = new ArrayList<HighlightInfo>(count * 2);
        MarkupModelEx markupModel = this.myEditor.getMarkupModel();
        Color[] baseColors = XmlTagTreeHighlightingUtil.getBaseColors();
        Color[] colorsForEditor = this.toColorsForEditor(baseColors);
        Color[] colorsForLineMarkers = XmlTagTreeHighlightingPass.toColorsForLineMarkers(baseColors);
        ArrayList<RangeHighlighter> newHighlighters = new ArrayList<RangeHighlighter>();
        assert (colorsForEditor.length > 0);
        for (int i = 0; i < count && i < baseColors.length; ++i) {
            Color color;
            Pair<TextRange, TextRange> pair = this.myPairsToHighlight.get(i);
            if (pair == null || pair.first == null && pair.second == null || (color = colorsForEditor[i]) == null) continue;
            if (pair.first != null && !((TextRange)pair.first).isEmpty()) {
                highlightInfos.add(XmlTagTreeHighlightingPass.createHighlightInfo(color, (TextRange)pair.first));
            }
            if (pair.second != null && !((TextRange)pair.second).isEmpty()) {
                highlightInfos.add(XmlTagTreeHighlightingPass.createHighlightInfo(color, (TextRange)pair.second));
            }
            int start = pair.first != null ? ((TextRange)pair.first).getStartOffset() : ((TextRange)pair.second).getStartOffset();
            int end = pair.second != null ? ((TextRange)pair.second).getEndOffset() : ((TextRange)pair.first).getEndOffset();
            Color lineMarkerColor = colorsForLineMarkers[i];
            if (lineMarkerColor == null || start == end) continue;
            RangeHighlighter highlighter = XmlTagTreeHighlightingPass.createHighlighter(markupModel, new TextRange(start, end), lineMarkerColor);
            newHighlighters.add(highlighter);
        }
        this.myEditor.putUserData(TAG_TREE_HIGHLIGHTERS_IN_EDITOR_KEY, newHighlighters);
        return highlightInfos;
    }

    private static void clearLineMarkers(Editor editor) {
        List oldHighlighters = (List)editor.getUserData(TAG_TREE_HIGHLIGHTERS_IN_EDITOR_KEY);
        if (oldHighlighters != null) {
            MarkupModelEx markupModel = (MarkupModelEx)editor.getMarkupModel();
            for (RangeHighlighter highlighter : oldHighlighters) {
                if (!markupModel.containsHighlighter(highlighter)) continue;
                highlighter.dispose();
            }
            editor.putUserData(TAG_TREE_HIGHLIGHTERS_IN_EDITOR_KEY, null);
        }
    }

    @NotNull
    private static HighlightInfo createHighlightInfo(Color color, @NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeHighlightingPass", "createHighlightInfo"));
        }
        TextAttributes attributes = new TextAttributes(null, color, null, null, 0);
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(TYPE).range(range).textAttributes(attributes).severity(HighlightSeverity.INFORMATION).createUnconditionally();
        if (highlightInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeHighlightingPass", "createHighlightInfo"));
        }
        return highlightInfo;
    }

    @NotNull
    private static RangeHighlighter createHighlighter(MarkupModel mm, @NotNull TextRange range, final Color color) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeHighlightingPass", "createHighlighter"));
        }
        RangeHighlighter highlighter = mm.addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 0, null, HighlighterTargetArea.LINES_IN_RANGE);
        highlighter.setLineMarkerRenderer(new LineMarkerRenderer(){

            public void paint(Editor editor, Graphics g, Rectangle r) {
                g.setColor(color);
                g.fillRect(r.x, r.y, 2, r.height);
            }
        });
        RangeHighlighter rangeHighlighter = highlighter;
        if (rangeHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeHighlightingPass", "createHighlighter"));
        }
        return rangeHighlighter;
    }

    private static Color[] toColorsForLineMarkers(Color[] baseColors) {
        Color[] colors = new Color[baseColors.length];
        Gray tagBackground = Gray._239;
        double transparency = 0.4;
        double factor = 0.8;
        for (int i = 0; i < colors.length; ++i) {
            Color color = baseColors[i];
            if (color == null) {
                colors[i] = null;
                continue;
            }
            int r = (int)((double)color.getRed() * 0.8);
            int g = (int)((double)color.getGreen() * 0.8);
            int b = (int)((double)color.getBlue() * 0.8);
            r = (int)((double)tagBackground.getRed() * 0.6 + (double)r * 0.4);
            g = (int)((double)tagBackground.getGreen() * 0.6 + (double)g * 0.4);
            b = (int)((double)tagBackground.getBlue() * 0.6 + (double)b * 0.4);
            colors[i] = new Color(r, g, b);
        }
        return colors;
    }

    private Color[] toColorsForEditor(Color[] baseColors) {
        Color tagBackground = this.myEditor.getBackgroundColor();
        if (tagBackground == null) {
            return baseColors;
        }
        Color[] resultColors = new Color[baseColors.length];
        double transparency = (double)WebEditorOptions.getInstance().getTagTreeHighlightingOpacity() * 0.01;
        for (int i = 0; i < resultColors.length; ++i) {
            Color color1;
            Color color = baseColors[i];
            resultColors[i] = color1 = color != null ? XmlTagTreeHighlightingUtil.makeTransparent(color, tagBackground, transparency) : null;
        }
        return resultColors;
    }

    public static void clearHighlightingAndLineMarkers(Editor editor, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeHighlightingPass", "clearHighlightingAndLineMarkers"));
        }
        MarkupModel markupModel = DocumentMarkupModel.forDocument(editor.getDocument(), project, true);
        for (RangeHighlighter highlighter : markupModel.getAllHighlighters()) {
            Object tooltip = highlighter.getErrorStripeTooltip();
            if (!(tooltip instanceof HighlightInfo) || ((HighlightInfo)tooltip).type != TYPE) continue;
            highlighter.dispose();
        }
        XmlTagTreeHighlightingPass.clearLineMarkers(editor);
    }
}

