/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.application.options.XmlSettings;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInsight.daemon.impl.analysis.ImportNSAction;
import com.intellij.codeInsight.daemon.impl.analysis.XmlNSRenderer;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateNSDeclarationIntentionFix
implements HintAction,
LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.analysis.CreateNSDeclarationIntentionFix");
    private final String myNamespacePrefix;
    private final PsiAnchor myElement;
    private final PsiAnchor myToken;

    @NotNull
    private XmlFile getFile() {
        XmlFile xmlFile = (XmlFile)this.myElement.getFile();
        if (xmlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix", "getFile"));
        }
        return xmlFile;
    }

    @Nullable
    public static CreateNSDeclarationIntentionFix createFix(@NotNull PsiElement element, @NotNull String namespacePrefix) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix", "createFix"));
        }
        if (namespacePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespacePrefix", "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix", "createFix"));
        }
        PsiFile file = element.getContainingFile();
        return file instanceof XmlFile ? new CreateNSDeclarationIntentionFix(element, namespacePrefix) : null;
    }

    protected CreateNSDeclarationIntentionFix(@NotNull PsiElement element, @NotNull String namespacePrefix) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix", "<init>"));
        }
        if (namespacePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespacePrefix", "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix", "<init>"));
        }
        this(element, namespacePrefix, null);
    }

    public CreateNSDeclarationIntentionFix(@NotNull PsiElement element, @NotNull String namespacePrefix, @Nullable XmlToken token) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix", "<init>"));
        }
        if (namespacePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespacePrefix", "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix", "<init>"));
        }
        this.myNamespacePrefix = namespacePrefix;
        this.myElement = PsiAnchor.create(element);
        this.myToken = token == null ? null : PsiAnchor.create((PsiElement)token);
    }

    @NotNull
    public String getText() {
        String alias = StringUtil.capitalize((String)this.getXmlExtension().getNamespaceAlias(this.getFile()));
        String string = XmlErrorMessages.message("create.namespace.declaration.quickfix", alias);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix", "getText"));
        }
        return string;
    }

    private XmlNamespaceHelper getXmlExtension() {
        return XmlNamespaceHelper.getHelper((PsiFile)this.getFile());
    }

    @NotNull
    public String getName() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiFile file;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix", "applyFix"));
        }
        PsiFile containingFile = descriptor.getPsiElement().getContainingFile();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        PsiFile psiFile = file = editor != null ? PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()) : null;
        if (file == null || !Comparing.equal((Object)file.getVirtualFile(), (Object)containingFile.getVirtualFile())) {
            return;
        }
        try {
            this.invoke(project, editor, containingFile);
        }
        catch (IncorrectOperationException ex) {
            LOG.error((Throwable)ex);
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix", "isAvailable"));
        }
        PsiElement element = this.myElement.retrieve();
        return element != null && element.isValid();
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        final PsiElement element = this.myElement.retrieve();
        if (element == null) {
            return;
        }
        Set<String> set = this.getXmlExtension().guessUnboundNamespaces(element, this.getFile());
        Object[] namespaces = ArrayUtil.toStringArray(set);
        Arrays.sort(namespaces);
        CreateNSDeclarationIntentionFix.runActionOverSeveralAttributeValuesAfterLettingUserSelectTheNeededOne((String[])namespaces, project, new StringToAttributeProcessor(){

            @Override
            public void doSomethingWithGivenStringToProduceXmlAttributeNowPlease(final @NotNull String namespace) throws IncorrectOperationException {
                if (namespace == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix$1", "doSomethingWithGivenStringToProduceXmlAttributeNowPlease"));
                }
                String prefix = CreateNSDeclarationIntentionFix.this.myNamespacePrefix;
                if (StringUtil.isEmpty((String)prefix)) {
                    XmlFile xmlFile = XmlExtension.getExtension(file).getContainingFile(element);
                    prefix = ExtendedTagInsertHandler.getPrefixByNamespace(xmlFile, namespace);
                    if (StringUtil.isNotEmpty((String)prefix)) {
                        ExtendedTagInsertHandler.qualifyWithPrefix(prefix, element);
                        return;
                    }
                    prefix = ExtendedTagInsertHandler.suggestPrefix(xmlFile, namespace);
                    if (!StringUtil.isEmpty((String)prefix)) {
                        ExtendedTagInsertHandler.qualifyWithPrefix(prefix, element);
                        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                    }
                }
                int offset = editor.getCaretModel().getOffset();
                final RangeMarker marker = editor.getDocument().createRangeMarker(offset, offset);
                XmlNamespaceHelper helper = XmlNamespaceHelper.getHelper(file);
                helper.insertNamespaceDeclaration((XmlFile)file, editor, Collections.singleton(namespace), prefix, new XmlNamespaceHelper.Runner<String, IncorrectOperationException>(){

                    @Override
                    public void run(String param) throws IncorrectOperationException {
                        if (!namespace.isEmpty()) {
                            editor.getCaretModel().moveToOffset(marker.getStartOffset());
                        }
                    }
                });
            }
        }, this.getTitle(), (IntentionAction)this, editor);
    }

    private String getTitle() {
        return XmlErrorMessages.message("select.namespace.title", StringUtil.capitalize((String)this.getXmlExtension().getNamespaceAlias(this.getFile())));
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix", "showHint"));
        }
        XmlToken token = null;
        if (this.myToken != null && (token = (XmlToken)this.myToken.retrieve()) == null) {
            return false;
        }
        if (!XmlSettings.getInstance().SHOW_XML_ADD_IMPORT_HINTS || this.myNamespacePrefix.isEmpty()) {
            return false;
        }
        PsiElement element = this.myElement.retrieve();
        if (element == null) {
            return false;
        }
        Set<String> namespaces = this.getXmlExtension().guessUnboundNamespaces(element, this.getFile());
        if (!namespaces.isEmpty()) {
            String message = ShowAutoImportPass.getMessage(namespaces.size() > 1, namespaces.iterator().next());
            String title = this.getTitle();
            ImportNSAction action = new ImportNSAction(namespaces, this.getFile(), element, editor, title);
            if (element instanceof XmlTag && token != null) {
                if (VisibleHighlightingPassFactory.calculateVisibleRange(editor).contains(token.getTextRange())) {
                    HintManager.getInstance().showQuestionHint(editor, message, token.getTextOffset(), token.getTextOffset() + this.myNamespacePrefix.length(), (QuestionAction)action);
                    return true;
                }
            } else {
                HintManager.getInstance().showQuestionHint(editor, message, element.getTextOffset(), element.getTextRange().getEndOffset(), (QuestionAction)action);
                return true;
            }
        }
        return false;
    }

    private static boolean checkIfGivenXmlHasTheseWords(String name, XmlFile tldFileByUri) {
        if (name == null || name.isEmpty()) {
            return true;
        }
        List list = StringUtil.getWordsIn((String)name);
        final String[] words = ArrayUtil.toStringArray((Collection)list);
        final boolean[] wordsFound = new boolean[words.length];
        final int[] wordsFoundCount = new int[1];
        IdTableBuilding.ScanWordProcessor wordProcessor = new IdTableBuilding.ScanWordProcessor(){

            @Override
            public void run(CharSequence chars, @Nullable char[] charsArray, int start, int end) {
                if (wordsFoundCount[0] == words.length) {
                    return;
                }
                int foundWordLen = end - start;
                block0: for (int i = 0; i < words.length; ++i) {
                    String localName = words[i];
                    if (wordsFound[i] || localName.length() != foundWordLen) continue;
                    for (int j = 0; j < localName.length(); ++j) {
                        if (chars.charAt(start + j) != localName.charAt(j)) continue block0;
                    }
                    wordsFound[i] = true;
                    wordsFoundCount[0] = wordsFoundCount[0] + 1;
                    break;
                }
            }
        };
        CharSequence contents = tldFileByUri.getViewProvider().getContents();
        IdTableBuilding.scanWords(wordProcessor, contents, 0, contents.length());
        return wordsFoundCount[0] == words.length;
    }

    public static void runActionOverSeveralAttributeValuesAfterLettingUserSelectTheNeededOne(@NotNull String[] namespacesToChooseFrom, Project project, StringToAttributeProcessor onSelection, String title, IntentionAction requestor, Editor editor) throws IncorrectOperationException {
        if (namespacesToChooseFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespacesToChooseFrom", "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix", "runActionOverSeveralAttributeValuesAfterLettingUserSelectTheNeededOne"));
        }
        if (namespacesToChooseFrom.length > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
            JBList list = new JBList((Object[])namespacesToChooseFrom);
            list.setCellRenderer(XmlNSRenderer.INSTANCE);
            Runnable runnable = new Runnable((JList)list, project, onSelection, namespacesToChooseFrom, requestor){
                final /* synthetic */ JList val$list;
                final /* synthetic */ Project val$project;
                final /* synthetic */ StringToAttributeProcessor val$onSelection;
                final /* synthetic */ String[] val$namespacesToChooseFrom;
                final /* synthetic */ IntentionAction val$requestor;
                {
                    this.val$list = jList;
                    this.val$project = project;
                    this.val$onSelection = stringToAttributeProcessor;
                    this.val$namespacesToChooseFrom = stringArray;
                    this.val$requestor = intentionAction;
                }

                @Override
                public void run() {
                    final int index = this.val$list.getSelectedIndex();
                    if (index < 0) {
                        return;
                    }
                    PsiDocumentManager.getInstance((Project)this.val$project).commitAllDocuments();
                    CommandProcessor.getInstance().executeCommand(this.val$project, new Runnable(){

                        @Override
                        public void run() {
                            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        val$onSelection.doSomethingWithGivenStringToProduceXmlAttributeNowPlease(val$namespacesToChooseFrom[index]);
                                    }
                                    catch (IncorrectOperationException ex) {
                                        throw new RuntimeException(ex);
                                    }
                                }
                            });
                        }
                    }, this.val$requestor.getText(), (Object)this.val$requestor.getFamilyName());
                }
            };
            new PopupChooserBuilder((JList)list).setTitle(title).setItemChoosenCallback(runnable).createPopup().showInBestPositionFor(editor);
        } else {
            onSelection.doSomethingWithGivenStringToProduceXmlAttributeNowPlease(namespacesToChooseFrom.length == 0 ? "" : namespacesToChooseFrom[0]);
        }
    }

    public static void processExternalUris(final MetaHandler metaHandler, final PsiFile file, final ExternalUriProcessor processor, boolean showProgress) {
        if (!showProgress || ApplicationManager.getApplication().isUnitTestMode()) {
            CreateNSDeclarationIntentionFix.processExternalUrisImpl(metaHandler, file, processor);
        } else {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    CreateNSDeclarationIntentionFix.processExternalUrisImpl(metaHandler, file, processor);
                }
            }, XmlErrorMessages.message("finding.acceptable.uri", new Object[0]), false, file.getProject());
        }
    }

    private static void processExternalUrisImpl(MetaHandler metaHandler, PsiFile file, ExternalUriProcessor processor) {
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        String searchFor = metaHandler.searchFor();
        if (pi != null) {
            pi.setText(XmlErrorMessages.message("looking.in.schemas", new Object[0]));
        }
        ExternalResourceManager instanceEx = ExternalResourceManager.getInstance();
        String[] availableUrls = instanceEx.getResourceUrls(null, true);
        int i = 0;
        for (String url : availableUrls) {
            String defaultNamespace;
            boolean wordFound;
            XmlFile xmlFile;
            if (pi != null) {
                pi.setFraction((double)i / (double)availableUrls.length);
                pi.setText2(url);
                ++i;
            }
            if ((xmlFile = XmlUtil.findNamespace(file, url)) == null || !(wordFound = CreateNSDeclarationIntentionFix.checkIfGivenXmlHasTheseWords(searchFor, xmlFile))) continue;
            XmlDocument document = xmlFile.getDocument();
            assert (document != null);
            PsiMetaData metaData = document.getMetaData();
            if (!metaHandler.isAcceptableMetaData(metaData, url)) continue;
            XmlNSDescriptorImpl descriptor = metaData instanceof XmlNSDescriptorImpl ? (XmlNSDescriptorImpl)metaData : null;
            String string = defaultNamespace = descriptor != null ? descriptor.getDefaultNamespace() : url;
            if ("http://www.w3.org/1999/XMLSchema".equals(defaultNamespace) || "http://www.w3.org/2000/10/XMLSchema".equals(defaultNamespace)) continue;
            processor.process(defaultNamespace, url);
        }
    }

    public static interface ExternalUriProcessor {
        public void process(@NotNull String var1, @Nullable String var2);
    }

    public static class TagMetaHandler
    implements MetaHandler {
        private final String myName;

        public TagMetaHandler(String name) {
            this.myName = name;
        }

        @Override
        public boolean isAcceptableMetaData(PsiMetaData metaData, String url) {
            if (metaData instanceof XmlNSDescriptorImpl) {
                XmlNSDescriptorImpl nsDescriptor = (XmlNSDescriptorImpl)metaData;
                XmlElementDescriptor descriptor = nsDescriptor.getElementDescriptor(this.searchFor(), url);
                return descriptor != null && !(descriptor instanceof AnyXmlElementDescriptor);
            }
            return false;
        }

        @Override
        public String searchFor() {
            return this.myName;
        }
    }

    public static interface MetaHandler {
        public boolean isAcceptableMetaData(PsiMetaData var1, String var2);

        public String searchFor();
    }

    public static interface StringToAttributeProcessor {
        public void doSomethingWithGivenStringToProduceXmlAttributeNowPlease(@NonNls @NotNull String var1) throws IncorrectOperationException;
    }
}

