/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.ide.PowerSaveMode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HintHint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.ui.AwtVisitor;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrafficProgressPanel
extends JPanel {
    private static final int MAX = 100;
    private static final String MAX_TEXT = "100%";
    private static final String MIN_TEXT = "0%";
    private final JLabel statistics;
    private final Map<ProgressableTextEditorHighlightingPass, Pair<JProgressBar, JLabel>> passes;
    private final Map<JProgressBar, JLabel> myProgressToText;
    private final JLabel statusLabel;
    private final JLabel dumbLabel;
    @NotNull
    private final TrafficLightRenderer myTrafficLightRenderer;
    private final JPanel myPassStatuses;
    private final JPanel myEmptyPassStatuses;
    private final Wrapper myPassStatusesContainer;
    @NotNull
    private final HintHint myHintHint;

    public TrafficProgressPanel(@NotNull TrafficLightRenderer trafficLightRenderer, @NotNull Editor editor, @NotNull HintHint hintHint) {
        if (trafficLightRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trafficLightRenderer", "com/intellij/codeInsight/daemon/impl/TrafficProgressPanel", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/TrafficProgressPanel", "<init>"));
        }
        if (hintHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintHint", "com/intellij/codeInsight/daemon/impl/TrafficProgressPanel", "<init>"));
        }
        this.statistics = new JLabel();
        this.passes = new LinkedHashMap();
        this.myProgressToText = new HashMap();
        this.statusLabel = new JLabel();
        this.dumbLabel = new JLabel("Complete results will be available after indexing");
        this.myPassStatuses = new JPanel();
        this.myEmptyPassStatuses = new NonOpaquePanel();
        this.myPassStatusesContainer = new Wrapper();
        this.myHintHint = hintHint;
        this.myTrafficLightRenderer = trafficLightRenderer;
        this.setLayout(new BorderLayout());
        VerticalBox center = new VerticalBox();
        this.add((Component)center, "North");
        center.add((Component)this.statusLabel);
        center.add((Component)this.dumbLabel);
        center.add((Component)((Object)new Separator()));
        center.add(Box.createVerticalStrut(6));
        TrafficLightRenderer.DaemonCodeAnalyzerStatus fakeStatusLargeEnough = new TrafficLightRenderer.DaemonCodeAnalyzerStatus();
        fakeStatusLargeEnough.errorCount = new int[]{1, 1, 1, 1};
        Project project = trafficLightRenderer.getProject();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        fakeStatusLargeEnough.passStati = new ArrayList<ProgressableTextEditorHighlightingPass>();
        for (int i = 0; i < 3; ++i) {
            fakeStatusLargeEnough.passStati.add(new ProgressableTextEditorHighlightingPass(project, null, DaemonBundle.message((String)"pass.wolf", (Object[])new Object[0]), psiFile, editor, TextRange.EMPTY_RANGE, false, HighlightInfoProcessor.getEmpty()){

                @Override
                protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
                    if (progress == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/TrafficProgressPanel$1", "collectInformationWithProgress"));
                    }
                }

                @Override
                protected void applyInformationWithProgress() {
                }
            });
        }
        this.rebuildPassesPanel(fakeStatusLargeEnough);
        for (Pair<JProgressBar, JLabel> pair : this.passes.values()) {
            JProgressBar bar = (JProgressBar)pair.first;
            bar.setMaximum(100);
            JLabel label = (JLabel)pair.second;
            label.setText(MAX_TEXT);
        }
        center.add((Component)this.myPassStatusesContainer);
        this.add((Component)this.statistics, "South");
        this.updatePanel(fakeStatusLargeEnough, true);
        hintHint.initStyle(this, true);
    }

    private void rebuildPassesPanel(@Nullable TrafficLightRenderer.DaemonCodeAnalyzerStatus status) {
        this.myPassStatuses.removeAll();
        this.myPassStatuses.setLayout(new GridBagLayout());
        this.passes.clear();
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.fill = 2;
        if (status != null) {
            for (ProgressableTextEditorHighlightingPass pass : status.passStati) {
                JLabel label = new JLabel(pass.getPresentableName() + ": ");
                label.setHorizontalTextPosition(4);
                JProgressBar progressBar = new JProgressBar(0, 100);
                progressBar.putClientProperty("JComponent.sizeVariant", "mini");
                JLabel percLabel = new JLabel();
                this.passes.put(pass, (Pair<JProgressBar, JLabel>)Pair.create((Object)progressBar, (Object)percLabel));
                this.myProgressToText.put(progressBar, percLabel);
                c.gridx = 0;
                this.myPassStatuses.add((Component)label, c);
                c.gridx = 1;
                this.myPassStatuses.add((Component)progressBar, c);
                c.gridx = 2;
                c.weightx = 1.0;
                this.myPassStatuses.add((Component)percLabel, c);
                ++c.gridy;
            }
        }
        this.myHintHint.initStyle(this.myPassStatuses, true);
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePanel(@Nullable TrafficLightRenderer.DaemonCodeAnalyzerStatus status, boolean isFake) {
        boolean isDumb = DumbService.isDumb((Project)this.myTrafficLightRenderer.getProject());
        this.dumbLabel.setVisible(isDumb);
        try {
            if (PowerSaveMode.isEnabled()) {
                this.statusLabel.setText("Code analysis is disabled in power save mode");
                this.myPassStatuses.setVisible(false);
                this.statistics.setText("");
            } else if (status == null || status.noHighlightingRoots != null && status.noHighlightingRoots.length == status.rootsNumber) {
                this.statusLabel.setText(DaemonBundle.message((String)"analysis.hasnot.been.run", (Object[])new Object[0]));
                this.myPassStatuses.setVisible(true);
                this.setPassesEnabled(false, Boolean.FALSE);
                this.statistics.setText("");
            } else if (status.errorAnalyzingFinished) {
                if (isDumb) {
                    this.statusLabel.setText("Shallow analysis completed");
                } else {
                    this.statusLabel.setText(DaemonBundle.message((String)"analysis.completed", (Object[])new Object[0]));
                }
                this.myPassStatuses.setVisible(true);
                this.setPassesEnabled(false, Boolean.TRUE);
            } else if (!status.enabled) {
                this.statusLabel.setText("Code analysis has been suspended");
                this.myPassStatuses.setVisible(true);
                this.setPassesEnabled(false, Boolean.FALSE);
                this.statistics.setText("");
            } else {
                this.statusLabel.setText(DaemonBundle.message((String)"performing.code.analysis", (Object[])new Object[0]));
                this.myPassStatuses.setVisible(true);
                this.setPassesEnabled(true, null);
            }
            if (status == null || !((Object)status.passStati).equals(new ArrayList<ProgressableTextEditorHighlightingPass>(this.passes.keySet()))) {
                this.rebuildPassesPanel(status);
            }
            if (status != null) {
                for (ProgressableTextEditorHighlightingPass pass : status.passStati) {
                    double progress = pass.getProgress();
                    Pair<JProgressBar, JLabel> pair = this.passes.get(pass);
                    JProgressBar progressBar = (JProgressBar)pair.first;
                    int percent = (int)Math.round(progress * 100.0);
                    progressBar.setValue(percent);
                    JLabel percentage = (JLabel)pair.second;
                    percentage.setText(percent + "%");
                }
                int currentSeverityErrors = 0;
                String text = "";
                for (int i = status.errorCount.length - 1; i >= 0; --i) {
                    if (status.errorCount[i] <= 0) continue;
                    HighlightSeverity severity = SeverityRegistrar.getSeverityRegistrar(this.myTrafficLightRenderer.getProject()).getSeverityByIndex(i);
                    String name = status.errorCount[i] > 1 ? StringUtil.pluralize((String)severity.getName().toLowerCase()) : severity.getName().toLowerCase();
                    text = text + (status.errorAnalyzingFinished ? DaemonBundle.message((String)"errors.found", (Object[])new Object[]{status.errorCount[i], name}) : DaemonBundle.message((String)"errors.found.so.far", (Object[])new Object[]{status.errorCount[i], name}));
                    text = text + "<br>";
                    currentSeverityErrors += status.errorCount[i];
                }
                if (currentSeverityErrors == 0) {
                    text = text + (status.errorAnalyzingFinished ? DaemonBundle.message((String)"no.errors.or.warnings.found", (Object[])new Object[0]) : DaemonBundle.message((String)"no.errors.or.warnings.found.so.far", (Object[])new Object[0]) + "<br>");
                }
                this.statistics.setText(XmlStringUtil.wrapInHtml((CharSequence)text));
            }
        }
        finally {
            if (isFake) {
                this.myEmptyPassStatuses.setPreferredSize(this.myPassStatuses.getPreferredSize());
                this.myPassStatusesContainer.setContent((JComponent)this.myEmptyPassStatuses);
            } else {
                this.myPassStatusesContainer.setContent((JComponent)this.myPassStatuses);
            }
        }
    }

    private void setPassesEnabled(final boolean enabled, final @Nullable Boolean completed) {
        new AwtVisitor(this.myPassStatuses){

            public boolean visit(Component component) {
                if (component instanceof JProgressBar) {
                    JProgressBar progress = (JProgressBar)component;
                    progress.setEnabled(enabled);
                    if (completed != null) {
                        if (completed.booleanValue()) {
                            progress.setValue(100);
                            ((JLabel)TrafficProgressPanel.this.myProgressToText.get(progress)).setText(TrafficProgressPanel.MAX_TEXT);
                        } else {
                            progress.setValue(0);
                            ((JLabel)TrafficProgressPanel.this.myProgressToText.get(progress)).setText(TrafficProgressPanel.MIN_TEXT);
                        }
                    }
                }
                return false;
            }
        };
    }

    private class Separator
    extends NonOpaquePanel {
        private Separator() {
        }

        protected void paintComponent(@NotNull Graphics g) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/codeInsight/daemon/impl/TrafficProgressPanel$Separator", "paintComponent"));
            }
            Insets insets = this.getInsets();
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            g.setColor(TrafficProgressPanel.this.myHintHint.getTextForeground());
            g.drawLine(insets.left, insets.top, this.getWidth() - insets.left - insets.right, insets.top);
        }

        @NotNull
        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension(1, 1);
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/TrafficProgressPanel$Separator", "getPreferredSize"));
            }
            return dimension;
        }

        @NotNull
        public Dimension getMinimumSize() {
            Dimension dimension = new Dimension(1, 1);
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/TrafficProgressPanel$Separator", "getMinimumSize"));
            }
            return dimension;
        }
    }
}

