/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.ExternalToolPass;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalToolPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    private final MergingUpdateQueue myExternalActivitiesQueue;

    public ExternalToolPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        super(project);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{5}, null, true, 8);
        this.myExternalActivitiesQueue = new MergingUpdateQueue("ExternalActivitiesQueue", 300, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)project, null, false);
        this.myExternalActivitiesQueue.setPassThrough(ApplicationManager.getApplication().isUnitTestMode());
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ExternalToolPassFactory" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ExternalToolPassFactory", "getComponentName"));
        }
        return "ExternalToolPassFactory";
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        TextRange textRange;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ExternalToolPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ExternalToolPassFactory", "createHighlightingPass"));
        }
        TextRange textRange2 = textRange = FileStatusMap.getDirtyTextRange(editor, 8) == null ? null : file.getTextRange();
        if (textRange == null || !ExternalToolPassFactory.externalAnnotatorsDefined(file)) {
            return null;
        }
        return new ExternalToolPass(this, file, editor, textRange.getStartOffset(), textRange.getEndOffset());
    }

    private static boolean externalAnnotatorsDefined(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ExternalToolPassFactory", "externalAnnotatorsDefined"));
        }
        for (Language language : file.getViewProvider().getLanguages()) {
            List externalAnnotators = ExternalLanguageAnnotators.allForFile((Language)language, (PsiFile)file);
            if (externalAnnotators.isEmpty()) continue;
            return true;
        }
        return false;
    }

    void scheduleExternalActivity(@NotNull Update update) {
        if (update == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "update", "com/intellij/codeInsight/daemon/impl/ExternalToolPassFactory", "scheduleExternalActivity"));
        }
        this.myExternalActivitiesQueue.queue(update);
    }
}

